/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.tools;

import com.horizon.dom4j.Attribute;
import com.horizon.dom4j.Document;
import com.horizon.dom4j.DocumentException;
import com.horizon.dom4j.DocumentHelper;
import com.horizon.dom4j.Element;
import com.horizon.dom4j.io.SAXReader;
import com.horizon.wf.definition.tools.ElementImpl;
import com.horizon.wf.definition.tools.HZElement;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class XMLParseUtil {
    public static HZElement convertStringToXML(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)text);
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (doc == null) {
            return null;
        }
        Element root = doc.getRootElement();
        return ElementImpl.getHZElement(root);
    }

    public static HZElement convertStreamToXML(InputStream in) {
        Document doc = null;
        try {
            SAXReader reader = new SAXReader();
            doc = reader.read(in);
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (doc == null) {
            return null;
        }
        return ElementImpl.getHZElement(doc.getRootElement());
    }

    public static HZElement convertFileToXML(String filePath) {
        Document doc = null;
        try {
            SAXReader reader = new SAXReader();
            doc = reader.read(filePath);
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        if (doc == null) {
            return null;
        }
        return ElementImpl.getHZElement(doc.getRootElement());
    }

    public static HZElement convertFileToXML(File file) {
        Document doc = null;
        try {
            SAXReader reader = new SAXReader();
            doc = reader.read(file);
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        if (doc == null) {
            return null;
        }
        return ElementImpl.getHZElement(doc.getRootElement());
    }

    public static String getAttribute(HZElement XML, String nodename, String attname) {
        return XMLParseUtil.getAttribute("", XML, nodename, attname);
    }

    public static String getAttribute(String defaultValue, HZElement XML, String nodename, String attname) {
        HZElement subXML = XMLParseUtil.getElement(XML, nodename);
        return XMLParseUtil.getAttribute(defaultValue, subXML, attname);
    }

    public static String getAttribute(HZElement XML, String attname) {
        return XMLParseUtil.getAttribute("", XML, attname);
    }

    public static String getAttribute(String defaultValue, HZElement XML, String attname) {
        if (XML == null) {
            return defaultValue;
        }
        Attribute attribute = XML.getElement().attribute(attname);
        if (attribute == null) {
            return defaultValue;
        }
        String tmpValue = attribute.getValue();
        if (tmpValue.length() == 0) {
            return defaultValue;
        }
        return tmpValue;
    }

    public static void setAttribute(HZElement XML, String nodename, String attname, String attvalue) {
        Attribute attribute = (Attribute)XML.getElement().selectSingleNode(nodename + "/@" + attname);
        if (attribute == null) {
            return;
        }
        attribute.setValue(attvalue);
    }

    public static void setAttribute(HZElement XML, String attname, String attvalue) {
        if (XML == null) {
            return;
        }
        XML.getElement().addAttribute(attname, attvalue);
    }

    public static void removeAttribute(HZElement XML, String attname) {
        if (XML == null) {
            return;
        }
        Attribute attribute = XML.getElement().attribute(attname);
        XML.getElement().remove(attribute);
    }

    public static String getText(HZElement XML, String nodename) {
        HZElement tmpElement = XMLParseUtil.getElement(XML, nodename);
        if (tmpElement == null) {
            return "";
        }
        return tmpElement.getElement().getText();
    }

    public static String getTextTrim(HZElement XML, String nodename) {
        HZElement tmpElement = XMLParseUtil.getElement(XML, nodename);
        if (tmpElement == null) {
            return "";
        }
        return tmpElement.getElement().getTextTrim();
    }

    public static String getText(HZElement XML) {
        if (XML == null) {
            return "";
        }
        return XML.getElement().getText();
    }

    public static String getTextTrim(HZElement XML) {
        if (XML == null) {
            return "";
        }
        return XML.getElement().getTextTrim();
    }

    public static void setText(HZElement XML, String nodename, String Text) {
        HZElement tmpElement = XMLParseUtil.getElement(XML, nodename);
        if (tmpElement == null) {
            return;
        }
        tmpElement.getElement().setText(Text);
    }

    public static void setTextAdd(HZElement XML, String nodename, String Text) {
        HZElement tmpElement = XMLParseUtil.getElementAdd(XML, nodename);
        if (tmpElement == null) {
            return;
        }
        if (Text == null) {
            Text = "";
        }
        tmpElement.getElement().setText(Text);
    }

    public static void setText(HZElement XML, String Text) {
        if (XML == null) {
            return;
        }
        if (Text == null) {
            Text = "";
        }
        XML.getElement().setText(Text);
    }

    public static HZElement getElement(HZElement XML, String nodename, String attname, String attvalue) {
        StringBuilder sb = new StringBuilder();
        sb.append(nodename);
        sb.append("[@");
        sb.append(attname);
        sb.append("='");
        sb.append(attvalue);
        sb.append("']");
        Element tmpElement = (Element)XML.getElement().selectSingleNode(sb.toString());
        return ElementImpl.getHZElement(tmpElement);
    }

    public static List<HZElement> getElements(HZElement XML, String nodename, String attname, String attvalue) {
        StringBuilder sb = new StringBuilder();
        sb.append(nodename);
        sb.append("[@");
        sb.append(attname);
        sb.append("='");
        sb.append(attvalue);
        sb.append("']");
        List list = XML.getElement().selectNodes(sb.toString());
        return ElementImpl.getHZElementList(list);
    }

    public static HZElement getElement(HZElement XML, String nodename) {
        if (nodename.length() == 0) {
            return XML;
        }
        Element tmpElement = (Element)XML.getElement().selectSingleNode(nodename);
        return ElementImpl.getHZElement(tmpElement);
    }

    private static Element _getElement(HZElement XML, String nodename) {
        if (nodename.length() == 0) {
            return XML.getElement();
        }
        Element tmpElement = (Element)XML.getElement().selectSingleNode(nodename);
        return tmpElement;
    }

    public static HZElement getElementAdd(HZElement XML, String nodename) {
        if (nodename.length() == 0) {
            return XML;
        }
        HZElement tmpElement = XMLParseUtil.getElement(XML, nodename);
        if (tmpElement == null) {
            String tmpNodeName = nodename.indexOf("/") == -1 ? "" : nodename.substring(0, nodename.lastIndexOf("/"));
            String addNodeName = nodename.indexOf("/") == -1 ? nodename : nodename.substring(nodename.lastIndexOf("/") + 1);
            HZElement preElement = XMLParseUtil.getElementAdd(XML, tmpNodeName);
            return XMLParseUtil.addElement(preElement, addNodeName);
        }
        return tmpElement;
    }

    public static List<HZElement> getElements(HZElement XML, String nodename) {
        return ElementImpl.getHZElementList(XML.getElement().selectNodes(nodename));
    }

    public static List<HZElement> getElementList(HZElement XML, String nodename) {
        if (nodename.length() == 0) {
            return ElementImpl.getHZElementList(XML.getElement().elements());
        }
        Element tmpElement = XMLParseUtil._getElement(XML, nodename);
        if (tmpElement == null) {
            return null;
        }
        return ElementImpl.getHZElementList(tmpElement.elements());
    }

    public static int getLength(List<Object> XMLs) {
        if (XMLs == null) {
            return 0;
        }
        return XMLs.size();
    }

    public static HZElement addElement(HZElement XML, String nodeName) {
        if (XML == null || nodeName == null || nodeName.length() == 0) {
            return null;
        }
        Element tmpXML = DocumentHelper.createElement((String)nodeName);
        XML.getElement().add(tmpXML);
        return ElementImpl.getHZElement(tmpXML);
    }

    public static HZElement getNewElement(String nodeName) {
        if (nodeName == null || nodeName.length() == 0) {
            return null;
        }
        return ElementImpl.getHZElement(DocumentHelper.createElement((String)nodeName));
    }

    public static void addElement(HZElement XML, HZElement addXML) {
        XML.getElement().add(addXML.getElement());
    }

    public static boolean removeNode(HZElement XML, String nodename) {
        if (nodename.length() == 0) {
            return true;
        }
        HZElement tmpElement = XMLParseUtil.getElement(XML, nodename);
        if (tmpElement == null) {
            return true;
        }
        String parentNodeName = nodename.indexOf("/") == -1 ? "" : nodename.substring(0, nodename.lastIndexOf("/"));
        HZElement parentXML = XMLParseUtil.getElement(XML, parentNodeName);
        if (parentXML == null) {
            return true;
        }
        return parentXML.getElement().remove(tmpElement.getElement());
    }

    public static boolean removeNode(HZElement XML, HZElement delXML) {
        if (XML == null || delXML == null) {
            return true;
        }
        return XML.getElement().remove(delXML.getElement());
    }

    public static boolean remove(HZElement XML) {
        Element parent = XML.getElement().getParent();
        if (parent == null) {
            return false;
        }
        return parent.remove(XML.getElement());
    }

    public static HZElement getParent(HZElement XML) {
        Element parent = XML.getElement().getParent();
        return ElementImpl.getHZElement(parent);
    }
}

