/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.definition.json.JSONDefinitionBase;
import com.horizon.wf.definition.json.JSONRelation;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.pub.node.user.IUserRelation;
import java.util.ArrayList;
import java.util.List;

public class JSONUser
extends JSONDefinitionBase
implements INodeAuthUser {
    public JSONUser(JSONObject json) {
        super(json);
    }

    public JSONUser(Object json) {
        super(json);
    }

    @Override
    public String getAuthName() {
        return this.getString("authId");
    }

    public void setAuthName(String name) {
        this.put("authId", name);
    }

    @Override
    public String getAuthCnName() {
        return this.getString("authName");
    }

    public void setAuthCnName(String name) {
        this.put("authName", name);
    }

    @Override
    public String getSendMsgFlag() {
        return this.getString("msgFlag");
    }

    public void setSendMsgFlag(String msgFlag) {
        this.put("msgFlag", msgFlag);
    }

    @Override
    public String getFreeSelectArea() {
        return this.getString("select");
    }

    @Override
    public String getControlAttribute() {
        return this.getString("control");
    }

    public void setControlAttribute(String control) {
        this.put("control", control);
    }

    @Override
    public String getNodeForPassNodeUser() {
        return this.getString("passNode");
    }

    public void setNodeForPassNodeUser(String node) {
        this.put("passNode", node);
    }

    @Override
    public String getPerson() {
        return this.getString("person");
    }

    public void setPerson(String person) {
        this.put("person", person);
    }

    @Override
    public String getGroup() {
        return this.getString("group");
    }

    public void setGroup(String group) {
        this.put("group", group);
    }

    @Override
    public String getDept() {
        return this.getString("dept");
    }

    public void setDept(String dept) {
        this.put("dept", dept);
    }

    @Override
    public String getPosition() {
        return this.getString("position");
    }

    public void setPosition(String position) {
        this.put("position", position);
    }

    @Override
    public String getRole() {
        return this.getString("role");
    }

    public void setRole(String role) {
        this.put("role", role);
    }

    @Override
    public String getFormField() {
        return this.getString(this.getJSONObjAdd("formField"), "name");
    }

    public void setFormField(String field) {
        this.getJSONObjAdd("formField").put("name", (Object)field);
    }

    @Override
    public String getFormFieldUnion() {
        return this.getString(this.getJSONObjAdd("formField"), "union");
    }

    public void setFormFieldUnion(String union) {
        this.getJSONObjAdd("formField").put("union", (Object)union);
    }

    @Override
    public String getFlowVar() {
        return this.getString(this.getJSONObjAdd("flowVar"), "name");
    }

    public void setFlowVar(String var) {
        this.getJSONObjAdd("flowVar").put("name", (Object)var);
    }

    @Override
    public String getFlowVardUnion() {
        return this.getString(this.getJSONObjAdd("flowVar"), "union");
    }

    public void setFlowVarUnion(String union) {
        this.getJSONObjAdd("flowVar").put("union", (Object)union);
    }

    @Override
    public String getCustome() {
        return this.getString(this.getJSONObjAdd("customer"), "memo");
    }

    public void setCustome(String memo) {
        this.getJSONObjAdd("customer").put("memo", (Object)memo);
    }

    @Override
    public String getCustome_ClassName() {
        return this.getString(this.getJSONObjAdd("customer"), "className");
    }

    public void setCustome_ClassName(String className) {
        this.getJSONObjAdd("customer").put("className", (Object)className);
    }

    @Override
    public boolean getCustome_Active() {
        return this.getJSONObjAdd("customer").getIntValue("check") == 1;
    }

    public void setCustome_Active(int active) {
        this.getJSONObjAdd("customer").put("check", (Object)active);
    }

    @Override
    public String getRuleScript() {
        return this.getString(this.getJSONObjAdd("rule"), "script");
    }

    public void setRuleScript(String id, String script, String text) {
        this.setRuleToObj(this.getJSONObjAdd("rule"), id, script, text);
    }

    @Override
    public List<IUserRelation> getAllRelations() {
        ArrayList<IUserRelation> relations = new ArrayList<IUserRelation>();
        JSONArray relationArr = this.getJSONArray("relation");
        if (relationArr == null) {
            return relations;
        }
        int n = relationArr.size();
        for (int i = 0; i < n; ++i) {
            JSONObject relation = relationArr.getJSONObject(i);
            relations.add(new JSONRelation(relation));
        }
        return relations;
    }

    public void setAllRelations(List<JSONRelation> relations) {
        if (relations == null || relations.isEmpty()) {
            return;
        }
        JSONArray relationArr = this.getJSONArrAdd("relation");
        for (JSONRelation relation : relations) {
            relationArr.add((Object)relation.getJson());
        }
    }

    private void addFix(StringBuilder sb, String fix, String tmpUser, boolean isGather) {
        if (tmpUser.length() != 0) {
            String[] users;
            tmpUser = tmpUser.replaceAll("\\|", ";");
            for (String u : users = tmpUser.split(";")) {
                if (isGather) {
                    sb.append("/");
                }
                if (!u.startsWith(fix)) {
                    sb.append(fix);
                }
                sb.append(u).append(";");
            }
        }
    }

    @Override
    public String getUserFromOrg() {
        StringBuilder sb = new StringBuilder(2000);
        String tmpUser = this.getPerson();
        this.addFix(sb, "U_", tmpUser, false);
        tmpUser = this.getDept();
        if (tmpUser.length() != 0) {
            String[] depts;
            tmpUser = tmpUser.replaceAll("\\|", ";");
            for (String u : depts = tmpUser.split(";")) {
                sb.append("/");
                int pos = u.indexOf("_");
                if (pos != 1 && pos != 2) {
                    sb.append("D").append("_");
                }
                sb.append(u).append(";");
            }
        }
        tmpUser = this.getGroup();
        this.addFix(sb, "G_", tmpUser, true);
        tmpUser = this.getRole();
        this.addFix(sb, "R_", tmpUser, true);
        tmpUser = this.getPosition();
        this.addFix(sb, "P_", tmpUser, true);
        return sb.toString();
    }
}

