/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.json;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.definition.json.JSONDefinitionBase;
import com.horizon.wf.definition.json.JSONMap;
import com.horizon.wf.definition.json.map.JsonMapLine;
import com.horizon.wf.definition.pub.node.INodeRouter;

public class JSONRouter
extends JSONDefinitionBase
implements INodeRouter {
    private JSONMap jsonMap;
    private String fromNode;

    public JSONRouter(JSONObject json) {
        super(json);
    }

    public JSONRouter(Object json) {
        super(json);
    }

    @Override
    public String getRouterid() {
        return this.getString("id");
    }

    public void setRouterid(String id) {
        this.put("id", id);
    }

    @Override
    public String getRoutername() {
        return this.getString("name");
    }

    public void setRoutername(String name) {
        this.put("name", name);
        this.jsonMap.addNewLine(this.getRouterid()).setName(name);
    }

    @Override
    public String getNodename() {
        return this.getString("nodeName");
    }

    @Override
    public void setNodename(String nodeName) {
        this.put("nodeName", nodeName);
    }

    @Override
    public String getNodeid() {
        return this.getString("nodeId");
    }

    @Override
    public void setNodeid(String nodeId) {
        this.put("nodeId", nodeId);
    }

    @Override
    public int getNodetype() {
        return this.getIntValue("nodeType");
    }

    @Override
    public void setNodetype(int type) {
        this.put("nodeType", type);
    }

    @Override
    public String getCondition() {
        return this.getString("condition");
    }

    public void setCondition(String condition) {
        this.put("condition", condition);
    }

    @Override
    public String getBCondition() {
        return this.getString("bCondition");
    }

    public void setBCondition(String condition) {
        this.put("bCondition", condition);
    }

    private JSONObject getRule() {
        return this.getJSONObjAdd("rule");
    }

    @Override
    public String getRuleClassName() {
        return this.getString(this.getRule(), "className");
    }

    public void setRuleClassName(String className) {
        this.getRule().put("className", (Object)className);
    }

    @Override
    public String getRuleScript() {
        return this.getString(this.getRule(), "script");
    }

    public void setRuleScript(String id, String script, String text) {
        JSONObject rule = this.getRule();
        rule.put("id", (Object)id);
        rule.put("rule", (Object)script);
        rule.put("text", (Object)text);
    }

    @Override
    public String getIncludes() {
        return this.getString("includes");
    }

    public void setIncludes(String includes) {
        this.put("includes", includes);
    }

    @Override
    public String getExecutions() {
        return this.getString("executions");
    }

    public void setExecutions(String executions) {
        this.put("executions", executions);
    }

    @Override
    public String getMemo() {
        return this.getString("memo");
    }

    public void setMemo(String memo) {
        this.put("memo", memo);
    }

    @Override
    public int getSortnum() {
        return this.getIntValue("sort");
    }

    public void setSortnum(int num) {
        this.put("sort", num);
    }

    public void setJsonMap(JSONMap jsonMap) {
        this.jsonMap = jsonMap;
    }

    public void setFromNode(String node) {
        this.fromNode = node;
    }

    @Override
    public void setRouterPosition(int x1, int y1, int x2, int y2) {
        String id = this.getRouterid();
        String nodeid = this.getNodeid();
        if (nodeid == null || nodeid.length() == 0) {
            return;
        }
        JsonMapLine line = this.jsonMap.getLineById(id);
        line.setLineType(1);
        line.setName(this.getRoutername());
        line.setX1(x1);
        line.setY1(y1);
        line.setX2(x2);
        line.setY2(y2);
        line.setFrom(this.fromNode);
        line.setTo(this.getNodeid());
    }

    @Override
    public void setDynamic(boolean isDynamic) {
        if (isDynamic) {
            this.put("dynamic", isDynamic);
        } else {
            this.remove("dynamic");
        }
    }

    @Override
    public boolean isDynamic() {
        return this.getBooleanValue("dynamic");
    }
}

