/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.json;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.definition.json.JSONControl;
import com.horizon.wf.definition.json.JSONEvent;
import com.horizon.wf.definition.json.JSONException;
import com.horizon.wf.definition.json.JSONMap;
import com.horizon.wf.definition.json.JSONNodePara;
import com.horizon.wf.definition.json.JSONRouter;
import com.horizon.wf.definition.json.JSONSubflow;
import com.horizon.wf.definition.json.JSONUser;
import com.horizon.wf.definition.json.map.JsonMapNode;
import com.horizon.wf.definition.json.node.JsonNodeFun;
import com.horizon.wf.definition.pub.IFlowMap;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeEvent;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.definition.pub.node.INodePara;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import java.util.ArrayList;
import java.util.List;

public class JSONNode
extends JsonNodeFun
implements IFlowNode {
    private JSONMap jsonMap;
    private JSONObject parentJson;
    private JSONObject allJson;

    public JSONNode(JSONObject json) {
        super(json);
    }

    public JSONNode(Object json) {
        super(json);
    }

    public void setParentJson(JSONObject parentJson) {
        this.parentJson = parentJson;
    }

    public void setAllJson(JSONObject allJson) {
        this.allJson = allJson;
    }

    @Override
    public void setFlowMap(IFlowMap jsonMap) {
        this.jsonMap = (JSONMap)jsonMap;
    }

    @Override
    public IFlowMap getFlowMap() {
        return this.jsonMap;
    }

    @Override
    public String getRejectOtherBranch() {
        return this.getString("rejectOther");
    }

    public void setRejectOtherBranch(String rejectOther) {
        this.put("rejectOther", rejectOther);
    }

    @Override
    public List<INodeRouter> getRouters() {
        ArrayList<INodeRouter> routers = new ArrayList<INodeRouter>();
        String nodeid = this.getNodeid();
        JSONObject routerJson = this.getJSONObject("transitions");
        if (routerJson != null) {
            for (Object router : routerJson.values()) {
                JSONRouter tmp = new JSONRouter(router);
                tmp.setJsonMap(this.jsonMap);
                tmp.setFromNode(nodeid);
                routers.add(tmp);
            }
        }
        return routers;
    }

    @Override
    public List<INodeRouter> getAllToRouters() {
        String nodeid = this.getNodeid();
        List<INodeRouter> routers = this.getRouters();
        if (!nodeid.equals("Start")) {
            List<IFlowNode> virNodes = this.getAllVirtualNodes();
            for (IFlowNode virNode : virNodes) {
                List<INodeRouter> tmpRouters = ((JSONNode)virNode).getRouters();
                for (INodeRouter router : tmpRouters) {
                    if (router.getNodeid().equals(nodeid) || this.checkVirtualNode(nodeid, router)) continue;
                    ((JSONRouter)router).setFromNode(nodeid);
                    ((JSONRouter)router).setJsonMap(this.jsonMap);
                    routers.add(router);
                }
            }
        }
        return routers;
    }

    private boolean checkVirtualNode(String nodeid, INodeRouter router) {
        String executions;
        String includes = router.getIncludes() + ";";
        return ";".equals(includes) ? !";".equals(executions = router.getExecutions() + ";") && executions.indexOf(nodeid + ";") != -1 : includes.indexOf(nodeid + ";") == -1;
    }

    private List<IFlowNode> getAllVirtualNodes() {
        ArrayList<IFlowNode> nodes = new ArrayList<IFlowNode>();
        for (Object node : this.parentJson.values()) {
            JSONNode tmpNode = new JSONNode(node);
            if (tmpNode.getNodetype() != 900) continue;
            nodes.add(tmpNode);
        }
        return nodes;
    }

    public void setAllRouters(List<INodeRouter> routers) {
        if (routers == null || routers.isEmpty()) {
            return;
        }
        JSONObject routerJson = new JSONObject();
        for (INodeRouter router : routers) {
            routerJson.put(router.getRouterid(), (Object)((JSONRouter)router).getJson());
        }
        this.put("transitions", routerJson);
    }

    @Override
    public INodeRouter getToRouter(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        JSONObject tmp = this.getJSONObjAdd("transitions").getJSONObject(id);
        if (tmp == null) {
            return null;
        }
        JSONRouter router = new JSONRouter(tmp);
        router.setFromNode(this.getNodeid());
        router.setJsonMap(this.jsonMap);
        return router;
    }

    @Override
    public INodeRouter addToRouter(String id) {
        int nodeType = this.getNodetype();
        JSONRouter router = null;
        if (id == null || id.length() == 0) {
            List<INodeRouter> r;
            if (nodeType == 210 && (r = this.getAllToRouters()).size() > 0) {
                return null;
            }
            int lineNum = this.jsonMap.getLineNum();
            id = "Line" + ++lineNum;
            this.jsonMap.setLineNum(lineNum);
            router = new JSONRouter(new JSONObject());
            router.setJsonMap(this.jsonMap);
            router.setRouterid(id);
            router.setRoutername("\u65b0\u8def\u7531" + lineNum);
            this.getJSONObjAdd("transitions").put(id, (Object)router.getJson());
        } else {
            JSONObject tmp = this.getJSONObject("transitions").getJSONObject(id);
            if (tmp == null) {
                return null;
            }
            router = new JSONRouter(tmp);
        }
        router.setFromNode(this.getNodeid());
        router.setJsonMap(this.jsonMap);
        return router;
    }

    @Override
    public boolean deleteToRouter(String id) {
        JSONObject routers = this.getJSONObjAdd("transitions");
        if (routers.containsKey((Object)id)) {
            routers.remove((Object)id);
        }
        this.jsonMap.deleteLineById(id);
        return true;
    }

    @Override
    public void clearRouter() {
        this.remove("transitions");
    }

    @Override
    public INodeControl getParticipantsControl(String type) {
        JSONObject controlJson;
        int pos = type.indexOf("_DO");
        if (pos != -1) {
            type = type.substring(0, pos);
        }
        if ((controlJson = this.getJSONObjAdd("authDo").getJSONObject(type)) == null) {
            return null;
        }
        return new JSONControl(controlJson);
    }

    public INodeControl addNewControl(String type) {
        JSONObject controlJson = this.getJSONObjAdd("authDo");
        return new JSONControl(this.getJSONObjAdd(controlJson, type));
    }

    public void setParticipantsControl(List<INodeControl> controls) {
        if (controls == null || controls.isEmpty()) {
            return;
        }
        JSONObject authDoJson = new JSONObject();
        for (INodeControl control : controls) {
            authDoJson.put(control.getAuthId(), (Object)((JSONControl)control).getJson());
        }
        this.put("authDo", authDoJson);
    }

    @Override
    public boolean getSubFlowWait() {
        return this.getIntValue(this.getJSONObjAdd("subflow"), "wait") == 1;
    }

    public void setSubFlowWait(int wait) {
        this.getJSONObjAdd("subflow").put("wait", (Object)wait);
    }

    @Override
    public boolean getSubFlowMuilt() {
        return this.getIntValue(this.getJSONObjAdd("subflow"), "multi") == 1;
    }

    public void setSubFlowMuilt(int muilt) {
        this.getJSONObjAdd("subflow").put("multi", (Object)muilt);
    }

    @Override
    public List<INodeSubflow> getSubFlowList() {
        ArrayList<INodeSubflow> subflows = new ArrayList<INodeSubflow>();
        JSONObject subJson = this.getJSONObjAdd("subflow").getJSONObject("flows");
        if (subJson != null) {
            for (Object sub : subJson.values()) {
                subflows.add(new JSONSubflow(sub));
            }
        }
        return subflows;
    }

    public void setSubFlowList(List<INodeSubflow> subflows) {
        if (subflows == null || subflows.isEmpty()) {
            return;
        }
        JSONObject subJson = new JSONObject();
        for (INodeSubflow flow : subflows) {
            subJson.put(flow.getSubFlowId(), (Object)((JSONSubflow)flow).getJson());
        }
        this.getJSONObjAdd("subflow").put("flows", (Object)subJson);
    }

    private JSONObject getParticipants() {
        return this.getJSONObjAdd("participants");
    }

    @Override
    public INodeAuthUser getParticipantsUser(String type) {
        JSONObject user = this.getParticipants().getJSONObject(type);
        if (user == null) {
            return null;
        }
        return new JSONUser(user);
    }

    public INodeAuthUser getParticipantsUserAdd(String type) {
        JSONObject user = this.getJSONObjAdd(this.getParticipants(), type);
        return new JSONUser(user);
    }

    public void setParticipantsUser(INodeAuthUser user) {
        this.getParticipants().put(user.getAuthName(), (Object)((JSONUser)user).getJson());
    }

    @Override
    public List<INodeAuthUser> getParticipantsUserList() {
        ArrayList<INodeAuthUser> users = new ArrayList<INodeAuthUser>();
        JSONObject p = this.getParticipants();
        for (Object user : p.values()) {
            users.add(new JSONUser(user));
        }
        return users;
    }

    public void setParticipantsUser(List<INodeAuthUser> users) {
        if (users == null | users.isEmpty()) {
            return;
        }
        JSONObject userJson = new JSONObject();
        for (INodeAuthUser user : users) {
            userJson.put(user.getAuthName(), (Object)((JSONUser)user).getJson());
        }
        this.put("participants", userJson);
    }

    @Override
    public List<INodeEvent> getAllEvents() {
        ArrayList<INodeEvent> events = new ArrayList<INodeEvent>();
        JSONObject eventJson = this.getJSONObject("events");
        if (eventJson != null) {
            for (Object event : eventJson.values()) {
                events.add(new JSONEvent(event));
            }
        }
        return events;
    }

    public void setAllEvents(List<INodeEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        JSONObject eventJson = new JSONObject();
        for (INodeEvent event : events) {
            eventJson.put(event.getEventid(), (Object)((JSONEvent)event).getJson());
        }
        this.put("events", eventJson);
    }

    @Override
    public INodeEvent getNodeEvent(String eventid) {
        JSONObject events = this.getJSONObjAdd("events");
        JSONEvent event = new JSONEvent(this.getJSONObjAdd(events, eventid));
        event.setEventid(eventid);
        return event;
    }

    @Override
    public List<INodeException> getExceptions() {
        ArrayList<INodeException> exceptions = new ArrayList<INodeException>();
        JSONObject exJson = this.getJSONObject("exceptions");
        if (exJson != null) {
            for (Object exception : exJson.values()) {
                exceptions.add(new JSONException(exception));
            }
        }
        return exceptions;
    }

    public void setExceptions(List<INodeException> exceptions) {
        if (exceptions == null || exceptions.isEmpty()) {
            return;
        }
        JSONObject exceptionJson = new JSONObject();
        for (INodeException exception : exceptions) {
            exceptionJson.put(exception.getExceptionCode(), (Object)((JSONException)exception).getJson());
        }
        this.put("exceptions", exceptionJson);
    }

    @Override
    public List<INodePara> getAllNodePara() {
        ArrayList<INodePara> paras = new ArrayList<INodePara>();
        JSONObject paraJson = this.getJSONObject("paras");
        if (paraJson != null) {
            for (Object para : paraJson.values()) {
                paras.add(new JSONNodePara(para));
            }
        }
        return paras;
    }

    public void setAllNodePara(List<INodePara> paras) {
        if (paras == null || paras.isEmpty()) {
            return;
        }
        JSONObject paraJson = new JSONObject();
        for (INodePara para : paras) {
            paraJson.put(para.getParaId(), (Object)((JSONNodePara)para).getJson());
        }
        this.put("paras", paraJson);
    }

    @Override
    public void setNodePosition(int x, int y) {
        String nodeid = this.getNodeid();
        String nodename = this.getNodename();
        int nodetype = this.getNodetype();
        JsonMapNode mapNode = this.jsonMap.addNewNode(nodeid);
        mapNode.setName(nodename);
        mapNode.setNodeType(nodetype);
        mapNode.setSub(0);
        mapNode.setX(x);
        mapNode.setY(y);
    }

    @Override
    public void setDynamic(boolean isDynamic) {
        if (isDynamic) {
            this.put("dynamic", isDynamic);
        } else {
            this.remove("dynamic");
        }
    }

    @Override
    public void setMapNodeSubFromCopyNode(Object copyNode) {
        JSONNode cNode = (JSONNode)copyNode;
        JsonMapNode copyMapNode = this.jsonMap.getNodeById(cNode.getNodeid());
        int sub = copyMapNode.getSub();
        JsonMapNode curMapNode = this.jsonMap.getNodeById(this.getNodeid());
        curMapNode.setSub(sub);
    }

    @Override
    public int[] getNodePosition() {
        JsonMapNode curMapNode = this.jsonMap.getNodeById(this.getNodeid());
        int x = curMapNode.getX();
        int y = curMapNode.getY();
        int[] r = new int[]{x, y};
        return r;
    }
}

