/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.json;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.definition.json.JSONDefinitionBase;
import com.horizon.wf.definition.json.map.JsonMapLine;
import com.horizon.wf.definition.json.map.JsonMapNode;
import com.horizon.wf.definition.json.map.JsonMapSwimlane;
import com.horizon.wf.definition.pub.IFlowMap;
import com.horizon.wf.definition.pub.map.IMapLine;
import com.horizon.wf.definition.pub.map.IMapSwimlane;
import java.util.ArrayList;
import java.util.List;

public class JSONMap
extends JSONDefinitionBase
implements IFlowMap {
    public JSONMap(JSONObject json) {
        super(json);
    }

    public JSONMap(Object json) {
        super(json);
    }

    @Override
    public String getFlowid() {
        return this.getString("flowId");
    }

    public void setFlowid(String flowId) {
        this.put("flowId", flowId);
    }

    @Override
    public String getFlowname() {
        return this.getString("flowName");
    }

    public void setFlowname(String flowname) {
        this.put("flowName", flowname);
    }

    @Override
    public int getNodeNum() {
        return this.getIntValue("nodeNum");
    }

    public void setNodeNum(int num) {
        this.put("nodeNum", num);
    }

    @Override
    public int getLineNum() {
        return this.getIntValue("routeNum");
    }

    public void setLineNum(int num) {
        this.put("routeNum", num);
    }

    private JSONObject getNodeJson() {
        return this.getJSONObjAdd("nodes");
    }

    public void setNodeJson(JSONObject nodeJson) {
        this.put("nodes", nodeJson);
    }

    private JSONObject getLineJson() {
        return this.getJSONObjAdd("lines");
    }

    public void setLineJson(JSONObject lineJson) {
        this.put("lines", lineJson);
    }

    @Override
    public JsonMapSwimlane getSwimlane() {
        return new JsonMapSwimlane(this.getJSONObjAdd("swimlane"));
    }

    public void setSwimlane(IMapSwimlane swimlaneJson) {
        this.put("swimlane", ((JsonMapSwimlane)swimlaneJson).getJson());
    }

    public List<JsonMapLine> getAllLines() {
        ArrayList<JsonMapLine> lines = new ArrayList<JsonMapLine>();
        for (Object line : this.getLineJson().values()) {
            lines.add(new JsonMapLine(line));
        }
        return lines;
    }

    public void setAllLines(List<IMapLine> lines) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        JSONObject lineJson = new JSONObject();
        for (IMapLine line : lines) {
            lineJson.put(line.getId(), (Object)((JsonMapLine)line).getJson());
        }
        this.setLineJson(lineJson);
    }

    @Override
    public JsonMapLine getLineById(String id) {
        JSONObject lineJson = this.getLineJson().getJSONObject(id);
        if (lineJson == null) {
            return null;
        }
        return new JsonMapLine(lineJson);
    }

    public JsonMapLine addNewLine(String id) {
        JSONObject lineJson = this.getJSONObjAdd(this.getLineJson(), id);
        lineJson.put("id", (Object)id);
        return new JsonMapLine(lineJson);
    }

    @Override
    public void deleteLineById(String id) {
        JSONObject lineJson = this.getLineJson();
        if (lineJson.containsKey((Object)id)) {
            lineJson.remove((Object)id);
        }
    }

    @Override
    public JsonMapNode getNodeById(String id) {
        JSONObject nodeJson = this.getNodeJson().getJSONObject(id);
        if (nodeJson == null) {
            return null;
        }
        return new JsonMapNode(nodeJson);
    }

    public JsonMapNode addNewNode(String id) {
        JSONObject nodeJson = this.getJSONObjAdd(this.getNodeJson(), id);
        nodeJson.put("id", (Object)id);
        return new JsonMapNode(nodeJson);
    }

    @Override
    public void deleteNodeByid(String id) {
        JSONObject nodeJson = this.getNodeJson();
        if (nodeJson.containsKey((Object)id)) {
            nodeJson.remove((Object)id);
        }
    }
}

