/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.horizon.common.base.Objects;
import com.horizon.wf.definition.json.JSONDefinitionBase;
import com.horizon.wf.definition.json.JSONFlowDeclaration;
import com.horizon.wf.definition.json.JSONFlowForm;
import com.horizon.wf.definition.json.JSONFlowVar;
import com.horizon.wf.definition.json.JSONMap;
import com.horizon.wf.definition.json.JSONNode;
import com.horizon.wf.definition.json.JSONUser;
import com.horizon.wf.definition.json.map.JsonMapLine;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.info.IFlowForm;
import com.horizon.wf.definition.pub.info.IFlowVar;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import java.util.ArrayList;
import java.util.List;

public class JSONFlowInfo
extends JSONDefinitionBase
implements IFlowInfo {
    private JSONMap jsonMap;
    private JSONFlowDeclaration flowInfo;

    public JSONFlowInfo(JSONObject json) {
        super(json);
        this.getJsonMap();
        this.getFlowDeclaration();
    }

    @Override
    public void chgJson(JSONObject json) {
        super.chgJson(json);
        this.jsonMap = null;
        this.flowInfo = null;
        this.getJsonMap();
        this.getFlowDeclaration();
    }

    public JSONMap getJsonMap() {
        if (this.jsonMap == null) {
            this.jsonMap = new JSONMap(this.getJSONObjAdd("mapData"));
        }
        return this.jsonMap;
    }

    private JSONObject getProcessJson() {
        return this.getJSONObjAdd("process");
    }

    public JSONObject makeRuleForChgXmlToJson() {
        return this.getJSONObjAdd("RuleHtml");
    }

    @Override
    public boolean isXml() {
        return false;
    }

    @Override
    public List<IFlowNode> getAllNodes() {
        ArrayList<IFlowNode> nodes = new ArrayList<IFlowNode>();
        JSONObject processJson = this.getProcessJson();
        for (Object obj : processJson.values()) {
            JSONNode node = new JSONNode(obj);
            int nodeType = node.getNodetype();
            if (nodeType == 900) continue;
            node.setParentJson(processJson);
            node.setFlowMap(this.jsonMap);
            node.setAllJson(this.getJson());
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public List<IFlowNode> getAllNodesAndVirtual() {
        ArrayList<IFlowNode> nodes = new ArrayList<IFlowNode>();
        JSONObject processJson = this.getProcessJson();
        for (Object obj : processJson.values()) {
            JSONNode node = new JSONNode(obj);
            node.setParentJson(processJson);
            node.setFlowMap(this.jsonMap);
            node.setAllJson(this.getJson());
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public IFlowNode getNodeById(String nodeid) {
        JSONObject processJson = this.getProcessJson();
        JSONObject nodeJson = processJson.getJSONObject(nodeid);
        if (nodeJson == null) {
            return null;
        }
        JSONNode node = new JSONNode(nodeJson);
        node.setAllJson(this.getJson());
        node.setParentJson(processJson);
        node.setFlowMap(this.jsonMap);
        return node;
    }

    public IFlowNode addNewNode(String nodeid) {
        JSONObject processJson = this.getProcessJson();
        JSONObject nodeJson = this.getJSONObjAdd(processJson, nodeid);
        JSONNode node = new JSONNode(nodeJson);
        node.setAllJson(this.getJson());
        node.setParentJson(processJson);
        node.setFlowMap(this.jsonMap);
        return node;
    }

    @Override
    public IFlowNode getCopyNode(Object node, String name) {
        JSONNode tNode = (JSONNode)node;
        int type = tNode.getNodetype();
        int maxNum = this.jsonMap.getNodeNum();
        this.jsonMap.setNodeNum(++maxNum);
        String id = NodeTypeEnum.getNodePreFix(type) + maxNum;
        JSONObject jsonObject = JSON.parseObject((String)tNode.getJson().toJSONString());
        JSONNode newNode = new JSONNode(jsonObject);
        newNode.setNodeid(id);
        newNode.setNodetype(type);
        newNode.setNodename(name);
        newNode.clearRouter();
        newNode.setFlowMap(this.jsonMap);
        newNode.setParentJson(this.getProcessJson());
        newNode.setAllJson(this.getJson());
        this.getProcessJson().put(id, (Object)jsonObject);
        return newNode;
    }

    @Override
    public void deleteNodeById(String nodeid) {
        this.jsonMap.deleteNodeByid(nodeid);
        JSONObject nodeJson = this.getProcessJson();
        nodeJson.remove((Object)nodeid);
    }

    @Override
    public INodeRouter getRouterById(String routerid) {
        JsonMapLine line = this.jsonMap.getLineById(routerid);
        JSONNode tmpNode = (JSONNode)this.getNodeById(line.getFrom());
        return tmpNode.getToRouter(routerid);
    }

    @Override
    public IFlowNode getStartNode() {
        return this.getNodeById("Start");
    }

    @Override
    public String getMapStr() {
        return this.jsonMap.getJson().toJSONString();
    }

    @Override
    public String getDataString() {
        return this.toJSONString();
    }

    @Override
    public List<String> getFromNodes(String nodeid) {
        ArrayList<String> fromNodes = new ArrayList<String>();
        List<JsonMapLine> lines = this.jsonMap.getAllLines();
        for (JsonMapLine line : lines) {
            if (!line.getTo().equals(nodeid)) continue;
            fromNodes.add(line.getFrom());
        }
        return fromNodes;
    }

    @Override
    public String getFormsXML() {
        return "";
    }

    protected JSONFlowDeclaration getFlowDeclaration() {
        if (this.flowInfo == null) {
            this.flowInfo = new JSONFlowDeclaration(this.getJSONObjAdd("flowInfo"));
        }
        return this.flowInfo;
    }

    @Override
    public String getId() {
        return this.flowInfo.getId();
    }

    public void setId(String id) {
        this.flowInfo.setId(id);
    }

    @Override
    public int[] getLimitSet() {
        return this.flowInfo.getLimitSet();
    }

    @Override
    public void setLimitSet(int[] limit) {
        this.flowInfo.setLimitSet(limit);
    }

    public void setUserReader(JSONUser reader) {
        this.flowInfo.setUserReader(reader);
    }

    @Override
    public List<String> getReader() {
        return this.flowInfo.getReader();
    }

    @Override
    public String getReaderMsg() {
        return this.flowInfo.getReaderMsg();
    }

    @Override
    public String getReaderRuleScript() {
        return this.flowInfo.getReaderRuleScript();
    }

    @Override
    public List<IFlowVar> getAllVar() {
        return this.flowInfo.getAllVar();
    }

    public void setAllVar(List<JSONFlowVar> vars) {
        this.flowInfo.setAllVar(vars);
    }

    @Override
    public List<IFlowForm> getAllFlowForms() {
        return this.flowInfo.getAllFlowForms();
    }

    public void setAllFlowForms(List<JSONFlowForm> forms) {
        this.flowInfo.setAllFlowForms(forms);
    }

    @Override
    public JSONFlowForm getFlowForm(String formid) {
        return this.flowInfo.getFlowForm(formid);
    }

    @Override
    public String getFlowid() {
        return this.flowInfo.getFlowid();
    }

    public void setFlowid(String flowid) {
        this.flowInfo.setFlowid(flowid);
    }

    @Override
    public String getFlowname() {
        return this.flowInfo.getFlowname();
    }

    public void setFlowname(String flowname) {
        this.flowInfo.setFlowname(flowname);
    }

    @Override
    public int getVersion() {
        return this.flowInfo.getVersion();
    }

    public void setVersion(int version) {
        this.flowInfo.setVersion(version);
    }

    @Override
    public int getActive() {
        return this.flowInfo.getActive();
    }

    public void setActive(int active) {
        this.flowInfo.setActive(active);
    }

    @Override
    public String getCreator() {
        return this.flowInfo.getCreator();
    }

    public void setCreator(String creator) {
        this.flowInfo.setCreator(creator);
    }

    @Override
    public String getCreated() {
        return this.flowInfo.getCreated();
    }

    public void setCreated(String created) {
        this.flowInfo.setCreated(created);
    }

    @Override
    public String getUpdate() {
        return this.flowInfo.getUpdate();
    }

    public void setUpdate(String update) {
        this.flowInfo.setUpdate(update);
    }

    @Override
    public String getModifier() {
        return this.flowInfo.getModifier();
    }

    public void setModifier(String modified) {
        this.flowInfo.setModifier(modified);
    }

    @Override
    public String getFlowType() {
        return this.flowInfo.getFlowType();
    }

    public void setFlowType(String flowType) {
        this.flowInfo.setFlowType(flowType);
    }

    @Override
    public String getFlowTypeName() {
        return this.flowInfo.getFlowTypeName();
    }

    public void setFlowTypeName(String typeName) {
        this.flowInfo.setFlowTypeName(typeName);
    }

    @Override
    public String getMemo() {
        return this.flowInfo.getMemo();
    }

    @Override
    public String getParticipantTypes() {
        return this.getParticipantIds();
    }

    public void setMemo(String memo) {
        this.flowInfo.setMemo(memo);
    }

    @Override
    public String getParticipantIds() {
        return this.flowInfo.getParticipantId();
    }

    public void setParticipantIds(String participantId) {
        this.flowInfo.setParticipantId(participantId);
    }

    @Override
    public String getParticipantNames() {
        return this.getString("participantName");
    }

    public void setParticipantNames(String participantName) {
        this.flowInfo.setParticipantName(participantName);
    }

    @Override
    public String getParticipantAuth() {
        return this.getParticipantIds();
    }

    public void setParticipantAuth(String participantAuth) {
        this.flowInfo.setParticipantAuth(participantAuth);
    }

    @Override
    public String getOpenTodoFlag() {
        return this.flowInfo.getOpenTodoFlag();
    }

    public void setOpenTodoFlag(String openTodoFlag) {
        this.flowInfo.setOpenTodoFlag(openTodoFlag);
    }

    @Override
    public String getSaveLocal() {
        return this.flowInfo.getSaveLocal();
    }

    public void setSaveLocal(String saveLocal) {
        this.flowInfo.setSaveLocal(saveLocal);
    }

    @Override
    public String getReleaseStatus() {
        return this.flowInfo.getReleaseStatus();
    }

    public void setReleaseStatus(String releaseStatus) {
        this.flowInfo.setReleaseStatus(releaseStatus);
    }

    @Override
    public String getStartRuleClassName() {
        return this.flowInfo.getStartRuleClassName();
    }

    public void setStartRuleClassName(String startRuleClassName) {
        this.flowInfo.setStartRuleClassName(startRuleClassName);
    }

    @Override
    public String getCheckRoleClassName() {
        return this.flowInfo.getCheckRoleClassName();
    }

    public void setCheckRoleClassName(String checkRoleClassName) {
        this.flowInfo.setCheckRoleClassName(checkRoleClassName);
    }

    @Override
    public String getRelationRuleClassName() {
        return this.flowInfo.getRelationRuleClassName();
    }

    public void setRelationRuleClassName(String relationRuleClassName) {
        this.flowInfo.setRelationRuleClassName(relationRuleClassName);
    }

    @Override
    public String getTrackLogClassName() {
        return this.flowInfo.getTrackLogClassName();
    }

    public void setTrackLogClassName(String trackLogClassName) {
        this.flowInfo.setTrackLogClassName(trackLogClassName);
    }

    @Override
    public boolean isUpdateToDB() {
        return this.flowInfo.isUpdateToDB();
    }

    public void setUpdateToDB(int updateToDB) {
        this.flowInfo.setUpdateToDB(updateToDB);
    }

    @Override
    public boolean isManagerStartup() {
        return this.flowInfo.isManagerStartup();
    }

    public void setManagerStartup(int mgrStartup) {
        this.flowInfo.setManagerStartup(mgrStartup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        JSONFlowInfo jsonFlowInfo = (JSONFlowInfo)o;
        return Objects.equal((Object)this.getId(), (Object)jsonFlowInfo.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId()});
    }
}

