/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.json;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.definition.json.JSONFlowForm;
import com.horizon.wf.definition.json.JSONFlowVar;
import com.horizon.wf.definition.json.JSONUser;
import com.horizon.wf.definition.json.flow.JsonFlowBase;
import com.horizon.wf.definition.pub.info.IFlowForm;
import com.horizon.wf.definition.pub.info.IFlowVar;
import com.horizon.wf.definition.tools.UUIDFun;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class JSONFlowDeclaration
extends JsonFlowBase {
    public JSONFlowDeclaration(JSONObject json) {
        super(json);
    }

    public JSONFlowDeclaration(Object json) {
        super(json);
    }

    public int[] getLimitSet() {
        int[] tmp = new int[2];
        JSONObject obj = this.getJSONObjAdd("flowlimit");
        tmp[0] = obj.getIntValue("type");
        tmp[1] = obj.getIntValue("days");
        return tmp;
    }

    public void setLimitSet(int[] limit) {
        JSONObject obj = this.getJSONObjAdd("flowlimit");
        obj.put("type", (Object)limit[0]);
        obj.put("days", (Object)limit[1]);
    }

    private JSONUser getUserReader() {
        JSONObject participants = this.getJSONObject("participants");
        JSONUser reader = new JSONUser(this.getJSONObjAdd(participants, "Reader"));
        return reader;
    }

    public void setUserReader(JSONUser reader) {
        this.getJSONObjAdd("participants").put(reader.getAuthName(), (Object)reader.getJson());
    }

    public List<String> getReader() {
        ArrayList<String> result = new ArrayList<String>(5);
        JSONUser reader = this.getUserReader();
        result.add(reader.getPerson());
        result.add(reader.getDept());
        result.add(reader.getGroup());
        result.add(reader.getRole());
        result.add(reader.getPosition());
        result.add(reader.getRuleScript());
        result.add(reader.getSendMsgFlag());
        return result;
    }

    public String getReaderMsg() {
        return this.getUserReader().getSendMsgFlag();
    }

    public String getReaderRuleScript() {
        return this.getUserReader().getRuleScript();
    }

    public List<IFlowVar> getAllVar() {
        ArrayList<IFlowVar> vars = new ArrayList<IFlowVar>();
        JSONObject tmpVars = this.getJSONObject("vars");
        if (tmpVars != null) {
            for (Object value : tmpVars.values()) {
                vars.add(new JSONFlowVar(value));
            }
        }
        return vars;
    }

    public void setAllVar(List<JSONFlowVar> vars) {
        JSONObject tmpVars = new JSONObject();
        int size = vars.size();
        for (JSONFlowVar tmp : vars) {
            tmpVars.put(tmp.getVarId(), (Object)tmp.getJson());
        }
        this.put("vars", tmpVars);
    }

    public List<IFlowForm> getAllFlowForms() {
        ArrayList<IFlowForm> forms = new ArrayList<IFlowForm>();
        JSONObject tmpForms = this.getJSONObjAdd("forms");
        for (Object value : tmpForms.values()) {
            JSONFlowForm form = new JSONFlowForm((JSONObject)value);
            forms.add(form);
        }
        Collections.sort(forms, new Comparator<IFlowForm>(){

            @Override
            public int compare(IFlowForm o1, IFlowForm o2) {
                JSONFlowForm oo1 = (JSONFlowForm)o1;
                JSONFlowForm oo2 = (JSONFlowForm)o2;
                return oo1.getSort() - oo2.getSort();
            }
        });
        return forms;
    }

    public void setAllFlowForms(List<JSONFlowForm> forms) {
        if (forms == null || forms.isEmpty()) {
            return;
        }
        JSONObject formJson = new JSONObject();
        for (JSONFlowForm form : forms) {
            formJson.put(form.getFormid(), (Object)form.getJson());
        }
        this.put("froms", formJson);
    }

    public JSONFlowForm getFlowForm(String formid) {
        JSONFlowForm formJson;
        JSONObject form;
        JSONObject tmpForms = this.getJSONObjAdd("forms");
        if (formid == null || formid.length() == 0) {
            formid = UUIDFun.getUnid();
        }
        if ((form = tmpForms.getJSONObject(formid)) == null) {
            form = new JSONObject();
            formJson = new JSONFlowForm(form);
            formJson.setFormid(formid);
            formJson.setFlowname("\u8868\u5355");
            formJson.setSort(99);
            if (formid.equals("FlowTrack")) {
                formJson.setFlowname("\u6d41\u7a0b\u8ddf\u8e2a");
            }
            tmpForms.put(formid, (Object)form);
        } else {
            formJson = new JSONFlowForm(form);
        }
        return formJson;
    }
}

