/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;

public class JSONDefinitionBase
implements Serializable {
    private JSONObject json;

    protected JSONDefinitionBase(JSONObject json) {
        this.json = json;
    }

    protected JSONDefinitionBase(Object json) {
        this.json = (JSONObject)json;
    }

    protected void chgJson(JSONObject json) {
        this.json = json;
    }

    protected JSONObject getJson() {
        return this.json;
    }

    public boolean isNull() {
        return this.json == null;
    }

    public JSONObject getJsonCopy() {
        return JSON.parseObject((String)this.toJSONString());
    }

    public String toJSONString() {
        return this.json.toJSONString();
    }

    public String getDataString() {
        return this.json.toJSONString();
    }

    protected void put(String key, Object value) {
        this.json.put(key, value);
    }

    protected JSONArray getJSONArray(String key) {
        return this.json.getJSONArray(key);
    }

    protected JSONArray getJSONArrAdd(String key) {
        JSONArray arr = this.getJSONArray(key);
        if (arr == null) {
            arr = new JSONArray();
            this.put(key, arr);
        }
        return arr;
    }

    protected JSONObject getJSONObject(String key) {
        return this.json.getJSONObject(key);
    }

    protected JSONObject getJSONObjAdd(String key) {
        JSONObject obj = this.getJSONObject(key);
        if (obj == null) {
            obj = new JSONObject();
            this.put(key, obj);
        }
        return obj;
    }

    protected JSONArray getJSONArrAdd(JSONObject obj, String key) {
        JSONArray arr = obj.getJSONArray(key);
        if (arr == null) {
            arr = new JSONArray();
            obj.put(key, (Object)arr);
        }
        return arr;
    }

    protected JSONObject getJSONObjAdd(JSONObject obj, String key) {
        JSONObject tmp = obj.getJSONObject(key);
        if (tmp == null) {
            tmp = new JSONObject();
            obj.put(key, (Object)tmp);
        }
        return tmp;
    }

    protected String getString(JSONObject obj, String key) {
        return this.getString(obj, key, "");
    }

    protected String getString(String key) {
        return this.getString(key, "");
    }

    protected String getString(String key, String defaultValue) {
        return this.getString(this.json, key, defaultValue);
    }

    private String getString(JSONObject obj, String key, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        String value = obj.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected String getStringAdd(String key) {
        String value = this.json.getString(key);
        if (value == null) {
            this.json.put(key, (Object)"");
            return "";
        }
        return value;
    }

    protected boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    protected boolean getBooleanValue(String key, boolean defaultValue) {
        return this.getBooleanValue(this.json, key, defaultValue);
    }

    protected boolean getBooleanValue(JSONObject obj, String key) {
        return this.getBooleanValue(obj, key, false);
    }

    private boolean getBooleanValue(JSONObject obj, String key, boolean defaultValue) {
        Boolean value = obj.getBoolean(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected int getIntValue(String key) {
        return this.getIntValue(key, 0);
    }

    protected int getIntValue(String key, int defaultValue) {
        return this.getIntValue(this.json, key, defaultValue);
    }

    protected int getIntValue(JSONObject obj, String key) {
        return this.getIntValue(obj, key, 0);
    }

    private int getIntValue(JSONObject obj, String key, int defaultValue) {
        Integer value = obj.getInteger(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected void setRuleToObj(JSONObject obj, String id, String script, String text) {
        obj.put("id", (Object)id);
        obj.put("script", (Object)script);
        obj.put("text", (Object)text);
    }

    protected void remove(String key) {
        if (this.json.containsKey((Object)key)) {
            this.json.remove((Object)key);
        }
    }
}

