/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.json;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.definition.json.JSONButton;
import com.horizon.wf.definition.json.JSONDefinitionBase;
import com.horizon.wf.definition.json.JSONNodeForm;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class JSONControl
extends JSONDefinitionBase
implements INodeControl {
    public JSONControl(JSONObject json) {
        super(json);
    }

    public JSONControl(Object json) {
        super(json);
    }

    @Override
    public String getAuthId() {
        return this.getString("id");
    }

    public void setAuthId(String id) {
        this.put("id", id);
    }

    private JSONObject getButtonJson() {
        return this.getJSONObjAdd("buttons");
    }

    @Override
    public String getAllowGetBackNode() {
        return this.getString(this.getButtonJson(), "backNodes");
    }

    public void setAllowGetBackNode(String backNodes) {
        this.getButtonJson().put("backNodes", (Object)backNodes);
    }

    @Override
    public String getAllowRejectNode() {
        return this.getString(this.getButtonJson(), "rejectNodes");
    }

    public void setAllowRejectNode(String rejectNodes) {
        this.getButtonJson().put("rejectNodes", (Object)rejectNodes);
    }

    @Override
    public List<INodeButton> getButton() {
        ArrayList<INodeButton> buttons = new ArrayList<INodeButton>();
        JSONObject btnJson = this.getButtonJson().getJSONObject("actions");
        if (btnJson != null) {
            for (Object btn : btnJson.values()) {
                buttons.add(new JSONButton(btn));
            }
        }
        return buttons;
    }

    public void setButton(List<JSONButton> buttons) {
        JSONObject btnJson = new JSONObject();
        if (buttons != null && !buttons.isEmpty()) {
            for (JSONButton btn : buttons) {
                btnJson.put(btn.getButtonId(), (Object)btn.getJson());
            }
        }
        this.getButtonJson().put("actions", (Object)btnJson);
    }

    private JSONObject getFormJson() {
        return this.getJSONObjAdd("forms");
    }

    @Override
    public String getDefaultShowFormID() {
        return this.getString(this.getFormJson(), "dfId");
    }

    public void setDefaultShowFormID(String formid) {
        this.getFormJson().put("dfId", (Object)formid);
    }

    @Override
    public List<INodeForm> getAllNodeForms() {
        ArrayList<INodeForm> forms = new ArrayList<INodeForm>();
        JSONObject formJson = this.getFormJson().getJSONObject("form");
        if (formJson != null) {
            for (Object form : formJson.values()) {
                JSONNodeForm nodeForm = new JSONNodeForm(form);
                forms.add(nodeForm);
            }
            Collections.sort(forms, new Comparator<INodeForm>(){

                @Override
                public int compare(INodeForm o1, INodeForm o2) {
                    JSONNodeForm oo1 = (JSONNodeForm)o1;
                    JSONNodeForm oo2 = (JSONNodeForm)o2;
                    return oo1.getSort() - oo2.getSort();
                }
            });
        }
        return forms;
    }

    public void setAllNodeForm(List<JSONNodeForm> forms) {
        if (forms == null || forms.isEmpty()) {
            return;
        }
        JSONObject formJson = new JSONObject();
        for (JSONNodeForm form : forms) {
            formJson.put(form.getFormid(), (Object)form.getJson());
        }
        this.getFormJson().put("form", (Object)formJson);
    }

    @Override
    public JSONNodeForm getNodeForm(String formid) {
        JSONNodeForm nodeForm;
        JSONObject formJson = this.getJSONObjAdd(this.getFormJson(), "form");
        JSONObject form = formJson.getJSONObject(formid);
        if (form == null) {
            form = this.getJSONObjAdd(formJson, formid);
            nodeForm = new JSONNodeForm(form);
            nodeForm.setSort(99);
        } else {
            nodeForm = new JSONNodeForm(form);
        }
        return nodeForm;
    }

    @Override
    public boolean delNodeForm(String formid) {
        JSONObject formJson = this.getJSONObjAdd(this.getFormJson(), "form");
        if (formJson.containsKey((Object)formid)) {
            formJson.remove((Object)formid);
        }
        return true;
    }
}

