/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.impl;

import com.horizon.wf.definition.impl.XmlBaseImpl;
import com.horizon.wf.definition.impl.XmlEventImpl;
import com.horizon.wf.definition.impl.XmlRelationImpl;
import com.horizon.wf.definition.impl.XmlUserImpl;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.pub.node.INodeEvent;
import com.horizon.wf.definition.pub.node.user.IUserRelation;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.XMLParseUtil;
import java.util.ArrayList;
import java.util.List;

public class XmlRouterImpl
extends XmlBaseImpl {
    public XmlRouterImpl(HZElement XML) {
        super(XML);
    }

    public String getRouterid() {
        return XMLParseUtil.getAttribute(this.getXML(), "ID");
    }

    public String getRoutername() {
        return XMLParseUtil.getAttribute(this.getXML(), "Name");
    }

    public String getNodename() {
        return XMLParseUtil.getAttribute(this.getXML(), "NodeName");
    }

    public String getNodeid() {
        return XMLParseUtil.getAttribute(this.getXML(), "NodeID");
    }

    public int getNodetype() {
        return Integer.parseInt(XMLParseUtil.getAttribute("1", this.getXML(), "NodeType"));
    }

    public int getSortnum() {
        String sortnum = XMLParseUtil.getAttribute("1", this.getXML(), "SortNum").replaceAll("[^0-9]", "");
        if (sortnum.length() == 0) {
            sortnum = "1";
        }
        return Integer.parseInt(sortnum);
    }

    public String getRuleClassName() {
        return XMLParseUtil.getTextTrim(this.getXML(), "RuleClassName");
    }

    public String getCondition() {
        return XMLParseUtil.getText(this.getXML(), "Condition");
    }

    public String getBCondition() {
        return XMLParseUtil.getText(this.getXML(), "BCondition");
    }

    public String getMemo() {
        return XMLParseUtil.getText(this.getXML(), "Memo");
    }

    public String getIncludes() {
        return XMLParseUtil.getText(this.getXML(), "Includes");
    }

    public String getExecutions() {
        return XMLParseUtil.getText(this.getXML(), "Executions");
    }

    public List<INodeEvent> getAllEvents() {
        List<HZElement> events = XMLParseUtil.getElementList(this.getXML(), "Events");
        ArrayList<INodeEvent> result = new ArrayList<INodeEvent>();
        int n = events.size();
        for (int i = 0; i < n; ++i) {
            HZElement event = events.get(i);
            XmlEventImpl e = new XmlEventImpl(event);
            result.add(e);
        }
        return result;
    }

    public INodeEvent getRouterEvent(String eventid) {
        if (eventid == null || eventid.length() == 0) {
            return null;
        }
        HZElement xEvent = XMLParseUtil.getElement(this.getXML(), "Event", "ID", eventid);
        if (xEvent == null) {
            return null;
        }
        XmlEventImpl event = new XmlEventImpl(xEvent);
        return event;
    }

    public List<IUserRelation> getAllRelations() {
        List<HZElement> events = XMLParseUtil.getElementList(this.getXML(), "Relations");
        ArrayList<IUserRelation> result = new ArrayList<IUserRelation>();
        int n = events.size();
        for (int i = 0; i < n; ++i) {
            HZElement event = events.get(i);
            XmlRelationImpl e = new XmlRelationImpl(event);
            result.add(e);
        }
        return result;
    }

    public IUserRelation getRelation(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        HZElement xEvent = XMLParseUtil.getElement(this.getXML(), "Relation", "ID", id);
        if (xEvent == null) {
            return null;
        }
        XmlRelationImpl event = new XmlRelationImpl(xEvent);
        return event;
    }

    public void setDynamic(boolean isDynamic) {
    }

    public boolean isDynamic() {
        return false;
    }

    public String getRouterAuthorUnion() {
        HZElement authorXML = XMLParseUtil.getElement(this.getXML(), "Author");
        return XMLParseUtil.getAttribute(authorXML, "ReplaceFlag");
    }

    public INodeAuthUser getRouterAuthor() {
        HZElement authorXML = XMLParseUtil.getElement(this.getXML(), "Author");
        XmlUserImpl user = new XmlUserImpl(authorXML);
        return user;
    }

    public String getRuleScript() {
        return XMLParseUtil.getText(this.getXML(), "RuleScript");
    }

    public String getRuleId() {
        return XMLParseUtil.getAttribute(this.getXML(), "RuleScript", "id");
    }

    public String getRuleCN() {
        return XMLParseUtil.getText(this.getXML(), "RuleScriptCN");
    }
}

