/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.impl;

import com.horizon.wf.definition.api.XMLFlowForm;
import com.horizon.wf.definition.api.XMLNode;
import com.horizon.wf.definition.api.XMLToRouter;
import com.horizon.wf.definition.impl.XmlBaseImpl;
import com.horizon.wf.definition.impl.XmlFlowFormImpl;
import com.horizon.wf.definition.impl.XmlFlowVarImpl;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.info.IFlowForm;
import com.horizon.wf.definition.pub.info.IFlowVar;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.XMLParseUtil;
import java.util.ArrayList;
import java.util.List;

public class XmlFlowInfoImpl
extends XmlBaseImpl
implements IFlowInfo {
    public XmlFlowInfoImpl() {
    }

    public XmlFlowInfoImpl(HZElement XML) {
        super(XML);
    }

    @Override
    public boolean isXml() {
        return true;
    }

    @Override
    public String getFlowid() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/FlowID");
    }

    @Override
    public String getFlowname() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/FlowName");
    }

    @Override
    public int getVersion() {
        return Integer.parseInt(XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/Version"));
    }

    @Override
    public String getFlowType() {
        String id = XMLParseUtil.getAttribute(this.getXML(), "TypeDeclarations/Type", "ID");
        return id;
    }

    @Override
    public String getFlowTypeName() {
        return XMLParseUtil.getText(this.getXML(), "TypeDeclarations/Type");
    }

    @Override
    public String getMemo() {
        return XMLParseUtil.getText(this.getXML(), "TypeDeclarations/Memo");
    }

    public String getActivitySet() {
        String tmpPara = XMLParseUtil.getAttribute(this.getXML(), "TypeDeclarations/ActivitySet", "Flag");
        return tmpPara;
    }

    @Override
    public int[] getLimitSet() {
        HZElement tmp = XMLParseUtil.getElement(this.getXML(), "TypeDeclarations/LimitSet");
        int[] ls = new int[]{Integer.parseInt(XMLParseUtil.getAttribute("1", tmp, "DayType")), Integer.parseInt(XMLParseUtil.getAttribute("0", tmp, "Days"))};
        return ls;
    }

    @Override
    public void setLimitSet(int[] limit) {
        int type = limit[0];
        int days = limit[1];
        HZElement tmp = XMLParseUtil.getElement(this.getXML(), "TypeDeclarations/LimitSet");
        if (days > -1) {
            XMLParseUtil.setAttribute(tmp, "Days", "" + days);
        }
        if (type > -1) {
            XMLParseUtil.setAttribute(tmp, "DayType", "" + type);
        }
    }

    @Override
    public String getFormsXML() {
        HZElement formXML = XMLParseUtil.getElement(this.getXML(), "TypeDeclarations/Forms");
        return formXML.asXML();
    }

    @Override
    public List<IFlowForm> getAllFlowForms() {
        List<HZElement> formXMLs = XMLParseUtil.getElementList(this.getXML(), "TypeDeclarations/Forms");
        ArrayList<IFlowForm> result = new ArrayList<IFlowForm>();
        int n = formXMLs.size();
        for (int i = 0; i < n; ++i) {
            HZElement formXML = formXMLs.get(i);
            XmlFlowFormImpl tmpForm = new XmlFlowFormImpl(formXML);
            result.add(tmpForm);
        }
        return result;
    }

    @Override
    public IFlowForm getFlowForm(String formid) {
        HZElement formXML = XMLParseUtil.getElement(this.getXML(), "TypeDeclarations/Forms");
        if (formid == null || formid.length() == 0) {
            return null;
        }
        HZElement newXML = XMLParseUtil.getElement(formXML, "Form", "ID", formid);
        if (newXML == null) {
            if (formid.equals("FlowTrack")) {
                newXML = XMLParseUtil.convertStringToXML("<Form/>");
                XMLParseUtil.setAttribute(newXML, "ID", formid);
                if (formid.equals("FlowTrack")) {
                    XMLParseUtil.setAttribute(newXML, "Name", "\u6d41\u7a0b\u8ddf\u8e2a");
                }
                XMLParseUtil.addElement(formXML, newXML);
            } else {
                return null;
            }
        }
        XMLFlowForm form = new XMLFlowForm(newXML);
        return form;
    }

    @Override
    public List<IFlowVar> getAllVar() {
        List<HZElement> vars = XMLParseUtil.getElementList(this.getXML(), "TypeDeclarations/Vars");
        ArrayList<IFlowVar> result = new ArrayList<IFlowVar>();
        if (vars == null || vars.isEmpty()) {
            return result;
        }
        int n = vars.size();
        for (int i = 0; i < n; ++i) {
            HZElement var = vars.get(i);
            XmlFlowVarImpl flowVar = new XmlFlowVarImpl(var);
            result.add(flowVar);
        }
        return result;
    }

    @Override
    public String getParticipantTypes() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/ParticipantId");
    }

    @Override
    public String getParticipantNames() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/ParticipantName");
    }

    @Override
    public String getParticipantAuth() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/ParticipantAuth");
    }

    @Override
    public String getStartRuleClassName() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/StartRuleClassName");
    }

    @Override
    public String getCheckRoleClassName() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/CheckRoleClassName");
    }

    @Override
    public String getRelationRuleClassName() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/RelationClassName");
    }

    @Override
    public String getTrackLogClassName() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/TrackLogClassName");
    }

    @Override
    public String getOpenTodoFlag() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/openTodoFlag");
    }

    @Override
    public String getSaveLocal() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/SaveLocal");
    }

    @Override
    public String getReleaseStatus() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/ReleaseStatus");
    }

    @Override
    public List<String> getReader() {
        ArrayList<String> result = new ArrayList<String>(5);
        HZElement tmp = XMLParseUtil.getElement(this.getXML(), "TypeDeclarations/Participants/Reader");
        if (tmp == null) {
            return result;
        }
        String a = XMLParseUtil.getTextTrim(tmp, "Person");
        String b = XMLParseUtil.getTextTrim(tmp, "Dept");
        String c = XMLParseUtil.getTextTrim(tmp, "Group");
        String d = XMLParseUtil.getTextTrim(tmp, "Role");
        String e = XMLParseUtil.getTextTrim(tmp, "Position");
        result.add(a);
        result.add(b);
        result.add(c);
        result.add(d);
        result.add(e);
        return result;
    }

    @Override
    public String getReaderRuleScript() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/Participants/Reader/Rule");
    }

    @Override
    public String getReaderMsg() {
        return XMLParseUtil.getText(this.getXML(), "TypeDeclarations/Participants/Reader/MsgFlag");
    }

    @Override
    public List<IFlowNode> getAllNodes() {
        List<HZElement> nodesXML = XMLParseUtil.getElementList(this.getXML(), "WorkflowProcesses");
        ArrayList<IFlowNode> nodes = new ArrayList<IFlowNode>();
        int n = nodesXML.size();
        for (int i = 0; i < n; ++i) {
            HZElement nodeXML = nodesXML.get(i);
            XMLNode node = new XMLNode(nodeXML);
            int nodeType = node.getNodetype();
            if (nodeType == 900) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public List<IFlowNode> getAllNodesAndVirtual() {
        List<HZElement> nodesXML = XMLParseUtil.getElementList(this.getXML(), "WorkflowProcesses");
        ArrayList<IFlowNode> nodes = new ArrayList<IFlowNode>();
        int n = nodesXML.size();
        for (int i = 0; i < n; ++i) {
            HZElement nodeXML = nodesXML.get(i);
            XMLNode node = new XMLNode(nodeXML);
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public IFlowNode getNodeById(String nodeid) {
        HZElement nodeXML = XMLParseUtil.getElement(this.getXML(), "WorkflowProcesses/WorkflowProcess", "ID", nodeid);
        if (nodeXML == null) {
            return null;
        }
        XMLNode node = new XMLNode(nodeXML);
        return node;
    }

    @Override
    public IFlowNode getCopyNode(Object tNode, String name) {
        return null;
    }

    @Override
    public INodeRouter getRouterById(String routerid) {
        HZElement routerXML = XMLParseUtil.getElement(this.getXML(), "WorkflowProcesses/WorkflowProcess/Transitions/ToRouter/Router", "ID", routerid);
        if (routerXML == null) {
            return null;
        }
        XMLToRouter router = new XMLToRouter(routerXML);
        return router;
    }

    @Override
    public IFlowNode getStartNode() {
        return this.getNodeById("Start");
    }

    @Override
    public void deleteNodeById(String nodeid) {
    }

    @Override
    public String getMapStr() {
        return null;
    }

    public String getMapXML() {
        HZElement mapXML = XMLParseUtil.getElement(this.getXML(), "MapXML");
        XMLParseUtil.setAttribute(mapXML, "flowid", this.getFlowid());
        if (mapXML == null) {
            return "";
        }
        return mapXML.asXML();
    }

    public HZElement getMapElement() {
        HZElement mapXML = XMLParseUtil.getElement(this.getXML(), "MapXML");
        return mapXML;
    }

    @Override
    public List<String> getFromNodes(String nodeid) {
        ArrayList<String> fromNodes = new ArrayList<String>();
        HZElement mapXML = XMLParseUtil.getElement(this.getXML(), "MapXML");
        List<HZElement> nXMLs = XMLParseUtil.getElements(mapXML, "line", "toID", nodeid);
        int n = nXMLs.size();
        for (int i = 0; i < n; ++i) {
            HZElement nXML = nXMLs.get(i);
            String fromNode = XMLParseUtil.getAttribute(nXML, "fromID");
            fromNodes.add(fromNode);
        }
        return fromNodes;
    }

    @Override
    public String getId() {
        return XMLParseUtil.getAttribute(this.getXML(), "id");
    }

    @Override
    public boolean isUpdateToDB() {
        String isToDB = XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/IsUpdateToDB");
        return "1".equals(isToDB);
    }

    @Override
    public boolean isManagerStartup() {
        return false;
    }

    @Override
    public String getParticipantIds() {
        return XMLParseUtil.getTextTrim(this.getXML(), "TypeDeclarations/ParticipantId");
    }

    @Override
    public int getActive() {
        return Integer.parseInt(XMLParseUtil.getAttribute(this.getXML(), "ActiveFlag"));
    }

    @Override
    public String getCreator() {
        return null;
    }

    @Override
    public String getCreated() {
        return null;
    }

    @Override
    public String getUpdate() {
        return null;
    }

    @Override
    public String getModifier() {
        return null;
    }
}

