/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.impl;

import com.horizon.wf.definition.api.XMLNodeForm;
import com.horizon.wf.definition.impl.XmlBaseImpl;
import com.horizon.wf.definition.impl.XmlButtonImpl;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.XMLParseUtil;
import java.util.ArrayList;
import java.util.List;

public class XmlControlImpl
extends XmlBaseImpl
implements INodeControl {
    public XmlControlImpl(HZElement XML) {
        super(XML);
    }

    @Override
    public List<INodeButton> getButton() {
        List<HZElement> actionXMLs = XMLParseUtil.getElementList(this.getXML(), "Buttons");
        ArrayList<INodeButton> result = new ArrayList<INodeButton>();
        int n = actionXMLs.size();
        for (int i = 0; i < n; ++i) {
            HZElement actionXML = actionXMLs.get(i);
            result.add(new XmlButtonImpl(actionXML));
        }
        return result;
    }

    public String getCustomButton() {
        return XMLParseUtil.getText(this.getXML(), "Buttons/Custom");
    }

    @Override
    public String getAuthId() {
        return null;
    }

    @Override
    public String getAllowGetBackNode() {
        return XMLParseUtil.getAttribute(this.getXML(), "Buttons", "GetBackFlag");
    }

    @Override
    public String getAllowRejectNode() {
        return XMLParseUtil.getAttribute(this.getXML(), "Buttons", "RejectNodes");
    }

    public String getMainDo_AllowRejectNode() {
        return XMLParseUtil.getAttribute(this.getXML(), "Buttons", "RejectFlag");
    }

    public String getMainDo_SubmitName() {
        return XMLParseUtil.getAttribute(this.getXML(), "Buttons", "SubmitName");
    }

    public boolean getMainDo_SubmitHide() {
        String a = XMLParseUtil.getAttribute(this.getXML(), "Buttons", "SubmitHide");
        return a.equals("1");
    }

    @Override
    public String getDefaultShowFormID() {
        return XMLParseUtil.getAttribute(this.getXML(), "Forms", "dfID");
    }

    @Override
    public List<INodeForm> getAllNodeForms() {
        List<HZElement> formXMLs = XMLParseUtil.getElementList(this.getXML(), "Forms");
        ArrayList<INodeForm> result = new ArrayList<INodeForm>();
        int n = formXMLs.size();
        for (int i = 0; i < n; ++i) {
            HZElement formXML = formXMLs.get(i);
            XMLNodeForm tmpForm = new XMLNodeForm(formXML);
            result.add(tmpForm);
        }
        return result;
    }

    @Override
    public INodeForm getNodeForm(String formid) {
        HZElement formXML = XMLParseUtil.getElement(this.getXML(), "Forms");
        HZElement newXML = XMLParseUtil.getElement(formXML, "Form", "ID", formid);
        if (newXML == null) {
            return null;
        }
        XMLNodeForm form = new XMLNodeForm(newXML);
        return form;
    }

    @Override
    public boolean delNodeForm(String formid) {
        return false;
    }
}

