/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.api;

import com.horizon.wf.definition.impl.XmlEventImpl;
import com.horizon.wf.definition.impl.XmlRelationImpl;
import com.horizon.wf.definition.impl.XmlRouterImpl;
import com.horizon.wf.definition.pub.node.INodeEvent;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.pub.node.user.IUserRelation;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.UUIDFun;
import com.horizon.wf.definition.tools.XMLParseUtil;

public class XMLToRouter
extends XmlRouterImpl
implements INodeRouter {
    private HZElement XML;
    private HZElement mapXML;
    private String fromID;

    public XMLToRouter(HZElement XML) {
        super(XML);
        this.XML = XML;
    }

    public void setMapXML(HZElement mapXML) {
        this.mapXML = mapXML;
    }

    public void setFromID(String id) {
        this.fromID = id;
    }

    @Override
    public void setRouterPosition(int x1, int y1, int x2, int y2) {
        String id = this.getRouterid();
        String nodeid = this.getNodeid();
        if (nodeid == null || nodeid.length() == 0) {
            return;
        }
        HZElement nXML = XMLParseUtil.getElement(this.mapXML, "line", "ID", id);
        if (nXML == null) {
            nXML = XMLParseUtil.convertStringToXML("<line/>");
            XMLParseUtil.setAttribute(nXML, "ID", id);
            XMLParseUtil.addElement(this.mapXML, nXML);
        }
        XMLParseUtil.setAttribute(nXML, "Name", this.getRoutername());
        XMLParseUtil.setAttribute(nXML, "Type", "100");
        XMLParseUtil.setAttribute(nXML, "x1", "" + x1);
        XMLParseUtil.setAttribute(nXML, "y1", "" + y1);
        XMLParseUtil.setAttribute(nXML, "x2", "" + x2);
        XMLParseUtil.setAttribute(nXML, "y2", "" + y2);
        XMLParseUtil.setAttribute(nXML, "toID", nodeid);
        XMLParseUtil.setAttribute(nXML, "fromID", this.fromID);
    }

    public void setName(String name) {
        XMLParseUtil.setAttribute(this.XML, "Name", name);
        HZElement n = XMLParseUtil.getElement(this.mapXML, "line", "ID", this.getRouterid());
        XMLParseUtil.setAttribute(n, "Name", name);
    }

    @Override
    public void setNodename(String name) {
        XMLParseUtil.setAttribute(this.XML, "NodeName", name);
    }

    @Override
    public void setNodeid(String nodeid) {
        XMLParseUtil.setAttribute(this.XML, "NodeID", nodeid);
    }

    @Override
    public void setNodetype(int type) {
        XMLParseUtil.setAttribute(this.XML, "NodeType", "" + type);
    }

    public void setSortnum(int num) {
        XMLParseUtil.setAttribute(this.XML, "SortNum", "" + num);
    }

    @Override
    public void setDynamic(boolean isDynamic) {
        XMLParseUtil.setAttribute(this.XML, "Dynamic", isDynamic ? "1" : "0");
        HZElement nXML = XMLParseUtil.getElement(this.mapXML, "line", "ID", this.getRouterid());
        XMLParseUtil.setAttribute(nXML, "Dynamic", isDynamic ? "1" : "0");
    }

    @Override
    public boolean isDynamic() {
        String dynamic = XMLParseUtil.getAttribute(this.XML, "Dynamic");
        return "1".equals(dynamic);
    }

    public void setCondition(String con) {
        XMLParseUtil.setText(this.XML, "Condition", con);
    }

    public void setBCondition(String con) {
        XMLParseUtil.setText(this.XML, "BCondition", con);
    }

    public void setRuleClassName(String className) {
        XMLParseUtil.setTextAdd(this.XML, "RuleClassName", className);
    }

    public void setMemo(String memo) {
        XMLParseUtil.setText(this.XML, "Memo", memo);
    }

    @Override
    public INodeEvent getRouterEvent(String eventid) {
        INodeEvent event = super.getRouterEvent(eventid);
        if (event == null) {
            if (eventid == null || eventid.length() == 0) {
                eventid = UUIDFun.getUnid();
            }
            HZElement xEvent = XMLParseUtil.convertStringToXML("<Event/>");
            XMLParseUtil.setAttribute(xEvent, "ID", eventid);
            HZElement parentEvent = XMLParseUtil.getElement(this.XML, "Events");
            XMLParseUtil.addElement(parentEvent, xEvent);
            event = new XmlEventImpl(xEvent);
        }
        return event;
    }

    public boolean deleteEventById(String eventid) {
        HZElement eventXML = XMLParseUtil.getElement(this.XML, "Events/Event", "ID", eventid);
        if (eventXML == null) {
            return true;
        }
        return XMLParseUtil.remove(eventXML);
    }

    @Override
    public IUserRelation getRelation(String id) {
        IUserRelation event = super.getRelation(id);
        if (event == null) {
            if (id == null || id.length() == 0) {
                id = UUIDFun.getUnid();
            }
            HZElement xEvent = XMLParseUtil.convertStringToXML("<Relation/>");
            XMLParseUtil.setAttribute(xEvent, "ID", id);
            HZElement parentEvent = XMLParseUtil.getElement(this.XML, "Relations");
            XMLParseUtil.addElement(parentEvent, xEvent);
            event = new XmlRelationImpl(xEvent);
        }
        return event;
    }

    public boolean deleteRelation(String id) {
        HZElement eventXML = XMLParseUtil.getElement(this.XML, "Relations/Relation", "ID", id);
        if (eventXML == null) {
            return true;
        }
        return XMLParseUtil.remove(eventXML);
    }

    public void setRouterAuthorUnion(String r) {
        HZElement authorXML = XMLParseUtil.getElement(this.XML, "Author");
        XMLParseUtil.setAttribute(authorXML, "ReplaceFlag", r);
    }
}

