/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.api;

import com.horizon.wf.definition.api.XMLMap;
import com.horizon.wf.definition.api.XMLTemplate;
import com.horizon.wf.definition.api.XMLToRouter;
import com.horizon.wf.definition.impl.XmlEventImpl;
import com.horizon.wf.definition.impl.XmlNodeImpl;
import com.horizon.wf.definition.pub.IFlowMap;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeEvent;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.UUIDFun;
import com.horizon.wf.definition.tools.XMLParseUtil;
import java.util.ArrayList;
import java.util.List;

public class XMLNode
extends XmlNodeImpl
implements IFlowNode {
    private HZElement XML;
    private HZElement nodeXML;
    private HZElement mapXML;
    private IFlowMap flowMap;

    public XMLNode(HZElement XML) {
        super(XML);
        this.nodeXML = XML;
    }

    public void setAllXML(HZElement xml) {
        if (this.XML == null) {
            this.XML = xml;
        }
    }

    public void setMapXML(HZElement mapXML) {
        this.mapXML = mapXML;
    }

    @Override
    public void setFlowMap(IFlowMap flowMap) {
        XMLMap map = (XMLMap)flowMap;
        this.flowMap = flowMap;
        this.mapXML = map.getXML();
    }

    @Override
    public IFlowMap getFlowMap() {
        return this.flowMap;
    }

    @Override
    public void setNodePosition(int x, int y) {
        String nodeid = this.getNodeid();
        String nodename = this.getNodename();
        String nodetype = XMLParseUtil.getAttribute(this.nodeXML, "Type");
        HZElement nXML = XMLParseUtil.getElement(this.mapXML, "node", "ID", nodeid);
        if (nXML == null) {
            nXML = XMLParseUtil.convertStringToXML("<node/>");
            XMLParseUtil.setAttribute(nXML, "ID", nodeid);
            XMLParseUtil.addElement(this.mapXML, nXML);
        }
        XMLParseUtil.setAttribute(nXML, "Name", nodename);
        XMLParseUtil.setAttribute(nXML, "Type", nodetype);
        XMLParseUtil.setAttribute(nXML, "sub", "0");
        XMLParseUtil.setAttribute(nXML, "x", "" + x);
        XMLParseUtil.setAttribute(nXML, "y", "" + y);
    }

    @Override
    public void setDynamic(boolean isDynamic) {
        HZElement nXML = XMLParseUtil.getElement(this.mapXML, "node", "ID", this.getNodeid());
        XMLParseUtil.setAttribute(nXML, "Dynamic", isDynamic ? "1" : "0");
    }

    @Override
    public void setMapNodeSubFromCopyNode(Object cNode) {
        XMLNode copyNode = (XMLNode)cNode;
        HZElement copyXML = XMLParseUtil.getElement(this.mapXML, "node", "ID", copyNode.getNodeid());
        String flag = XMLParseUtil.getAttribute(copyXML, "sub");
        HZElement nXML = XMLParseUtil.getElement(this.mapXML, "node", "ID", this.getNodeid());
        XMLParseUtil.setAttribute(nXML, "sub", flag);
    }

    @Override
    public int[] getNodePosition() {
        String nodeid = this.getNodeid();
        HZElement nXML = XMLParseUtil.getElement(this.mapXML, "node", "ID", nodeid);
        int x = Integer.parseInt(XMLParseUtil.getAttribute("0", nXML, "x"));
        int y = Integer.parseInt(XMLParseUtil.getAttribute("0", nXML, "y"));
        int[] r = new int[]{x, y};
        return r;
    }

    public void setNodename(String nodeName) {
        XMLParseUtil.setAttribute(this.nodeXML, "Name", nodeName);
        String nodeid = this.getNodeid();
        HZElement n = XMLParseUtil.getElement(this.mapXML, "node", "ID", nodeid);
        if (n != null) {
            XMLParseUtil.setAttribute(n, "Name", nodeName);
        }
        this.getReleationNodeRouter(nodeid, "NodeName", nodeName);
    }

    public void setNodetype(int nodeType) {
        int type = Integer.parseInt(XMLParseUtil.getAttribute(this.nodeXML, "Type"));
        if (type == 100 || type == 101 || type < 10) {
            return;
        }
        XMLParseUtil.setAttribute(this.nodeXML, "Type", "" + nodeType);
        String nodeid = this.getNodeid();
        HZElement n = XMLParseUtil.getElement(this.mapXML, "node", "ID", nodeid);
        XMLParseUtil.setAttribute(n, "Type", "" + nodeType);
        this.getReleationNodeRouter(nodeid, "NodeType", "" + nodeType);
    }

    private void getReleationNodeRouter(String nodeid, String name, String value) {
        List<HZElement> lst = XMLParseUtil.getElements(this.XML, "WorkflowProcesses/WorkflowProcess/Transitions/ToRouter/Router");
        if (lst != null && lst.size() != 0) {
            String nodeID = "";
            int n = lst.size();
            for (int i = 0; i < n; ++i) {
                HZElement r = lst.get(i);
                nodeID = XMLParseUtil.getAttribute(r, "NodeID");
                if (!nodeID.equals(nodeid)) continue;
                XMLParseUtil.setAttribute(r, name, value);
            }
        }
    }

    public void setNextSelectType(int type) {
        XMLParseUtil.setAttribute(this.nodeXML, "nxtType", type == 2 ? "2" : "1");
    }

    public void getNextSelected(boolean flag) {
        XMLParseUtil.setAttribute(this.nodeXML, "nxtSelected", flag ? "1" : "0");
    }

    public void setAsyn(int flag) {
        XMLParseUtil.setAttribute(this.getXML(), "asyn", flag == 1 ? "1" : "0");
    }

    public void backAsyn(String flag) {
        XMLParseUtil.setAttribute(this.getXML(), "backAsyn", flag);
    }

    public int getBackAsyn() {
        return Integer.parseInt(XMLParseUtil.getAttribute("-1", this.getXML(), "backAsyn"));
    }

    public void delBackAsyn() {
        XMLParseUtil.removeAttribute(this.getXML(), "backAsyn");
    }

    public void setEditLock(boolean lock) {
        XMLParseUtil.setAttribute(this.nodeXML, "lock", lock ? "1" : "0");
    }

    public void setNodeLimit(int lType, int lDate, int wDate, int num, int type) {
        HZElement lXML = XMLParseUtil.getElement(this.nodeXML, "LimitSet");
        if (wDate > -1) {
            XMLParseUtil.setAttribute(lXML, "WaringDate", "" + wDate);
        }
        if (lType > -1) {
            XMLParseUtil.setAttribute(lXML, "LimitType", "" + lType);
        }
        if (lDate > -1) {
            XMLParseUtil.setAttribute(lXML, "LimitDate", "" + lDate);
        }
        if (num > -1) {
            XMLParseUtil.setAttribute(lXML, "ReMsgNum", "" + num);
        }
        if (type > -1) {
            XMLParseUtil.setText(lXML, "DoOverPass", "" + type);
        }
    }

    public void setNodeMemo(String memo) {
        XMLParseUtil.setText(this.nodeXML, "Memo", memo);
    }

    public void setRobotClassName(String classname) {
        XMLParseUtil.setText(this.nodeXML, "RobotClassName", classname);
    }

    public void setClusterClassName(String classname) {
        XMLParseUtil.setText(this.nodeXML, "Cluster/ClassName", classname);
    }

    public void setClusterUrl(String classname) {
        XMLParseUtil.setText(this.nodeXML, "Cluster/Url", classname);
    }

    public void setInteractiveClassName(String classname) {
        XMLParseUtil.setText(this.nodeXML, "Interactive", classname);
    }

    public void setNodeClassNam(String classname) {
        XMLParseUtil.setText(this.nodeXML, "NodeClassName", classname);
    }

    public void setDoPass(int per) {
        XMLParseUtil.setAttribute(this.nodeXML, "DoPass", "" + per);
    }

    public void setAutoPassCurUser(boolean flag) {
        XMLParseUtil.setAttribute(this.nodeXML, "AutoPassCurUser", flag ? "1" : "0");
    }

    public void setAutoPass(boolean flag) {
        XMLParseUtil.setAttribute(this.nodeXML, "AutoPass", flag ? "1" : "0");
    }

    public void setAgentFlag(boolean flag) {
        XMLParseUtil.setAttribute(this.nodeXML, "AgentFlag", flag ? "1" : "0");
    }

    public INodeEvent addNodeEvent(String eventid) {
        INodeEvent event = super.getNodeEvent(eventid);
        if (event == null) {
            if (eventid == null || eventid.length() == 0) {
                eventid = UUIDFun.getUnid();
            }
            HZElement xEvent = XMLParseUtil.convertStringToXML("<Event/>");
            XMLParseUtil.setAttribute(xEvent, "ID", eventid);
            HZElement parentEvent = XMLParseUtil.getElement(this.nodeXML, "Events");
            XMLParseUtil.addElement(parentEvent, xEvent);
            event = new XmlEventImpl(xEvent);
        }
        return event;
    }

    public boolean deleteEventById(String eventid) {
        HZElement eventXML = XMLParseUtil.getElement(this.nodeXML, "Events/Event", "ID", eventid);
        if (eventXML == null) {
            return true;
        }
        return XMLParseUtil.remove(eventXML);
    }

    public void setSubFlowWait(boolean wait) {
        XMLParseUtil.setAttribute(this.nodeXML, "SubFlow", "Wait", wait ? "1" : "0");
    }

    public void setSubFlowMulit(boolean mulit) {
        XMLParseUtil.setAttribute(this.nodeXML, "SubFlow", "Mulit", mulit ? "1" : "0");
    }

    public void setSubFlowList(List<List<String>> para) {
        int i;
        HZElement pXML = XMLParseUtil.getElement(this.nodeXML, "SubFlow");
        List<HZElement> sXMLs = XMLParseUtil.getElements(this.nodeXML, "SubFlow");
        int n = sXMLs.size();
        for (i = 0; i < n; ++i) {
            HZElement sXML = sXMLs.get(i);
            XMLParseUtil.removeNode(pXML, sXML);
        }
        if (para == null || para.size() == 0) {
            return;
        }
        n = para.size();
        for (i = 0; i < n; ++i) {
            List<String> tmp = para.get(i);
            HZElement tmpXML = XMLParseUtil.convertStringToXML("<Flow/>");
            XMLParseUtil.setAttribute(tmpXML, "ID", tmp.get(0));
            XMLParseUtil.setAttribute(tmpXML, "Name", tmp.get(1));
            XMLParseUtil.addElement(pXML, tmpXML);
        }
    }

    @Override
    public List<INodeRouter> getAllToRouters() {
        String nodeid = this.getNodeid();
        ArrayList<INodeRouter> result = new ArrayList<INodeRouter>();
        this.getToRouter(nodeid, this.getXML(), result, false);
        if (!nodeid.equals("Start")) {
            List<XMLNode> vXMLs = this.getAllVirtualNodes();
            int n = vXMLs.size();
            for (int i = 0; i < n; ++i) {
                XMLNode vNode = vXMLs.get(i);
                this.getToRouter(nodeid, vNode.getXML(), result, true);
            }
        }
        return result;
    }

    private void getToRouter(String nodeid, HZElement xml, List<INodeRouter> result, boolean check) {
        List<HZElement> rXMLs = XMLParseUtil.getElementList(xml, "Transitions/ToRouter");
        if (rXMLs == null || rXMLs.isEmpty()) {
            return;
        }
        int n = rXMLs.size();
        for (int i = 0; i < n; ++i) {
            String executions;
            String includes;
            HZElement rXML = rXMLs.get(i);
            XMLToRouter e = new XMLToRouter(rXML);
            String eNodeid = e.getNodeid();
            if (eNodeid.equals(nodeid)) continue;
            e.setFromID(nodeid);
            e.setMapXML(this.mapXML);
            if (check && (";".equals(includes = e.getIncludes() + ";") ? !";".equals(executions = e.getExecutions() + ";") && executions.indexOf(nodeid + ";") != -1 : includes.indexOf(nodeid + ";") == -1)) continue;
            result.add(e);
        }
    }

    private List<XMLNode> getAllVirtualNodes() {
        HZElement parentXML = XMLParseUtil.getParent(this.getXML());
        List<HZElement> nodesXML = XMLParseUtil.getElementList(parentXML, "");
        ArrayList<XMLNode> nodes = new ArrayList<XMLNode>();
        int n = nodesXML.size();
        for (int i = 0; i < n; ++i) {
            HZElement nodeXML = nodesXML.get(i);
            XMLNode node = new XMLNode(nodeXML);
            int nodeType = node.getNodetype();
            if (nodeType != 900) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public INodeRouter addToRouter(String id) {
        HZElement pXML = XMLParseUtil.getElementAdd(this.nodeXML, "Transitions/ToRouter");
        HZElement newXML = null;
        int nodeType = this.getNodetype();
        if (id == null || id.length() == 0) {
            List<INodeRouter> r;
            if (nodeType == 210 && (r = this.getAllToRouters()).size() > 0) {
                return null;
            }
            int lineNum = Integer.parseInt(XMLParseUtil.getAttribute("0", this.mapXML, "LineNum"));
            id = "Line" + ++lineNum;
            XMLParseUtil.setAttribute(this.mapXML, "LineNum", "" + lineNum);
            newXML = XMLParseUtil.convertStringToXML(XMLTemplate.getInstance().getNewRouterXML());
            XMLParseUtil.setAttribute(newXML, "ID", id);
            XMLParseUtil.setAttribute(newXML, "Name", "\u65b0\u8def\u7531" + lineNum);
            XMLParseUtil.addElement(pXML, newXML);
        } else {
            newXML = XMLParseUtil.getElement(pXML, "Router", "ID", id);
        }
        if (newXML == null) {
            return null;
        }
        XMLToRouter router = new XMLToRouter(newXML);
        router.setMapXML(this.mapXML);
        router.setFromID(this.getNodeid());
        return router;
    }

    @Override
    public boolean deleteToRouter(String id) {
        HZElement pXML;
        HZElement nXML = XMLParseUtil.getElement(this.mapXML, "line", "ID", id);
        if (nXML != null) {
            XMLParseUtil.removeNode(this.mapXML, nXML);
        }
        if ((pXML = XMLParseUtil.getElement(this.nodeXML, "Transitions/ToRouter/Router", "ID", id)) == null) {
            return true;
        }
        return XMLParseUtil.remove(pXML);
    }
}

