/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.wf.definition.api;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.definition.api.XMLFlowForm;
import com.horizon.wf.definition.api.XMLMap;
import com.horizon.wf.definition.api.XMLNode;
import com.horizon.wf.definition.api.XMLTemplate;
import com.horizon.wf.definition.api.XMLToRouter;
import com.horizon.wf.definition.api.XMLUser;
import com.horizon.wf.definition.impl.XmlControlImpl;
import com.horizon.wf.definition.impl.XmlFlowInfoImpl;
import com.horizon.wf.definition.json.JSONButton;
import com.horizon.wf.definition.json.JSONControl;
import com.horizon.wf.definition.json.JSONEvent;
import com.horizon.wf.definition.json.JSONException;
import com.horizon.wf.definition.json.JSONFlowForm;
import com.horizon.wf.definition.json.JSONFlowInfo;
import com.horizon.wf.definition.json.JSONFlowVar;
import com.horizon.wf.definition.json.JSONMap;
import com.horizon.wf.definition.json.JSONNode;
import com.horizon.wf.definition.json.JSONNodeForm;
import com.horizon.wf.definition.json.JSONNodePara;
import com.horizon.wf.definition.json.JSONRelation;
import com.horizon.wf.definition.json.JSONRouter;
import com.horizon.wf.definition.json.JSONSubflow;
import com.horizon.wf.definition.json.JSONUser;
import com.horizon.wf.definition.json.map.JsonMapLine;
import com.horizon.wf.definition.json.map.JsonMapNode;
import com.horizon.wf.definition.json.map.JsonMapSwimlane;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.info.IFlowForm;
import com.horizon.wf.definition.pub.info.IFlowVar;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeEvent;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.definition.pub.node.INodePara;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.pub.node.INodeSubflow;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.definition.pub.node.user.IUserRelation;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.definition.tools.UUIDFun;
import com.horizon.wf.definition.tools.XMLParseUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class XMLFlowInfo
extends XmlFlowInfoImpl {
    private HZElement MapXML;
    private int maxNum = 0;
    private boolean isStart = false;

    public XMLFlowInfo(HZElement XML) {
        super(XML);
        this.MapXML = XMLParseUtil.getElement(XML, "MapXML");
    }

    public void setMapXML(HZElement mapXML) {
        this.MapXML = mapXML;
    }

    public void setId(String id) {
        XMLParseUtil.setAttribute(this.getXML(), "id", id);
    }

    public void setVersion(int version) {
        XMLParseUtil.setText(this.getXML(), "TypeDeclarations/Version", "" + version);
    }

    public void setFlowid(String flowid) {
        XMLParseUtil.setText(this.getXML(), "TypeDeclarations/FlowID", flowid);
    }

    public void setFlowname(String flowname) {
        XMLParseUtil.setText(this.getXML(), "TypeDeclarations/FlowName", flowname);
    }

    public void setFlowType(String type1, String type2) {
        XMLParseUtil.setText(this.getXML(), "TypeDeclarations/Type", type1);
        XMLParseUtil.setAttribute(this.getXML(), "TypeDeclarations/Type", "ID", type2);
    }

    public void setMemo(String memo) {
        XMLParseUtil.setText(this.getXML(), "TypeDeclarations/Memo", memo);
    }

    public void setActive(boolean active) {
        XMLParseUtil.setAttribute(this.getXML(), "ActiveFlag", active ? "1" : "0");
    }

    public void setActivitySet(String flag) {
        XMLParseUtil.setAttribute(this.getXML(), "TypeDeclarations/ActivitySet", "Flag", flag);
    }

    @Override
    public IFlowForm getFlowForm(String formid) {
        IFlowForm form = super.getFlowForm(formid);
        if (form == null) {
            if (formid == null || formid.length() == 0) {
                formid = UUIDFun.getUnid();
            }
            HZElement formXML = XMLParseUtil.getElement(this.getXML(), "TypeDeclarations/Forms");
            HZElement newXML = XMLParseUtil.convertStringToXML("<Form/>");
            XMLParseUtil.setAttribute(newXML, "ID", formid);
            XMLParseUtil.setAttribute(newXML, "Name", "\u8868\u5355");
            if (formid.equals("FlowTrack")) {
                XMLParseUtil.setAttribute(newXML, "Name", "\u6d41\u7a0b\u8ddf\u8e2a");
            }
            XMLParseUtil.addElement(formXML, newXML);
            form = new XMLFlowForm(newXML);
        }
        return form;
    }

    public boolean delFlowForm(String formid) {
        HZElement formXML = XMLParseUtil.getElement(this.getXML(), "TypeDeclarations/Forms/Form", "ID", formid);
        if (formXML == null) {
            return true;
        }
        return XMLParseUtil.remove(formXML);
    }

    public void setManager(String role) {
        XMLParseUtil.setText(this.getXML(), "TypeDeclarations/Participants/Manager/Role", role);
    }

    public void setManagerStart(boolean flag) {
        XMLParseUtil.setAttribute(this.getXML(), "TypeDeclarations/Participants/Manager", "Startup", flag ? "1" : "0");
    }

    public void setReader(List<String> para) {
        HZElement tmp = XMLParseUtil.getElement(this.getXML(), "TypeDeclarations/Participants/Reader");
        XMLParseUtil.setText(tmp, "Person", para.get(0));
        XMLParseUtil.setText(tmp, "Dept", para.get(1));
        XMLParseUtil.setText(tmp, "Group", para.get(2));
        XMLParseUtil.setText(tmp, "Role", para.get(3));
    }

    public void setReaderMsg(String flag) {
        XMLParseUtil.setAttribute(this.getXML(), "TypeDeclarations/Participants/Reader", "MsgFlag", flag);
    }

    @Override
    public List<IFlowNode> getAllNodes() {
        List<HZElement> nodesXML = XMLParseUtil.getElementList(this.getXML(), "WorkflowProcesses");
        ArrayList<IFlowNode> nodes = new ArrayList<IFlowNode>();
        this.maxNum = 0;
        int n = nodesXML.size();
        for (int i = 0; i < n; ++i) {
            HZElement nodeXML = nodesXML.get(i);
            XMLNode node = new XMLNode(nodeXML);
            int type = Integer.parseInt(XMLParseUtil.getAttribute(nodeXML, "Type"));
            node.setMapXML(this.MapXML);
            node.setAllXML(this.getXML());
            if (type < 10) {
                this.isStart = true;
            } else {
                ++this.maxNum;
            }
            nodes.add(node);
        }
        int r = Integer.parseInt(XMLParseUtil.getAttribute("0", this.MapXML, "NodeNum"));
        if (r > this.maxNum) {
            this.maxNum = r;
        }
        return nodes;
    }

    @Override
    public IFlowNode getNodeById(String nodeid) {
        HZElement nodeXML = XMLParseUtil.getElement(this.getXML(), "WorkflowProcesses/WorkflowProcess", "ID", nodeid);
        if (nodeXML == null) {
            return null;
        }
        XMLNode node = new XMLNode(nodeXML);
        node.setMapXML(this.MapXML);
        node.setAllXML(this.getXML());
        return node;
    }

    public IFlowNode getNewNode(String name, int type) {
        return this.getNewNode(name, type, XMLTemplate.getInstance().getNewNodeXML());
    }

    @Override
    public IFlowNode getCopyNode(Object node, String name) {
        XMLNode tNode = (XMLNode)node;
        int type = tNode.getNodetype();
        return this.getNewNode(name, type, tNode.getDataString());
    }

    private IFlowNode getNewNode(String name, int type, String xml) {
        String id = "";
        if (type < 10) {
            if (this.isStart) {
                return null;
            }
            this.isStart = true;
            id = "Start";
        } else {
            if (this.maxNum == 0) {
                this.getAllNodes();
            }
            id = this.getNodePreFix(type) + ++this.maxNum;
            XMLParseUtil.setAttribute(this.MapXML, "NodeNum", "" + this.maxNum);
        }
        HZElement nodeXML = XMLParseUtil.convertStringToXML(xml);
        XMLParseUtil.setAttribute(nodeXML, "ID", id);
        XMLParseUtil.setAttribute(nodeXML, "Type", "" + type);
        XMLParseUtil.setAttribute(nodeXML, "Name", name);
        XMLParseUtil.removeNode(nodeXML, "Transitions/ToRouter");
        if (id.equals("Start")) {
            XMLParseUtil.removeNode(nodeXML, "Participants/Reader");
            XMLParseUtil.removeNode(nodeXML, "Participants/SecondAuthor");
        } else if (id.indexOf("End") != -1) {
            XMLParseUtil.removeNode(nodeXML, "Participants/Author");
            XMLParseUtil.removeNode(nodeXML, "Participants/SecondAuthor");
        }
        XMLNode node = new XMLNode(nodeXML);
        node.setAllXML(this.getXML());
        node.setMapXML(this.MapXML);
        HZElement parentXML = XMLParseUtil.getElement(this.getXML(), "WorkflowProcesses");
        XMLParseUtil.addElement(parentXML, nodeXML);
        return node;
    }

    private String getNodePreFix(int nodetype) {
        return NodeTypeEnum.getNodePreFix(nodetype);
    }

    @Override
    public void deleteNodeById(String nodeid) {
        HZElement nodeXML;
        HZElement nXML = XMLParseUtil.getElement(this.MapXML, "node", "ID", nodeid);
        if (nXML != null) {
            XMLParseUtil.removeNode(this.MapXML, nXML);
        }
        if ((nodeXML = XMLParseUtil.getElement(this.getXML(), "WorkflowProcesses/WorkflowProcess", "ID", nodeid)) == null) {
            return;
        }
        XMLParseUtil.remove(nodeXML);
    }

    @Override
    public String getMapStr() {
        return this.MapXML.asXML();
    }

    public JSONFlowInfo chgXmlToJson() {
        JSONFlowInfo flowInfo = new JSONFlowInfo(new JSONObject());
        this.setFlowProperties(flowInfo);
        JSONMap jsonMap = flowInfo.getJsonMap();
        jsonMap.setFlowid(flowInfo.getFlowid());
        this.chgMap(jsonMap);
        for (IFlowNode node1 : this.getAllNodes()) {
            String[] auths;
            XMLNode node = (XMLNode)node1;
            String nodeid = node.getNodeid();
            JSONNode jsonNode = (JSONNode)flowInfo.addNewNode(nodeid);
            jsonNode.setNodeid(nodeid);
            jsonNode.setNodename(node.getNodename());
            jsonNode.setNodetype(node.getNodetype());
            jsonNode.setNextSelectType(node.getNextSelectType());
            jsonNode.setNodeClassName(node.getNodeClassName());
            jsonNode.setEntryRuleClassName(node.getEntryRulesClassName());
            if (!node.getEntryRulesStrpit().equals("")) {
                jsonNode.setEntryRulesScript(node.getEntryRulesId(), this.decodeRule(node.getEntryRulesStrpit()), this.decodeRule(node.getEntryRulesCN()));
            }
            jsonNode.setLeaveRulesClassName(node.getLeaveRulesClassName());
            if (!node.getLeaveRulesScript().equals("")) {
                jsonNode.setLeaveRulesScript(node.getLeaveRulesId(), this.decodeRule(node.getLeaveRulesScript()), this.decodeRule(node.getLeaveRulesCN()));
            }
            jsonNode.setNodeLimit(node.getNodeLimit());
            jsonNode.setNodeMemo(node.getNodeMemo());
            jsonNode.setRejectOtherBranch(node.getRejectOtherBranch());
            int startModeType = Integer.parseInt(node.getStartModeType());
            jsonNode.setStartModeType(startModeType);
            switch (startModeType) {
                case 1: {
                    jsonNode.setStartModeTimeDate(node.getStartModeTimeDate());
                    jsonNode.setStartModeTimeCycle(node.getStartModeTimeCycle());
                    jsonNode.setStartModeRetry(node.getStartModeRetry() ? 1 : 0);
                    jsonNode.setStartModeNum(node.getStartModeNum());
                    jsonNode.setStartModeClass(node.getStartModeClass());
                    break;
                }
                case 2: {
                    jsonNode.setStartModeTriggerMessageType(node.getStartModeTriggerMessageType());
                    jsonNode.setStartModeTriggerMessageFrom(node.getStartModeTriggerMessageFrom());
                    jsonNode.setStartModeTriggerMessageID(node.getStartModeTriggerMessageID());
                    jsonNode.setStartModeTriggerMessageName(node.getStartModeTriggerMessageName());
                    jsonNode.setStartModeTriggerMessageTo(node.getStartModeTriggerMessageTo());
                    jsonNode.setStartModeTriggerMessagePara(node.getStartModeTriggerMessagePara());
                    jsonNode.setStartModeTriggerMessageClass(node.getStartModeTriggerMessageClass());
                    break;
                }
                case 3: {
                    jsonNode.setStartModeSignalPara(node.getEventFlowVar());
                    jsonNode.setStartModeSignalClass(node.getEventClassName());
                }
            }
            this.setNodeSpcial(jsonNode, node);
            for (INodeAuthUser iuser : node.getParticipantsUserList()) {
                XMLUser auth = (XMLUser)iuser;
                String authId = auth.getAuthName();
                JSONUser user = (JSONUser)jsonNode.getParticipantsUserAdd(authId);
                user.setAuthName(authId);
                user.setAuthCnName(auth.getAuthCnName());
                user.setPerson(auth.getPerson());
                user.setDept(auth.getDept());
                user.setGroup(auth.getGroup());
                user.setPosition(auth.getPosition());
                user.setFormField(auth.getFormField());
                user.setFlowVarUnion(auth.getFormFieldUnion());
                user.setFlowVar(auth.getFlowVar());
                user.setFlowVarUnion(auth.getFlowVardUnion());
                user.setRuleScript(auth.getRuleId(), this.decodeRule(auth.getRuleScript()), this.decodeRule(auth.getRuleCN()));
                ArrayList<JSONRelation> relations = new ArrayList<JSONRelation>();
                for (IUserRelation relation : auth.getAllRelations()) {
                    JSONRelation relationJson = new JSONRelation(new JSONObject());
                    relationJson.setBase(relation.getBase());
                    relationJson.setBaseNode(relation.getBaseNode());
                    relationJson.setRelation(relation.getRelation());
                    relationJson.setGatherType(relation.getGatherType());
                    relationJson.setTargetRange(relation.getTargetRange());
                    relations.add(relationJson);
                }
                if (!relations.isEmpty()) {
                    user.setAllRelations(relations);
                }
                user.setCustome(auth.getCustome());
                user.setCustome_Active(auth.getCustome_Active() ? 1 : 0);
                user.setCustome_ClassName(auth.getCustome_ClassName());
                user.setSendMsgFlag(auth.getSendMsgFlag());
                user.setControlAttribute(auth.getControlAttribute());
                user.setNodeForPassNodeUser(auth.getNodeForPassNodeUser());
            }
            for (String auth : auths = this.getParticipantTypes().split(";")) {
                INodeControl control = node.getParticipantsControl(auth + "_DO");
                if (control == null) continue;
                JSONControl controlJson = (JSONControl)jsonNode.addNewControl(auth);
                controlJson.setAuthId(auth);
                controlJson.setAllowGetBackNode(control.getAllowGetBackNode());
                controlJson.setAllowRejectNode(control.getAllowRejectNode());
                controlJson.setDefaultShowFormID(control.getDefaultShowFormID());
                ArrayList<JSONButton> buttons = new ArrayList<JSONButton>();
                for (INodeButton button : ((XmlControlImpl)control).getButton()) {
                    JSONButton btnJson = new JSONButton(new JSONObject());
                    String btnId = button.getButtonId();
                    if (btnId == null || btnId.equals("")) continue;
                    btnJson.setButtonId(button.getButtonId());
                    btnJson.setButtonName(button.getButtonName());
                    btnJson.setButtonReName(button.getButtonReName());
                    btnJson.setImplClass(button.getImplClass());
                    buttons.add(btnJson);
                }
                controlJson.setButton(buttons);
                int sort = 0;
                for (INodeForm form : ((XmlControlImpl)control).getAllNodeForms()) {
                    String formid = form.getFormid();
                    JSONNodeForm formJson = controlJson.getNodeForm(formid);
                    formJson.setFormid(formid);
                    formJson.setSort(sort++);
                    formJson.setRealFormid(form.getRealFormid());
                    formJson.setFormButton(form.getFormButton());
                }
            }
            for (INodeEvent event : node.getAllEvents()) {
                String eventid = event.getDoType();
                JSONEvent eventJson = (JSONEvent)jsonNode.getNodeEvent(eventid);
                eventJson.setEventid(event.getEventid());
                eventJson.setEventname(event.getEventname());
                eventJson.setDoType(event.getDoType());
                eventJson.setScript(event.getScript());
            }
            List<INodeSubflow> subs = node.getSubFlowList();
            if (!subs.isEmpty()) {
                jsonNode.setSubFlowMuilt(node.getSubFlowMuilt() ? 1 : 0);
                jsonNode.setSubFlowWait(node.getSubFlowWait() ? 1 : 0);
                ArrayList<INodeSubflow> subflows = new ArrayList<INodeSubflow>();
                JSONObject subflow = new JSONObject();
                for (INodeSubflow sub : subs) {
                    JSONSubflow flowJson = new JSONSubflow(new JSONObject());
                    flowJson.setSubFlowId(sub.getSubFlowId());
                    flowJson.setSubFlowName(sub.getSubFlowName());
                    flowJson.setSubFlowPara(sub.getSubFlowParaList());
                    subflows.add(flowJson);
                    subflow.put(flowJson.getSubFlowId(), (Object)flowJson.getSubFlowName());
                }
                jsonNode.setSubFlowList(subflows);
                JsonMapNode mapNode = jsonMap.getNodeById(nodeid);
                mapNode.setSubflow(subflow);
            }
            ArrayList<INodeException> exceptions = new ArrayList<INodeException>();
            for (INodeException exception : node.getExceptions()) {
                JSONException exceptionJson = new JSONException(new JSONObject());
                exceptionJson.setExceptionCode(exception.getExceptionCode());
                exceptionJson.setExceptionDeal(exception.getExceptionDeal());
                exceptionJson.setExceptionDealType(exception.getExceptionDealType());
                exceptionJson.setExceptionMsg(exception.getExceptionMsg());
                exceptionJson.setExceptionName(exception.getExceptionName());
                exceptionJson.setExceptionSendUser(exception.getExceptionSendUser());
                exceptions.add(exceptionJson);
            }
            if (!exceptions.isEmpty()) {
                jsonNode.setExceptions(exceptions);
            }
            ArrayList<INodePara> paras = new ArrayList<INodePara>();
            for (INodePara para : node.getAllNodePara()) {
                JSONNodePara paraJson = new JSONNodePara(new JSONObject());
                paraJson.setParaId(para.getParaId());
                paraJson.setParaName(para.getParaName());
                paraJson.setInitialValue(para.getInitialValue());
                paras.add(paraJson);
            }
            if (!paras.isEmpty()) {
                jsonNode.setAllNodePara(paras);
            }
            ArrayList<INodeRouter> routers = new ArrayList<INodeRouter>();
            for (INodeRouter router : node.getAllToRouters()) {
                String routerId = router.getRouterid();
                JSONRouter routerJson = new JSONRouter(new JSONObject());
                routerJson.setJsonMap(jsonMap);
                routerJson.setRouterid(routerId);
                routerJson.setRoutername(router.getRoutername());
                routerJson.setNodeid(router.getNodeid());
                routerJson.setNodename(router.getNodename());
                routerJson.setSortnum(router.getSortnum());
                routerJson.setCondition(router.getCondition());
                routerJson.setBCondition(router.getBCondition());
                routerJson.setExecutions(router.getExecutions());
                routerJson.setIncludes(router.getIncludes());
                routerJson.setNodetype(router.getNodetype());
                routerJson.setRuleClassName(router.getRuleClassName());
                String script = router.getRuleScript();
                if (!"".equals(script)) {
                    XMLToRouter router1 = (XMLToRouter)router;
                    routerJson.setRuleScript(router1.getRuleId(), this.decodeRule(script), this.decodeRule(router1.getRuleCN()));
                }
                routerJson.setMemo(router.getMemo());
                routers.add(routerJson);
            }
            if (routers.isEmpty()) continue;
            jsonNode.setAllRouters(routers);
        }
        JSONObject ruleJson = flowInfo.makeRuleForChgXmlToJson();
        List<HZElement> rules = XMLParseUtil.getElementList(this.getXML(), "RuleHtml");
        if (rules != null) {
            int n = rules.size();
            for (int i = 0; i < n; ++i) {
                HZElement rule = rules.get(i);
                String id = XMLParseUtil.getAttribute(rule, "ID");
                String html = XMLParseUtil.getText(rule);
                ruleJson.put(id, (Object)html);
            }
        }
        return flowInfo;
    }

    private String decodeRule(String script) {
        try {
            String ruleSetName = URLDecoder.decode(script, "UTF-8");
            return ruleSetName;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void setNodeSpcial(JSONNode jsonNode, XMLNode node) {
        int nodetype = jsonNode.getNodetype();
        switch (nodetype) {
            case 11: {
                jsonNode.setGrabFlag(node.getGrabFlag());
                break;
            }
            case 20: {
                jsonNode.setAsyn(node.getAsyn());
                jsonNode.setEditLock(node.getEditLock() ? 1 : 0);
                jsonNode.setDoPassType(node.getDoPassType());
                jsonNode.setDoPassParameter(node.getDoPassParameter());
                break;
            }
            case 50: {
                jsonNode.setProgressivelyClassName(node.getProgressivelyClassName());
                break;
            }
            case 30: {
                jsonNode.setMergerAllMaybeReachNode(node.isMergeAllMaybeReachNode() ? 1 : 0);
                jsonNode.setMergerLeaveType(node.getMergerLeaveType());
                jsonNode.setMergerLeaveParameter(node.getMergerLeaveParameter());
                jsonNode.setMergerActiveType(node.getMergerActiveType());
                jsonNode.setMergerActiveParameter(node.getMergerActiveParameter());
                jsonNode.setCancelOtherBranchAfterMergerActivated(node.cancelOtherBranchAfterMergerActivated() ? 1 : 0);
                jsonNode.setAllowSubmitAgainAfterMergerSubmitted(node.allowSubmitAgainAfterMergerSubmitted() ? 1 : 0);
                jsonNode.setAllowReSelectAuthorAfterReActive(node.allowReSelectAuthorAfterReActive() ? 1 : 0);
                break;
            }
            case 41: {
                jsonNode.setRobotClassName(node.getRobotClassName());
                break;
            }
            case 60: {
                break;
            }
            case 71: 
            case 72: {
                jsonNode.setGateWayClass(node.getGateWayClass());
                if (!node.getGateWayRule().equals("")) {
                    jsonNode.setGateWayRule(node.getGateWayId(), node.getGateWayRule(), node.getGateWayCN());
                }
                jsonNode.setCancelOtherBranchAfterMergerActivated(node.cancelOtherBranchAfterMergerActivated() ? 1 : 0);
                jsonNode.setAllowSubmitAgainAfterMergerSubmitted(node.allowSubmitAgainAfterMergerSubmitted() ? 1 : 0);
                break;
            }
            case 81: {
                jsonNode.setEventClassName(node.getEventClassName());
                break;
            }
            case 82: {
                jsonNode.setEventTime(node.getStartModeTimeDate());
                jsonNode.setEventTimeCycle(node.getStartModeTimeCycle());
                jsonNode.setEventTimeRetry(node.getStartModeRetry() ? 1 : 0);
                jsonNode.setEventNum(node.getStartModeNum());
                jsonNode.setEventTimeClass(node.getStartModeClass());
                break;
            }
            case 83: {
                jsonNode.setEventTriggerMessageType(node.getStartModeTriggerMessageType());
                jsonNode.setEventTriggerMessageFrom(node.getStartModeTriggerMessageFrom());
                jsonNode.setEventTriggerMessageID(node.getStartModeTriggerMessageID());
                jsonNode.setEventTriggerMessageName(node.getStartModeTriggerMessageName());
                jsonNode.setEventTriggerMessageTo(node.getStartModeTriggerMessageTo());
                jsonNode.setEventTriggerMessagePara(node.getStartModeTriggerMessagePara());
                jsonNode.setEventTriggerMessageClass(node.getStartModeTriggerMessageClass());
                break;
            }
            case 84: 
            case 85: {
                jsonNode.setEventSignalPara(node.getEventFlowVar());
                jsonNode.setEventSignalClass(node.getEventClassName());
                break;
            }
            case 210: {
                jsonNode.setClusterClassName(node.getClusterClassName());
                jsonNode.setClusterUrl(node.getClusterUrl());
                jsonNode.setInteractiveClassName(node.getInteractiveClassName());
            }
        }
    }

    private void setFlowProperties(JSONFlowInfo flowInfo) {
        flowInfo.setId(XMLParseUtil.getAttribute(this.getXML(), "id"));
        flowInfo.setActive(this.getActive());
        int i = 0;
        for (IFlowForm form : this.getAllFlowForms()) {
            String formid = form.getFormid();
            JSONFlowForm jsonFlowForm = flowInfo.getFlowForm(formid);
            jsonFlowForm.setFormid(formid);
            jsonFlowForm.setFlowname(form.getFormname());
            jsonFlowForm.setFormdata(form.getFormdata());
            jsonFlowForm.setFormgroup(form.getFormgroup());
            jsonFlowForm.setFormtype(form.getFormtype());
            jsonFlowForm.setIsMain(form.getIsmain() ? 1 : 0);
            jsonFlowForm.setTableid(form.getTableid());
            jsonFlowForm.setSort(i++);
            jsonFlowForm.setVersion(Integer.parseInt(form.getVersion()));
        }
        ArrayList<JSONFlowVar> vars = new ArrayList<JSONFlowVar>();
        for (IFlowVar var : this.getAllVar()) {
            JSONFlowVar jsonFlowVar = new JSONFlowVar(new JSONObject());
            jsonFlowVar.setVarId(var.getVarId());
            jsonFlowVar.setVarName(var.getVarName());
            jsonFlowVar.setVarType(var.getVarType());
            jsonFlowVar.setVarFrom(var.getVarFrom());
            jsonFlowVar.setLength(var.getLength());
            jsonFlowVar.setInitialValue(var.getInitialValue());
            jsonFlowVar.setDescription(var.getDescription());
            vars.add(jsonFlowVar);
        }
        if (!vars.isEmpty()) {
            flowInfo.setAllVar(vars);
        }
        flowInfo.setCheckRoleClassName(this.getCheckRoleClassName());
        flowInfo.setCreated(XMLParseUtil.getText(this.getXML(), "TypeDeclarations/Created"));
        flowInfo.setCreator(XMLParseUtil.getText(this.getXML(), "TypeDeclarations/Vendor"));
        flowInfo.setFlowid(this.getFlowid());
        flowInfo.setFlowname(this.getFlowname());
        flowInfo.setFlowType(this.getFlowType());
        flowInfo.setFlowTypeName(this.getFlowTypeName());
        flowInfo.setLimitSet(this.getLimitSet());
        flowInfo.setMemo(this.getMemo());
        flowInfo.setModifier(XMLParseUtil.getText(this.getXML(), "TypeDeclarations/Update"));
        flowInfo.setOpenTodoFlag(this.getOpenTodoFlag());
        flowInfo.setParticipantAuth(this.getParticipantAuth());
        flowInfo.setParticipantIds(this.getParticipantTypes());
        flowInfo.setParticipantNames(this.getParticipantNames());
        flowInfo.setRelationRuleClassName(this.getRelationRuleClassName());
        flowInfo.setSaveLocal(this.getSaveLocal());
        flowInfo.setStartRuleClassName(this.getStartRuleClassName());
        flowInfo.setTrackLogClassName(this.getTrackLogClassName());
        flowInfo.setUpdateToDB(Integer.parseInt(XMLParseUtil.getText(this.getXML(), "TypeDeclarations/IsUpdateToDB")));
        flowInfo.setUpdate(XMLParseUtil.getText(this.getXML(), "TypeDeclarations/Modified"));
        JSONUser reader = new JSONUser(new JSONObject());
        reader.setAuthName("Reader");
        reader.setAuthCnName("\u8bfb\u8005");
        List<String> readerstr = this.getReader();
        if (readerstr.size() > 0) {
            reader.setPerson(readerstr.get(0));
            reader.setDept(readerstr.get(1));
            reader.setGroup(readerstr.get(2));
            reader.setPosition(readerstr.get(4));
        }
        reader.setSendMsgFlag(this.getReaderMsg());
        flowInfo.setUserReader(reader);
        flowInfo.setVersion(this.getVersion());
    }

    private void chgMap(JSONMap jsonMap) {
        XMLMap xmlMap = new XMLMap(this.MapXML);
        jsonMap.setLineNum(xmlMap.getLineNum());
        jsonMap.setNodeNum(xmlMap.getNodeNum());
        jsonMap.setFlowname(xmlMap.getTitle());
        List<HZElement> nodes = xmlMap.getAllNodes();
        for (HZElement node : nodes) {
            String nodeid = XMLParseUtil.getAttribute(node, "ID");
            JsonMapNode jsonMapNode = jsonMap.addNewNode(nodeid);
            jsonMapNode.setId(nodeid);
            jsonMapNode.setName(XMLParseUtil.getAttribute(node, "Name"));
            jsonMapNode.setNodeType(Integer.parseInt(XMLParseUtil.getAttribute(node, "Type")));
            jsonMapNode.setSub(Integer.parseInt(XMLParseUtil.getAttribute("0", node, "sub")));
            jsonMapNode.setX(this.getInterFromString(XMLParseUtil.getAttribute(node, "x")));
            jsonMapNode.setY(this.getInterFromString(XMLParseUtil.getAttribute(node, "y")));
        }
        for (HZElement line : xmlMap.getAllLines()) {
            String lineid = XMLParseUtil.getAttribute(line, "ID");
            JsonMapLine jsonMapLine = jsonMap.addNewLine(lineid);
            jsonMapLine.setId(lineid);
            jsonMapLine.setName(XMLParseUtil.getAttribute(line, "Name"));
            jsonMapLine.setFrom(XMLParseUtil.getAttribute(line, "fromID"));
            jsonMapLine.setTo(XMLParseUtil.getAttribute(line, "toID"));
            String startNodeAP = XMLParseUtil.getAttribute(line, "startNodeAP");
            if ("".equals(startNodeAP)) {
                jsonMapLine.setLineType(1);
                jsonMapLine.setX1(this.getInterFromString(XMLParseUtil.getAttribute(line, "x1")) - 25);
                jsonMapLine.setY1(this.getInterFromString(XMLParseUtil.getAttribute(line, "y1")) - 25);
                jsonMapLine.setX2(this.getInterFromString(XMLParseUtil.getAttribute(line, "x2")) - 25);
                jsonMapLine.setY2(this.getInterFromString(XMLParseUtil.getAttribute(line, "y2")) - 25);
                continue;
            }
            jsonMapLine.setLineType(2);
            JsonMapNode from = jsonMap.getNodeById(jsonMapLine.getFrom());
            JsonMapNode to = jsonMap.getNodeById(jsonMapLine.getTo());
            jsonMapLine.setX1(from.getX());
            jsonMapLine.setY1(from.getY());
            jsonMapLine.setX2(to.getX());
            jsonMapLine.setY2(to.getY());
        }
        HZElement swimXml = XMLParseUtil.getElement(this.MapXML, "ZND");
        if (swimXml != null) {
            JsonMapSwimlane jsonMapSwimlane = jsonMap.getSwimlane();
            jsonMapSwimlane.setId("swimlane");
            jsonMapSwimlane.setName(XMLParseUtil.getAttribute(swimXml, "name"));
            int fx = Integer.parseInt(XMLParseUtil.getAttribute(swimXml, "fx"));
            jsonMapSwimlane.setLanetype(fx == 1 ? 1 : 2);
            List<HZElement> rects = XMLParseUtil.getElements(swimXml, "rect");
            int size = rects.size();
            int[] width = new int[size];
            String[] name = new String[size];
            int k = 0;
            for (HZElement rect : rects) {
                width[k] = this.getInterFromString(XMLParseUtil.getAttribute(rect, "rHeight"));
                name[k++] = XMLParseUtil.getAttribute(rect, "name");
            }
            jsonMapSwimlane.setLanNum(size);
            jsonMapSwimlane.setLaneName(name);
            jsonMapSwimlane.setLaneWidth(width);
        }
    }

    private int getInterFromString(String i) {
        return Double.valueOf(i).intValue();
    }
}

