package com.horizon.wf.third.hz.task.adapter;

import java.util.HashMap;
import java.util.Map;

import com.horizon.task.adapter.AbstractEntityTaskAdapter;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.wf.expand.impl.common.task.TodoTaskForNoActiveExe;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

/**
 * 激活节点时,发送消息.
 * @author liys
 * @version 1.0
 * @since v7.2
 *
 */
public class TodoTaskForNoActive extends AbstractEntityTaskAdapter {
	/**
	 *	执行代码.
	 */
	public boolean execute() {
		JobBean bean;
		try {
			bean = getJobBean();
		} catch (HorizonTaskException e) {
			e.printStackTrace();
			return false;
		}

		String identifier = String.valueOf(getValue("identifier"));
		if (StringUtilExtend.isNull(identifier)) {
			identifier = StaticVarExtend.DefaultIdentifier;
		}
		Map<String, String> para = new HashMap<String, String>();
		para.put("workid", String.valueOf(getValue("workid")));
		para.put("trackid", String.valueOf(getValue("trackid")));
		para.put("identifier", String.valueOf(getValue("identifier")));

		return TodoTaskForNoActiveExe.getInstance().execute(bean, para, identifier);
	}
}
