package com.horizon.wf.third.hz.task.adapter;

import java.util.HashMap;
import java.util.Map;

import com.horizon.task.adapter.AbstractEntityTaskAdapter;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.wf.expand.impl.common.task.TodoTaskExe;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

/**
 * 待办定时任务,流程实例执行过程中需要发送待办，待阅等时，调用该定时任务
 * @author liangjw
 * @version 1.0
 * @since v7.2
 *
 */
public class TodoTask extends AbstractEntityTaskAdapter{
	public boolean execute(){
		JobBean bean ;
		try {
			bean = getJobBean();
		} catch (HorizonTaskException e) {
			e.printStackTrace();
			return false;
		}

		String identifier = String.valueOf(getValue("identifier"));
		if(StringUtilExtend.isNull(identifier)){
			identifier = StaticVarExtend.DefaultIdentifier;
		}	
		Map<String,String> para = new HashMap<String,String>();
		para.put("tmpid", String.valueOf(getValue("tmpid")));
		para.put("identifier", String.valueOf(getValue("identifier")));
		
		return TodoTaskExe.getInstance().execute(bean, para, identifier);
	}
}




