package com.horizon.wf.third.hz.task.adapter;

import java.util.HashMap;
import java.util.Map;

import com.horizon.task.adapter.AbstractEntityTaskAdapter;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.wf.expand.impl.common.task.StartFlowTaskExe;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;


/**
 * 节点自动提交定时任务，开始节点为定时发起时调用
 * 
 * @version 1.0
 * @since v7.0
 */
public class StartFlowTask extends AbstractEntityTaskAdapter {
	protected boolean execute() {
		JobBean bean ;
		try {
			bean = getJobBean();
		} catch (HorizonTaskException e) {
			e.printStackTrace();
			return false;
		}
		
		String identifier = String.valueOf(getValue("identifier"));
		if(StringUtilExtend.isNull(identifier)){
			identifier = StaticVarExtend.DefaultIdentifier;
		}
		Map<String,String> para = new HashMap<String,String>();
		para.put("flowid", String.valueOf(getValue("flowid")));
		
		
		return StartFlowTaskExe.getInstance().execute(bean, para, identifier);
	}

}
