package com.horizon.wf.third.hz.task.adapter;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.task.adapter.AbstractEntityTaskAdapter;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.wf.expand.impl.common.task.NodeAutoSubmitTaskExe;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
/**
 * 节点自动提交定时任务
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class NodeAutoSubmitTask extends AbstractEntityTaskAdapter{
	private Logger logger = LoggerFactory.getLogger(NodeAutoSubmitTask.class);	
	protected boolean execute() {
		logger.debug("NodeAutoSubmitTask start.");
		
		JobBean bean ;
		try {
			bean = getJobBean();
		} catch (HorizonTaskException e) {
			e.printStackTrace();
			return false;
		}
		String identifier = String.valueOf(getValue("identifier"));
		if(StringUtilExtend.isNull(identifier)){
			identifier = StaticVarExtend.DefaultIdentifier;
		}
		Map<String,String> para = new HashMap<String,String>();
		para.put("workid", String.valueOf(getValue("workid")));
		para.put("trackid", String.valueOf(getValue("trackid")));
		para.put("nodeid", String.valueOf(getValue("nodeid")));
		para.put("tenantid", String.valueOf(getValue("tenantid")));
		para.put("identifier", String.valueOf(getValue("identifier")));
		return NodeAutoSubmitTaskExe.getInstance().execute(bean, para, identifier);
	}
	
	
}
