package com.horizon.wf.third.hz.task.adapter;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.task.adapter.AbstractEntityTaskAdapter;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.wf.expand.impl.common.task.NodeActivationTaskExe;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

/**
 * 节点激活方式定时任务
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class NodeActivationTask extends AbstractEntityTaskAdapter{
	private Logger logger = LoggerFactory.getLogger(NodeActivationTask.class);

	protected boolean execute() {
		logger.debug("execute NodeActivationTask start.");
		JobBean bean ;
		try {
			bean = getJobBean();
		} catch (HorizonTaskException e) {
			e.printStackTrace();
			return false;
		}
		String identifier = String.valueOf(getValue("identifier"));
		if(StringUtilExtend.isNull(identifier)){
			identifier = StaticVarExtend.DefaultIdentifier;
		}
		Map<String,String> para = new HashMap<String,String>();
		para.put("workid", String.valueOf(getValue("workid")));
		para.put("trackid", String.valueOf(getValue("trackid")));
		para.put("nodeid", String.valueOf(getValue("nodeid")));
		para.put("modeNum", String.valueOf(getValue("modeNum")));
		para.put("tenantid", String.valueOf(getValue("tenantid")));
		
		return NodeActivationTaskExe.getInstance().execute(bean, para, identifier);
	}

}




