package com.horizon.wf.third.hz.task.adapter;

import java.util.HashMap;
import java.util.Map;

import com.horizon.task.adapter.AbstractEntityTaskAdapter;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.wf.expand.impl.common.task.EventNodeTaskExe;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

/**
 * 事件节点定时任务
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class EventNodeTask extends AbstractEntityTaskAdapter{

	public boolean execute(){
		
		JobBean bean ;
		try {
			bean = getJobBean();
		} catch (HorizonTaskException e) {
			e.printStackTrace();
			return false;
		}
		String identifier = String.valueOf(getValue("identifier"));
		if(StringUtilExtend.isNull(identifier)){
			identifier = StaticVarExtend.DefaultIdentifier;
		}
		
		Map<String,String> para = new HashMap<String,String>();
		para.put("workid", String.valueOf(getValue("workid")));
		para.put("trackid", String.valueOf(getValue("trackid")));
		para.put("nodeid", String.valueOf(getValue("nodeid")));
		para.put("modeNum", String.valueOf(getValue("modeNum")));
		
		
		return EventNodeTaskExe.getInstance().execute(bean, para, identifier);
	}
}




