package com.horizon.wf.third.hz.task;

import com.horizon.task.api.HorizonTaskFactory;
import com.horizon.task.api.IHorizonTask;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.api.model.TriggerBean;
import com.horizon.task.cons.TaskConstant;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.DBRelationTimer;
import com.horizon.wf.entity.db.DBRobotTask;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.global.*;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.DateUtil;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;
/**
 * 定时任务添加接口实现
 * workflow-pub.xml
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class TaskImpl implements ITaskInterface{
	private IHorizonTask taskApi = HorizonTaskFactory.newInstance().getHorizonTask();
	/**
	 * 根据任务列表,把任务添加到执行队列中
	 * @param taskList
	 */
	public void addTask(List<Object> taskList){
		try{
			if(!taskList.isEmpty()){
				for(int i=0,n=taskList.size();i<n;i++){
					JobBean task = (JobBean)taskList.get(i);
					taskApi.scheduleJob(task);		//向队列中添加一条任务				
				}
			}
		}catch(HorizonTaskException e){
			e.printStackTrace();
		}
	}
	/**
	 * 只对自动节点和立即执行的任务
	 * NodeTypeEnum.Node_Event_Intermediate 中间事件
	 * NodeTypeEnum.Node_Event_Signal_Throw  信号抛出
	 * NodeTypeEnum.Node_Auto系列
	 * @param saveMap 需要保存的sql和对应的参数
	 * @param para:传入的参数
	 * String flowname = para.get("flowname");
	 * String nodename = para.get("nodename");
	 * String nodeid	= para.get("nodeid");
	 * String workid	= para.get("workid");
	 * int version		= Integer.parseInt(para.get("version"));
	 * String trackid 	= para.get("trackid");
	 * String tenantid = para.get("tenantid");
	 * String identifier=para.get("identifier");
	 * String jbClassName= para.get("jbClassName");
	 */
	public Object makeTaskBeanForAutoSubmit(Map<String, List<Object>> saveMap,Map<String,String> para){
//		String flowname = para.get("flowname");//rd.getWork().getFlowname();
//		String nodename = para.get("nodename");//node.getNodename();
		String nodeid	= para.get("nodeid");	//node.getNodeid();
		String workid	= para.get("workid");	//rd.getWork().getId();
		int version		= Integer.parseInt(para.get("version"));
//		String trackid 	= para.get("trackid");	//track.getId();
//		String tenantid = para.get("tenantid");	//rd.get
//		String identifier=para.get("identifier");//rd.get
//		String jbClassName=para.get("jbClassName");
		JobBean jobBean = new JobBean();
		jobBean.setJobName(StaticFunExtend.getUnid());
		jobBean.setJobGroup(StaticVarExtend.Task_Default_Group_Workflow);
		jobBean.setStoreDurably("1");//是否持久化
		
		TriggerBean triggerBean = new TriggerBean();
		triggerBean.setTriggerGroup(StaticVarExtend.Task_Default_Group_Workflow);
		triggerBean.setTriggerType(0);//0:  1:
		triggerBean.setRepeatInterval(60000);	// 默认60
		
		makeJobBeanPara(triggerBean, jobBean,para);
		
		jobBean.setJobTriggers(new TriggerBean[] {triggerBean});
		DBRelationTimer rt = new DBRelationTimer();
		rt.setId(StaticFunExtend.getUnid());
		rt.setNodeid(nodeid);
		rt.setTaskid(jobBean.getJobName());
		rt.setVersion(version);
		rt.setWorkid(workid);
		rt.getSQL(saveMap);
		return jobBean;
	}
	
	//设置jobBean参数
	private void makeJobBeanPara(TriggerBean triggerBean,JobBean jobBean,Map<String,String> para){
		String flowname = para.get("flowname");//rd.getWork().getFlowname();
		String nodename = para.get("nodename");//node.getNodename();
		String nodeid	= para.get("nodeid");
		String workid	= para.get("workid");
		String trackid 	= para.get("trackid");
		String tenantid = para.get("tenantid");
		String identifier=para.get("identifier");
		String jbClassName= para.get("jbClassName");
		
		//执行时间为当前时间30秒之后
		String startTime = DateUtil.formatDateTime(
				DateUtilExtend.addDateSecond(DateUtil.getNowDate(), 
						HZResourceBundle.getInstance().getAutoNodeDelayTime()));
		//StaticFunExtend.println("starttime:"+startTime);
		triggerBean.setStartTime(startTime);
		triggerBean.setTriggerType(0);//定时执行
		triggerBean.setRepeatCount(-1);//执行次数,如果执行失败应该无限重复执行
		triggerBean.setTriggerName(flowname+"("+nodename+")自动提交("+workid+")");
		jobBean.setJobClass(jbClassName);
		jobBean.setJobPara("workid=" + workid + StaticVarExtend.StrSplitChar 
				+ "trackid=" + trackid + StaticVarExtend.StrSplitChar
				+ "nodeid=" + nodeid + StaticVarExtend.StrSplitChar
				+ "tenantid=" +  tenantid + StaticVarExtend.StrSplitChar
				+ "identifier=" + identifier);
	}
	/**
	 * 生成任务所需要的参数对象
	 */
	public Object makeTaskBean(RunningData rd, IFlowNode node,
			Map<String, List<Object>> saveMap, DBTrack track) {
		StaticFunExtend.println("add task start.");
		ActionCommon ac = StaticFunExtend.getActionCommon();
		
		JobBean jobBean = new JobBean();
		jobBean.setJobName(StaticFunExtend.getUnid());
		jobBean.setJobGroup(StaticVarExtend.Task_Default_Group_Workflow);
		jobBean.setStoreDurably("1");//是否持久化
		
		TriggerBean triggerBean = new TriggerBean();
		triggerBean.setTriggerGroup(StaticVarExtend.Task_Default_Group_Workflow);
		triggerBean.setTriggerType(0);//0:  1:
		triggerBean.setRepeatInterval(60000);	// 默认60
		
		String flowname = rd.getWork().getFlowname();
		String nodename = node.getNodename();
			
		//定时执行和节点激活
		StaticFunExtend.println("nodeid:"+node.getNodeid()+";nodename:"+node.getNodename());
		String workid = rd.getWork().getId();
		Map<String, String> flowVarMap = rd.getFlowVar().getAllFlowVarMap();
		if(CollectionUtil.isMapEmpty(flowVarMap)){
			flowVarMap = new HashMap<String, String>();
		}

		//String startTime = node.getStartModeTimeDate();//开始时间变量名称
		String startTime=node.getEventTimeDate();//获取定时变量名
		if(StringUtilExtend.isNull(startTime)){
			StaticFunExtend.println("startTime var is null. add task error.");
			rd.putMsgToConsole("[msg]startTime var is null.");
			return null;
		}
		startTime = flowVarMap.get(startTime);
		if(StringUtilExtend.isNull(startTime)){
			StaticFunExtend.println("flowVarMap not have startTime var. add task error.");
			rd.putMsgToConsole("[msg]flowVarMap not have startTime var.");
			return null;
		}
		
		Date d = DateUtil.getDateTime(startTime);
		String interval = node.getEventTimeCycle();
		int intervalVal = 0;
		if(StringUtilExtend.isNull(interval)){
			intervalVal = 60000;//默认60秒
		}else{
			intervalVal = Integer.parseInt(interval);
		}
		//判断设定的日期是否大于当前日期
		if(intervalVal<60000){
			intervalVal = 60000;
			StaticFunExtend.println("interval<60000 change to:"+intervalVal);
		}
		if(DateUtil.isAfter(DateUtil.getNowDate(), d)){
			d=DateUtil.addDateMinute(DateUtil.getNowDate(),intervalVal/60000);
			rd.putMsgToConsole("[msg]datetime is less than nowdate.");
		}
		StaticFunExtend.println("starttime:"+DateUtilExtend.formatDateTime(d, "yyyy-MM-dd HH:mm:ss"));
		//设置好的时间加30秒
		boolean isErrorRetry = node.getEventTimeRetry();//失败后是否重试
		StaticFunExtend.println("starttime:"+startTime);
		//需要重试，则添加周期执行任务
		if(isErrorRetry){
			StaticFunExtend.println("this is interval task.");
			//定时间隔周期
			triggerBean.setStartTime(DateUtilExtend.formatDateTime(d, "yyyy-MM-dd HH:mm:ss"));

			//重试的次数
			int repeatCount = node.getEventNum();
			if(0 >= repeatCount){
				repeatCount = -1;
			}else{
				repeatCount=repeatCount-1;
			}
			StaticFunExtend.println("interval:"+intervalVal);

			triggerBean.setRepeatCount(repeatCount);
			triggerBean.setRepeatInterval(intervalVal);
			triggerBean.setTriggerType(0);//定时执行
		}else{
			//激活时间
			triggerBean.setStartTime(DateUtilExtend.formatDateTime(d, "yyyy-MM-dd HH:mm:ss"));
			triggerBean.setTriggerType(0);//定时执行
			triggerBean.setRepeatCount(1);
		}
		if(ac.isEventNode(node.getNodetype())){
			triggerBean.setTriggerName(flowname+"("+nodename+")自动提交("+workid+")");
			
		}else{
			triggerBean.setTriggerName(flowname+"("+nodename+")定时激活("+workid+")");
		}
		//在NodeActivationTask中重新区分是否自动提交还是定时激活
		jobBean.setJobClass("com.horizon.wf.third.hz.task.adapter.NodeActivationTask");//StaticVarExtend.Activation_Trigger_Class);
		jobBean.setJobPara("workid=" + rd.getWork().getId() + StaticVarExtend.StrSplitChar 
				+ "trackid=" + track.getId() + StaticVarExtend.StrSplitChar
				+ "nodeid=" + node.getNodeid() + StaticVarExtend.StrSplitChar
				+ "modeNum=" + node.getStartModeNum() + StaticVarExtend.StrSplitChar
				+ "tenantid=" +  rd.getInitData().getTenantid() + StaticVarExtend.StrSplitChar
				+ "identifier=" + rd.getInitData().getFlowIdentifier());
		
		jobBean.setJobTriggers(new TriggerBean[] {triggerBean});
		DBRelationTimer rt = new DBRelationTimer();
		rt.setId(StaticFunExtend.getUnid());
		rt.setNodeid(node.getNodeid());
		rt.setTaskid(jobBean.getJobName());
		rt.setVersion(rd.getWork().getVersion()+1);
		rt.setWorkid(rd.getWork().getId());
		rt.getSQL(saveMap);
		/*try {
			taskApi.scheduleJob(jobBean);
		} catch (HorizonTaskException e) {
			e.printStackTrace();
		}*/
		return jobBean;
	}
	
	
	
	/**
	 * 引擎交互节点接收数据后,自动提交失败时,添加一条定时任务
	 * @param work
	 * @param track
	 * @param tenantid
	 * @param identifier
	 * @return
	 */
	public boolean addTaskForMutualReceive(DBWork work,DBTrack track,String tenantid,String identifier){
		Map<String,List<Object>> saveMap = new LinkedHashMap<String,List<Object>>();
		String nodeid = track.getNodeid();
		String workid = work.getId();
		String trackid = track.getId();
		
		DBRobotTask rTask = new DBRobotTask();
		rTask.setId(StaticFunExtend.getUnid());
		rTask.setStatus("0");
		rTask.setClassname("");
		rTask.setNodeid(nodeid);
		rTask.setWorkid(workid);
		rTask.setTrackid(trackid);
		saveMap.putAll(rTask.getSQL());
		
		
		JobBean jobBean = new JobBean();
		jobBean.setJobName(StaticFunExtend.getUnid());
		jobBean.setJobGroup(StaticVarExtend.Task_Default_Group_Workflow);
		jobBean.setStoreDurably("1");//是否持久化
		
		TriggerBean triggerBean = new TriggerBean();
		triggerBean.setTriggerGroup(StaticVarExtend.Task_Default_Group_Workflow);
		triggerBean.setTriggerType(0);//0:  1:
		triggerBean.setRepeatInterval(30000);
		
		//task.setIdentifier(rd.getInitData().getFlowIdentifier());
		String flowname = work.getFlowname();
		String nodename = track.getNodename();
		
		//执行时间为当前时间30秒之后
		String startTime = DateUtil.formatDateTime(
				DateUtilExtend.addDateSecond(DateUtil.getNowDate(), 
						HZResourceBundle.getInstance().getAutoNodeDelayTime()));
		StaticFunExtend.println("starttime:"+startTime);
		triggerBean.setStartTime(startTime);
		triggerBean.setTriggerType(0);//定时执行
		triggerBean.setRepeatCount(0);//执行次数
		triggerBean.setTriggerName(flowname+"("+nodename+")引擎交互接收后自动提交("+work.getId()+")");
		jobBean.setJobClass("com.horizon.wf.third.hz.task.adapter.NodeAutoSubmitTask");//StaticVarExtend.Node_Auto_Submit_Class);
		jobBean.setJobPara("workid=" + work.getId() + StaticVarExtend.StrSplitChar 
							+ "trackid=" + track.getId() + StaticVarExtend.StrSplitChar
							+ "nodeid=" + track.getNodeid() + StaticVarExtend.StrSplitChar
							+ "tenantid=" +  tenantid + StaticVarExtend.StrSplitChar
							+ "identifier=" + identifier);
		
		jobBean.setJobTriggers(new TriggerBean[] {triggerBean});
		DBRelationTimer rt = new DBRelationTimer();
		rt.setId(StaticFunExtend.getUnid());
		rt.setNodeid(track.getNodeid());
		rt.setTaskid(jobBean.getJobName());
		rt.setVersion(work.getVersion()+1);
		rt.setWorkid(work.getId());
		rt.getSQL(saveMap);
		
		boolean result = AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier);
		if(!result){
			return false;
		}
		try {
			taskApi.scheduleJob(jobBean);
		} catch (HorizonTaskException e) {
			e.printStackTrace();
		}	
		
		return true;
	}
	
	public void addTaskForTodo(String workid,List<String> tmpIdList,String identifier){
		JobBean jobBean = new JobBean();
		jobBean.setJobName(StaticFunExtend.getUnid());
		jobBean.setJobGroup(StaticVarExtend.Task_Default_Group_Todo);
		jobBean.setJobClass("com.horizon.wf.third.hz.task.adapter.TodoTask");//StaticVarExtend.Todo_Class);
		StringBuilder sb = new StringBuilder(1000);
		sb.append("identifier=").append(identifier);
		sb.append(StaticVarExtend.StrSplitChar);
		sb.append("tmpid=");
		for(int i=0,n=tmpIdList.size();i<n;i++){
			String tmpid = tmpIdList.get(i);
			 if (CStrUtil.hasValue(tmpid)) {
				 sb.append(tmpid).append(",");
			 }
		}
		jobBean.setJobPara(sb.toString());

		TriggerBean triggerBean = new TriggerBean();
		triggerBean.setTriggerGroup(StaticVarExtend.Task_Default_Group_Todo);
		triggerBean.setStartTime(DateUtilExtend.getNow());
		triggerBean.setTriggerType(0);//定时执行
		triggerBean.setRepeatCount(0);
		triggerBean.setTriggerName("todo send.("+workid+")");
		triggerBean.setRepeatInterval(1);

		jobBean.setJobTriggers(new TriggerBean[] {triggerBean});
		try {
			taskApi.scheduleJob(jobBean);
		} catch (HorizonTaskException e) {
			StaticFunExtend.println("[err]execute todo task error.workid:"+workid);
			e.printStackTrace();
		}
	}
	
	public void addTaskForTodoNoActiveMsg(String workid,String trackid,String identifier){
		if(workid == null || workid.length()==0){
			return;
		}
		JobBean jobBean = new JobBean();
		jobBean.setJobName(StaticFunExtend.getUnid());
		jobBean.setJobGroup(StaticVarExtend.Task_Default_Group_Todo);
		//jobBean.setStoreDurably("1");//是否持久化   1:持久化
//		jobBean.setJobClass(StaticVarExtend.Todo_Class);
		jobBean.setJobClass("com.horizon.wf.third.hz.task.adapter.TodoTaskForNoActive");
		StringBuilder sb = new StringBuilder(1000);
		sb.append("workid=").append(workid);
		sb.append(StaticVarExtend.StrSplitChar);
		sb.append("trackid=").append(trackid);
		sb.append(StaticVarExtend.StrSplitChar);
		sb.append("identifier=").append(identifier);
		
		jobBean.setJobPara(sb.toString());

		TriggerBean triggerBean = new TriggerBean();
		triggerBean.setTriggerGroup(StaticVarExtend.Task_Default_Group_Todo);
		triggerBean.setStartTime(DateUtilExtend.getNow());
		triggerBean.setTriggerType(0);//定时执行
		triggerBean.setRepeatCount(0);
		triggerBean.setTriggerName("todo send.("+workid+")");
		triggerBean.setRepeatInterval(1);

		jobBean.setJobTriggers(new TriggerBean[] {triggerBean});

		try {
			taskApi.scheduleJob(jobBean);
		} catch (HorizonTaskException e) {
			StaticFunExtend.println("[err]execute todo task error.workid:"+workid);
			e.printStackTrace();
		}
	}
	
	
	public void pause(String[] workids, Map<String, List<Object>> saveMap, String identifier) {
		StaticFunExtend.println("pause task start.");
		for(String workid : workids){
			StaticFunExtend.println("workid:"+workid);
			DBRelationTimer dt = getRelationTimer(workid, identifier);
			if(null != dt){
				pause(dt.getTaskid(), saveMap);
			}			
		}
		StaticFunExtend.println("pause task end.");

	}
	/**
	 * 
	 * @param workid 实例id
	 * @param nodeid 节点id
	 * @param saveMap 存放sql语句的map
	 * @param identifier 数据库标识符
	 */
	public void pause(String workid, String nodeid, Map<String, List<Object>> saveMap, String identifier) {
		StaticFunExtend.println("pause task start.");
		DBRelationTimer dt = getRelationTimer(workid, nodeid, identifier);
		if(null != dt){
			pause(dt.getTaskid(), saveMap);
		}
		StaticFunExtend.println("pause task end.");
	}
	private void pause(String taskId, Map<String, List<Object>> saveMap) {
		try {
			taskApi.pauseJob(taskId,StaticVarExtend.Task_Default_Group_Workflow);
		} catch (HorizonTaskException e) {
			StaticFunExtend.println("[err]pause task error:"+e.getMessage());
			e.printStackTrace();
		}
	}

//	/**
//	 * 
//	 * @param taskId 任务id
//	 * @param saveMap 存放sql语句的map
//	 */
//	public void pause(TaskParaBean bean, LinkedHashMap<String, List<Object>> saveMap) {
//		try {
//			taskApi.pause(bean);
//		} catch (HorizonTaskException e) {
//			StaticFunExtend.println("[err]pause task error:"+e.getMessage());
//			e.printStackTrace();
//		}
//	}

	/**
	 * 恢复指定实例某个版本的定时任务
	 * @param workid 实例id
	 * @param nodeid 节点id
	 * @param saveMap 存放sql语句的map
	 * @param identifier 数据库标识符
	 */
	public void restore(String workid, String nodeid, Map<String, List<Object>> saveMap, String identifier){
		StaticFunExtend.println("restore task start.");
		DBRelationTimer dt = getRelationTimer(workid, nodeid, identifier);
		if(null != dt){
			try {
				taskApi.resumeJob(dt.getTaskid(), StaticVarExtend.Task_Default_Group_Workflow);
			} catch (HorizonTaskException e) {
				StaticFunExtend.println("[err]restore task error:"+e.getMessage());
				e.printStackTrace();
			}
		}
		StaticFunExtend.println("restore task end.");
	}
	
	public void restore(String workid, int version, Map<String, List<Object>> saveMap, String identifier){
		StaticFunExtend.println("restore task start.");
		DBRelationTimer dt = getRelationTimer(workid, version, identifier);
		if(null != dt){
			try {
				taskApi.resumeJob(dt.getTaskid(), StaticVarExtend.Task_Default_Group_Workflow);
			} catch (HorizonTaskException e) {
				StaticFunExtend.println("[err]restore task error:"+e.getMessage());
				e.printStackTrace();
			}
		}
		StaticFunExtend.println("restore task end.");
	}
	

	public void restore(String[] workids, Map<String, List<Object>> saveMap, String identifier){
		for(String workid : workids){
			DBRelationTimer dt = getRelationTimer(workid, identifier);
			if(null != dt){
//				JobBean t = new JobBean(dt.getTaskid(), StaticVarExtend.Task_Default_Group_Workflow);
				try {
					taskApi.resumeJob(dt.getTaskid(), StaticVarExtend.Task_Default_Group_Workflow);
				} catch (HorizonTaskException e) {
					StaticFunExtend.println("[err]restore task error:"+e.getMessage());
					e.printStackTrace();
				}
			}
		}
	}
	
	/**
	 * 获取关联数据
	 * @param workid 实例id
	 * @param nodeid 节点id
	 * @param identifier 数据库标识符
	 * @return
	 */
	private DBRelationTimer getRelationTimer(String workid,String nodeid, String identifier){
		StaticFunExtend.println("getRelationTimer start");
		String sql = "select * from " + StaticVarExtend.Table_Relation_Timer + " where workid=? and nodeid=?";
		List<Object> conditions = new ArrayList<Object>();
		conditions.add(workid);
		conditions.add(nodeid);
		DBRelationTimer dt =  AccessUtil.getInstance()
				.getSingleObject(sql, conditions, DBRelationTimer.class, identifier);
		StaticFunExtend.println("getRelationTimer end.DBRelationTimer:"+dt);
		return dt;
	}

	/**
	 * 获取关联数据
	 * @param workid 实例id
	 * @param version 版本
	 * @param identifier 数据库标识符
	 * @return
	 */
	private DBRelationTimer getRelationTimer(String workid, int version, String identifier){
		StaticFunExtend.println("getRelationTimer start");
		String sql = "select * from " + StaticVarExtend.Table_Relation_Timer + " where workid=? and version=?";
		List<Object> conditions = new ArrayList<Object>();
		conditions.add(workid);
		conditions.add(version);
		DBRelationTimer dt =  AccessUtil.getInstance()
				.getSingleObject(sql, conditions, DBRelationTimer.class, identifier);
		StaticFunExtend.println("getRelationTimer end.DBRelationTimer:"+dt);
		return dt;
	}
	/**
	 * 获取关联数据
	 * @param workid 实例id
	 * @param identifier 数据库标识符
	 * @return
	 */
	private DBRelationTimer getRelationTimer(String workid, String identifier){
		StaticFunExtend.println("getRelationTimer start");
		String sql = "select a.* from " + StaticVarExtend.Table_Relation_Timer + " a,tk_horizon_info b where a.taskid=b.id and b.isrunning='0' and workid=?";
		List<Object> conditions = new ArrayList<Object>();
		conditions.add(workid);
		DBRelationTimer dt =  AccessUtil.getInstance()
				.getSingleObject(sql, conditions, DBRelationTimer.class, identifier);
		StaticFunExtend.println("getRelationTimer end.DBRelationTimer:"+dt);
		return dt;
	}

	/**
	 * 从队列中移除定时任务
	 */
	public void remove(Object bean){
		StaticFunExtend.println("remove task.");
		try {
			JobBean jobBean = (JobBean)bean;
			taskApi.deleteJob(jobBean.getJobName(),jobBean.getJobGroup());
		} catch (HorizonTaskException e) {
			StaticFunExtend.println("[err]restore task error:"+e.getMessage());
			e.printStackTrace();
		}

	}

	
	//====================以下定制工具使用==========================================
	@Override
	public boolean deleteFlowStartTask(String flowid) {
//		JobBean jobBean = new JobBean();
//		jobBean.setJobName(flowid + "流程定时启动Job");
//		jobBean.setJobGroup("StartFlowJobGroup");

		IHorizonTask jobApi = HorizonTaskFactory.newInstance().getHorizonTask();		
		try {
			return jobApi.deleteJob(flowid + "流程定时启动Job","StartFlowJobGroup");
		} catch (HorizonTaskException e) {
			e.printStackTrace();
			return false;
		}
		
	}

	@Override
	public boolean addFlowStartTask(Map<String,Object> map) {
		String flowid = (String) map.get("flowid");
		String startTime = (String) map.get("startTime");
		String repeatInterval = (String) map.get("repeatInterval");
//		String startflowclass = (String) map.get("startFlowclass");
		String tenantid = (String)map.get("tenantid");
		String identifier = (String) map.get("identifier");
		
		TriggerBean triggerBean = new TriggerBean();
		triggerBean.setTriggerName(flowid + "流程定时启动Trigger");
		triggerBean.setTriggerGroup("StartFlowTriggerGroup");
		triggerBean.setTriggerType(TaskConstant.TRIGGER_TYPE_SIMPLE);
		triggerBean.setStartTime(startTime);
		
		if(repeatInterval ==null || "".equals(repeatInterval) || Integer.parseInt(repeatInterval)<5000){//以指定的重复间隔时间、无限次重复执行
			 triggerBean.setRepeatCount(0);//不重复
        }else{
        	triggerBean.setRepeatInterval(Integer.parseInt(repeatInterval));//执行周期，默认毫秒，如果其他单位需要set值
        }
		
//		triggerBean.setRepeatInterval(new Integer(repeatInterval));// 执行周期，默认毫秒
//		triggerBean.setRepeatCount(-1);

		JobBean jobBeanNew = new JobBean();
		jobBeanNew.setJobName(flowid + "流程定时启动Job");
		jobBeanNew.setJobGroup("StartFlowJobGroup");
		jobBeanNew.setJobClass("com.horizon.wf.third.hz.task.adapter.StartFlowTask");//需要Map传进来参数
		jobBeanNew.setJobPara("flowid=" + flowid + ";tenantid="+tenantid+";identifier="+identifier);// 参数
		jobBeanNew.setJobTriggers(new TriggerBean[] { triggerBean });

		IHorizonTask jobApi = HorizonTaskFactory.newInstance().getHorizonTask();
		// 加入定时任务队列
		try {
			return jobApi.scheduleJob(jobBeanNew);
		} catch (HorizonTaskException e) {
			e.printStackTrace();
			return false;
		}
		
	}

}
