package com.horizon.wf.third.hz.tablesuffix;

import com.horizon.wf.core.responsible.IStorageEndInstanceTableSuffix;
import com.horizon.wf.tools.AccessUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * 流程结束进行归档/打开已经归档的实例时,获取归档库表的后缀
 * @author LIYS
 * 2018-08-20
 */
public class StorageEndInstanceTableSuffix implements IStorageEndInstanceTableSuffix {
    //缓存已经获取过的workid对应的归档数据库后缀
    private static ConcurrentMap<String,String> map = new ConcurrentHashMap<String, String>();
    private static String GET_SQL = "SELECT SUFFIX FROM TW_HZ_ENDFLAG WHERE ID=?";
    private static String INSERT_SQL = "INSERT INTO TW_HZ_ENDFLAG (ID,SUFFIX) VALUES(?,?)";
    private static int Num = 0;
    /**
     * 获取归档库表的后缀
     * 默认返回"_END"
     * @return
     */
    public String getTableSuffix(String workid) {
        //1.先从缓存中获取是否已经存在
        String suffix = map.get(workid);
        if (suffix == null) {
            //2.从持久化的结果中获取结果
            List<Object> para = new ArrayList<Object>();
            para.add(workid);
            long start = System.currentTimeMillis();
            List<Object> result = AccessUtil.getInstance().getSingleList(GET_SQL, para, "system");
            println("获取结束标记["+workid+"耗时:"+(System.currentTimeMillis()-start));
            if(result == null || result.size()==0) {
                //如果没有记录存在,则按规则计算后缀
                suffix = getTableSuffix();
            }
            else{
                suffix = String.valueOf(result.get(0));
            }
            //如果缓存超过10万条,则清空避免占用太多内存
            if(Num > 100000){
                println("缓存超过10万,则清空避免占用太多内存.");
                Num =0;
                map.clear();
            }
            //3.缓存结果
            map.put(workid, suffix);
            Num ++;
        }

        return suffix;
    }

    /**
     * 按照规则获取归档数据库表的后缀,用于实例流转结束时
     * @return
     */
    public String getTableSuffix(){
//        TODO 根据规则计算后缀
        //一般应该按照数据的数据量来确定
        // 按照年份划分,或者按照月份
        //默认固定后缀
        return "_END";
    }


    /**
     * 流转结束时,保存结束库表后缀
     * 用于流程结束时,同步移动数据,如果数据异步处理,则不需要执行下面的
     * @param workid
     */
    public void saveTableSuffix(String workid){
        //存到数据库中/其他文件中???
        String suffix = getTableSuffix();
        List<Object> para = new ArrayList<Object>(2);
        para.add(workid);
        para.add(suffix);
        map.put(workid,suffix);
        long start = System.currentTimeMillis();
        AccessUtil.getInstance().executeUpdate(INSERT_SQL,para,"system");
        println("插入结束标记["+workid+"]耗时:"+(System.currentTimeMillis()-start));
    }

    private void println(String str){
        System.out.println(str);
    }
}
