package com.horizon.wf.third.hz.sendtitle;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.LangInfo;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.expand.impl.IMessageMould;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.Map;
import java.util.ResourceBundle;
public class MessageMouldImpl implements IMessageMould {	
	/**
	 * 获取发送消息的的标题
	 * @param trackid 发送消息的trackid
	 * @param node 发送到哪个节点
	 * @param rd 运行期对象
	 * @param msgType 消息类型
	 * @param authType 获取那种权限的标题
	 * @return 处理好后的标题
	 */
	public String getTodoTitle(String trackid, IFlowNode node, RunningData rd, String msgType, String authType){
		String title = rd.getTitle();//获取默认标题信息
		String flowname = rd.getWork().getFlowname();
		Object obj = rd.getWorkParaBean();
		if(null != obj){
			WorkParaBean wpb = (WorkParaBean)obj;
			if(null != wpb){
				Map<String, String> messageMoulds = wpb.getMessageMoulds();
				if(StringUtilExtend.isNull(title)){
					title = wpb.getTitle();
				}
				//如果前台有传入,则使用前台传入
				if(CollectionUtil.isMapNotEmpty(messageMoulds)){
					String message = messageMoulds.get(node.getNodeid()+StaticVarExtend.MARK_NODE_USER+authType);
					if(StringUtilExtend.isNotNull(message)){
						return message;
					}
				}
			}			
		}		
		LangInfo langInfo = rd.getLangInfo();
		ResourceBundle bundle = langInfo.getLangResourceBundle("Title");
		if(bundle == null){
			return rd.getTitle();
		}
		
		msgType = msgType.replaceAll(";", "");
		if(StaticVarExtend.Send_Todo.equals(msgType)){
			String mm = langInfo.getString(bundle,StaticVarExtend.Send_Todo);
			if(null != mm){
				return replaceTitle(mm,title,flowname);
			}
		}else if (StaticVarExtend.Send_Done.equals(msgType)){
			String mm = langInfo.getString(bundle,StaticVarExtend.Send_Done);
			if(null != mm){
				return replaceTitle(mm,title,flowname);
			}
		}else if(StaticVarExtend.Send_Read.equals(msgType) || StaticVarExtend.Send_ReadMsg.equals(msgType)){
			String mm = langInfo.getString(bundle,StaticVarExtend.Send_Read);
			if(null != mm){
				return replaceTitle(mm,title,flowname);
			}
		}else if(StaticVarExtend.Send_Msg.equals(msgType)){
			String mm = langInfo.getString(bundle,StaticVarExtend.Send_Msg);
			if(null != mm){
				return replaceTitle(mm,title,flowname);
			}
		}else if(StaticVarExtend.Send_Note.equals(msgType)){
			String mm = langInfo.getString(bundle,StaticVarExtend.Send_Note);
			if(null != mm){
				return replaceTitle(mm,title,flowname);
			}
		}else if(StaticVarExtend.Send_RTF.equals(msgType)){
			String mm = langInfo.getString(bundle,StaticVarExtend.Send_RTF);
			if(null != mm){
				return replaceTitle(mm,title,flowname);
			}
		}else if(StaticVarExtend.Send_Mail.equals(msgType)){
			String mm = langInfo.getString(bundle,StaticVarExtend.Send_Mail);
			if(null != mm){
				return replaceTitle(mm,title,flowname);
			}
		}else{
			String mm = langInfo.getString(bundle,"Other");
			if(null != mm){
				return replaceTitle(mm,title,flowname);
			}
		}
		return rd.getTitle();
	}
	
	private String replaceTitle(String content,String title,String flowname){
		if(StringUtilExtend.isNotNull(title)){
			return content.replace("|title|", title);			
		}
		return content.replace("|title|", flowname);			
	}


	/**
	 * 根据msgType获取消息格式,并把title按照格式进行格式化返回
	 * @param title
	 * @param rd
	 * @param msgType
	 * @return
	 */
	public String getTodoTitle(String title,RunningData rd,String msgType){
		LangInfo langInfo = rd.getLangInfo();
		ResourceBundle bundle = langInfo.getLangResourceBundle("Title");
		if(bundle !=null) {
			String mm = langInfo.getString(bundle, msgType);
			if (null != mm) {
				return replaceTitle(mm, title, title);
			}
		}
		return title;
	}
}
