package com.horizon.wf.third.hz.rule.rulefun;

import java.util.HashMap;
import java.util.Map;

import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
/**
 * 根据基准获取办理人
 */
public class GetRelationUser extends BaseRuleImpl implements IBaseRule {

	public boolean executeRule() {
		RunningData rd = getRunningdata();
		String[] parameter = (String[]) getParameter("para");
		String basenode = parameter[1];
		String rolebase = parameter[2];
		String relation = parameter[3];

		StringBuilder sb = new StringBuilder(1000);
		String tenantid = rd.getInitData().getTenantid();
		int size = 1, i = 0;
		int[] base = new int[size];
		int[] fieldReplace = new int[size];
		String[] relations = new String[size];
		String[] nodeAuthor = new String[size];// 节点办理人
		String[] tarRange = new String[size];

		fieldReplace[i] = 2;// Integer.parseInt(relation.getGatherType());//交并集
							// 1:交集
		relations[i] = relation;
		base[i] = Integer.parseInt(rolebase);// 关系基准

		String baseNode = basenode;// 基准节点

		String temp = ActionCommon.getInstance().getSingleRelation(rd, sb,
				baseNode, base[i], relation, StaticVarExtend.AUTH_DONE);
		if ("".equals(temp)) {
			setResult("");
		} else {
			nodeAuthor[i] = temp;
			IOrganizationInterface oi = PluginsUtil.getMultiInstance()
					.getOrganization(tenantid);
			Map<String, Object> para = new HashMap<String, Object>();
			para.put("creator", rd.getCreatorFullName());//
			para.put("done", nodeAuthor);
			para.put("relation", relations);
			para.put("gathertype", fieldReplace);
			para.put("base", base);
			para.put("tarRange", tarRange);
			para.put("userid", rd.getCurUser().getFullName());
			temp = oi.getRelationUser(para, rd.getInitData()
					.getFlowIdentifier());

			setResult(temp);
		}
		return true;
	}

}
