package com.horizon.wf.third.hz.rule.rulefun;

import java.util.ArrayList;
import java.util.List;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.plugins.PluginsUtil;
/**
 *  获取组织机构交并集
 */
public class GetOrgUN extends BaseRuleImpl implements IBaseRule {

	public boolean executeRule() {
		RunningData rd = getRunningdata();
		String[] para = (String[]) getParameter("para");
		String str1 = para[1];
		String str2 = para[2];
		String str3 = para[3];

		String tenantid = rd.getInitData().getTenantid();
		String identifier = rd.getInitData().getFlowIdentifier();
		
		List<String> list1 = getUserList(str1,tenantid,identifier);
		List<String> list2 = getUserList(str3,tenantid,identifier);

		if (str2.equalsIgnoreCase("u")) {
			// 并集
			list2.removeAll(list1);
			list1.addAll(list2);
		} else {
			// 交集
			list1.retainAll(list2);
		}

		String rs = "";

		for (String s : list1) {
			if(s== null ||s.length()==0 || s.equals("null")){
				continue;
			}
			if (rs.length() == 0) {
				rs = s;
			} else {
				rs += StaticVar.UserSplitChar + s;
			}
		}

		setResult(rs);
		return true;
	}

	private List<String> getUserList(String str1,String tenantid,String identifier) {
		List<String> userList = new ArrayList<String>();

		String[] str = str1.split(StaticVar.UserSplitChar);
		IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(tenantid);
		for(String t :str){
			if (t.startsWith("/D_") || t.startsWith("D_")) {				
				String[] tmp = org.getAllUserFromDept(t.substring(t.indexOf("_")+1), true, identifier).split(StaticVar.UserSplitChar);				
				for (int i = 0; i < tmp.length; i++) {
					userList.add(tmp[i].startsWith(StaticVar.UserFix + StaticVar.Mark_Fix)?tmp[i]: StaticVar.UserFix + StaticVar.Mark_Fix + tmp[i]);
				}
			} else if (t.startsWith("/G_") || t.startsWith("G_")) {
				String[] tmp = org.getAllUserFromGroup(t.substring(t.indexOf("_")+1), identifier).split(StaticVar.UserSplitChar);
				for (int i = 0; i < tmp.length; i++) {
					userList.add(tmp[i].startsWith(StaticVar.UserFix + StaticVar.Mark_Fix)?tmp[i]: StaticVar.UserFix + StaticVar.Mark_Fix + tmp[i]);
				}
			} else if (t.startsWith("/P_") || t.startsWith("P_")) {
				String[] tmp = org.getAllUserFromPosition(t.substring(t.indexOf("_")+1), identifier).split(StaticVar.UserSplitChar);
				for (int i = 0; i < tmp.length; i++) {
					userList.add(tmp[i].startsWith(StaticVar.UserFix + StaticVar.Mark_Fix)?tmp[i]: StaticVar.UserFix + StaticVar.Mark_Fix + tmp[i]);
				}				
			} 
			else {
				userList.add(t.startsWith(StaticVar.UserFix + StaticVar.Mark_Fix)?t: StaticVar.UserFix + StaticVar.Mark_Fix + t);			
			}
			userList.add(t);
		}
		return userList;
	}
}
