package com.horizon.wf.third.hz.rule.rulefun;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.global.StaticVarExtend;
/**
 * 获取流程节点状态
 */
public class GetNodeStatus extends BaseRuleImpl implements IBaseRule {

	public boolean executeRule() {
		RunningData rd = getRunningdata();
		String[] para = (String[]) getParameter("para");
		String nodeid = para[1];
		if (rd.getCurTaskNode().getNodeid().equals(nodeid)) {
			setResult("current");
			return true;
		}
		String nownodes = rd.getNodeStauts().get("NowNodes");
		if (checkStrInStr(nownodes, nodeid)) {
			setResult("active");
			return true;
		}
		String donenodes = rd.getNodeStauts().get("DoneNodes");
		if (checkStrInStr(donenodes, nodeid)) {
			setResult("done");
			return true;
		}
		String jumpnodes = rd.getNodeStauts().get("JumpNodes");
		if (checkStrInStr(jumpnodes, nodeid)) {
			setResult("jumped");
			return true;
		}

		setResult("blank");
		return true;
	}

	private boolean checkStrInStr(String str1, String str2) {
		String[] arr = str1.split(StaticVarExtend.StrSplitChar);
		for (String tmp : arr) {
			if (str2.equals(tmp)) {
				return true;
			}
		}
		return false;
	}
}
