package com.horizon.wf.third.hz.rule.drools;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.horizon.utils.StringUtil;
import com.horizon.wf.global.StaticVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;

/**
 * 这个类可以自由实现方法。
 * @author Administrator
 *
 */
public class RuleFun {
	
	private static final Logger logger = LoggerFactory.getLogger(RuleFun.class);
	private RunningData rd;
	private ITaskNode tNode;
	
	public String excuteString(String ...para){
		String className = para[0];
		IBaseRule ruleObj = InterfaceFactory.getNewInterface(className);
		if(ruleObj == null){
			return "";
		}
		ruleObj.setRunningData(rd);
		ruleObj.setParameter("taskNode", tNode);
		ruleObj.setParameter("para", para);
		boolean result = ruleObj.executeRule();
		if(result){
			return ruleObj.getResult().toString();
		}
		return "";
	}
	public boolean excuteBoolean(String ...para){
		String className = para[0];
		IBaseRule ruleObj = InterfaceFactory.getNewInterface(className);
		if(ruleObj == null){
			return false;
		}
		ruleObj.setRunningData(rd);
		ruleObj.setParameter("taskNode", tNode);
		ruleObj.setParameter("para", para);
		boolean result = ruleObj.executeRule();
		if(result){
			return true;
		}
		return false;
	}
	
	/**
	 * 设置规则消息
	 * @return
	 */	
	public void setReturnMsg(String msg){
		if(msg!=null&&msg.length()>0){
			try {
				logger.debug("msg:"+msg+" decode:"+java.net.URLDecoder.decode(msg,"UTF-8"));
				rd.setBackMsg(java.net.URLDecoder.decode(msg,"UTF-8"));
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
			}
		}
	}
	/**
	 * 判断str1字符串是否包含str2字符串
	 */
	public boolean strContains(String str1,String str2){

		if(str1==null||str2==null) return false;
		//20231031 新增判断后面参数为多个，拆分开对比
		if(str2.contains("G_") || str2.contains("D_") || str2.contains("P_") || str2.contains("U_")){
			String[] strArr=str2.split(";");
			for (String strThis : strArr) {
				String string=strThis.split("/")[0].replace("U_","").replace("D_","").replace("P_","").replace("G_","");
				if(str1.indexOf(string)>-1){
					return true;
				}
			}
		}
		return str1.indexOf(str2)>-1;
	}
	
	/**
	 * 判断str1字符串 ysf str2字符串
	 */
	public boolean numCompare(String str1, String str2, String ysf){
		Boolean result = false;
		ysf = ysf.trim();
		try{
			BigDecimal bg1 = new BigDecimal(str1);
			BigDecimal bg2 = new BigDecimal(str2);
			//比较大小，返回值：   -1 小于， 0 等于， 1 大于 
			int n = bg1.compareTo(bg2);
			if(n==0){
				if ("==".equals(ysf) || ("<=".equals(ysf)) || (">=".equals(ysf))){
					result = true;
				}
			}else if(n==-1){
				if("<".equals(ysf)||"<=".equals(ysf)||"!=".equals(ysf)){
					result = true;
				}
			}else if(n==1){
				if(">".equals(ysf)||">=".equals(ysf)||"!=".equals(ysf)){
					result = true;
				}
			}
		}catch(NumberFormatException e){
			logger.debug("数字格式化异常：【"+str1+", "+str2+", '"+ysf+"'】");
		}
		
		return result;
	}
	public RunningData getRd() {
		return rd;
	}

	public void setRd(RunningData rd) {
		this.rd = rd;
	}
	
	public ITaskNode gettNode() {
		return tNode;
	}

	public void settNode(ITaskNode tNode) {
		this.tNode = tNode;
	}
//--------以下为扩展规则实现内容,后期会废掉--------------------------------------------------------------
	//private Map<String,Object> formMap;

	public String getOrgSelected(String str){
		return str;
	}
	
	/**
	 * 获取流程表单字段值
	 * @param name
	 * @return
	 */
	public String getFieldValue(String name){
		Object obj = rd.getInitData().getHashMap().get(name);
		return obj==null?"":obj.toString();
	}

    /**
     * 获取流程节点状态
     * @param nodeid
     * @return
     */
    public String getNodeStatus(String nodeid){
        //System.out.println("规则对象调试信息==========NowNodes===="+rd.getNodeStauts().get("NowNodes"));
        //System.out.println("规则对象调试信息==========DoneNodes===="+rd.getNodeStauts().get("DoneNodes"));
        //System.out.println("规则对象调试信息==========JumpNodes===="+rd.getNodeStauts().get("JumpNodes"));
        if(rd.getCurTaskNode().getNodeid().equals(nodeid)) {
            return "current";
        }
//        nodeid = nodeid+";";
        String nownodes = rd.getNodeStauts().get("NowNodes");
        
        if(checkStrInStr(nownodes,nodeid)) {
            return "active";
        }
        String donenodes = rd.getNodeStauts().get("DoneNodes");
        if(checkStrInStr(donenodes,nodeid)) {
            return "done";
        }
        String jumpnodes = rd.getNodeStauts().get("JumpNodes");
        if(checkStrInStr(jumpnodes,nodeid)) {
            return "jumped";
        }
        return "blank";  
    }
    
    private boolean checkStrInStr(String str1,String str2){
        String[] arr = str1.split(StaticVarExtend.StrSplitChar);
        for(String tmp:arr){
            if(str2.equals(tmp)){
                return true;
            }
        }
        return false;
    }
    
    /**
     * 判断所有分支都已到达当前合并网关
     * @param 
     * @return String
     */
    public String allTrackReached(){
    	boolean allreached = rd.isLastTrackToGateWayMerge(tNode);
    	return allreached?"true":"false";
    	
    	/*
        //System.out.println("规则对象调试信息==========1");
        List<IXmlTrack> tracks = rd.getAllTrackNeedToGateway(tNode);
        //System.out.println("规则对象调试信息==========2");
//        DBTrack curTrack = rd.getCurTrack();
        //System.out.println("规则对象调试信息==========curTrack.getId()"+curTrack.getId());
        //System.out.println("规则对象调试信息==========size=="+tracks.size());
        if(tracks.isEmpty()) {
            return "true";
        }
        int last=0;
        for(int i=0,n=tracks.size();i<n;i++){
        	IXmlTrack t = tracks.get(i);
            //System.out.println("规则对象调试信息==========4"+t.getId()+"======"+t.getActive());
            if(t.getActive()==true){
                last=last+1;
            }
        }
        if(last==1) {
            return "true";
        }else {
            return "false";
        }
        //*/
    }
    
    /**
     * 判断指定节点所属的分支是否已到达合并网关
     * @param 
     * @return String
     */
    public String TrackReached(String NodeId){
    	boolean isReached = rd.checkAllNodeIsReachForMergerNode(NodeId);
    	return isReached ? "true":"false";
    }
    
	/**
	 * 根据基准获取办理人
	 * @param basenode
	 * @param rolebase
	 * @param relation
	 * @return
	 */
	public String getRelationUser(String basenode,String rolebase,String relation){
		StringBuilder sb = new StringBuilder(1000);
		String tenantid = rd.getInitData().getTenantid();
		int size = 1,i=0;
		int[] base = new int[size];
		int[] fieldReplace = new int[size];
		String[] relations = new String[size];
		String[] nodeAuthor = new String[size];//节点办理人
		String [] tarRange = new String[size];
		
		fieldReplace[i] = 2;//Integer.parseInt(relation.getGatherType());//交并集 1:交集
		relations[i] = relation;
		base[i] = Integer.parseInt(rolebase);//关系基准		
		
		String baseNode = basenode;//基准节点
		
		String temp = ActionCommon.getInstance().getSingleRelation(rd,sb,baseNode,base[i],relation,StaticVarExtend.AUTH_DONE);
		IOrganizationInterface oi = PluginsUtil.getMultiInstance().getOrganization(tenantid);
		if("".equals(temp)){
			//20231031 新增组织机构包含关系功能（之前只支持字符串对比），修改为如果为人员信息，且为包含比对，那么此处使用AlluserId
			if(null!=sb &&StringUtil.hasValue(sb.toString())){
				String authorStr=sb.toString();
				if(authorStr.contains("/")){
					String[] authArr=authorStr.split(";");

					for (String auth:authArr) {
						if(StringUtil.hasValue(auth)){

							String userId=auth.split("/")[0].replace("U_","");
							sb.append(StaticVar.UserSplitChar);
							sb.append(oi.getAllUserids(userId,rd.getInitData().getFlowIdentifier()));
						}
					}
				}
			}
			return sb.toString();
		}
		nodeAuthor[i]=temp;
		

		Map<String,Object> para = new HashMap<String,Object>();
		para.put("creator", rd.getCreatorFullName());//
		para.put("done", nodeAuthor);
		para.put("relation", relations);
		para.put("gathertype", fieldReplace);
		para.put("base", base);
		para.put("tarRange", tarRange);
		para.put("userid", rd.getCurUser().getFullName());
		temp = oi.getRelationUser(para, rd.getInitData().getFlowIdentifier());
		 
		return temp;
	}
	
	
	/**
	 * 获取流程变量值
	 * @return
	 */
	public String getVarValue(String Varid) {
	    String var="";
	    //System.out.println("规则对象调试信息=======rd.getFlowVar().getValue(Varid)=========="+Varid+"========"+rd.getFlowVar().getValue(Varid));
	    var=rd.getFlowVar().getValue(Varid);
	    return var;
	}

	
	
	/**
	 * 获取组织机构交并集
	 * 
	 * @param str1
	 * @param str2 交并运算符
	 *            U相并 N交
	 * @param str3
	 * @return
	 */
	public String orgUN(String str1, String str2, String str3) {
		String tenantid = this.rd.getInitData().getTenantid();
		String identifier = this.rd.getInitData().getFlowIdentifier();
		
		List<String> list1 = getUserList(str1,tenantid,identifier);
		List<String> list2 = getUserList(str3,tenantid,identifier);

		if (str2.equalsIgnoreCase("u")) {
			// 并集
			list2.removeAll(list1);
			list1.addAll(list2);
		} else {
			// 交集
			list1.retainAll(list2);
		}

		String rs = "";

		for (String s : list1) {
			if(s== null ||s.length()==0 || s.equals("null")){
				continue;
			}
			if (rs.length() == 0) {
				rs = s;
			} else {
				rs += StaticVarExtend.UserSplitChar + s;
			}
		}

		return rs;
	}

	private List<String> getUserList(String str1,String tenantid,String identifier) {
		List<String> userList = new ArrayList<String>();

		String[] str = str1.split(StaticVarExtend.UserSplitChar);
		IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(tenantid);
		for(String t :str){
			if (t.startsWith("/D_") || t.startsWith("D_")) {				
				String[] tmp = org.getAllUserFromDept(t.substring(t.indexOf("_")+1), true, identifier).split(StaticVarExtend.UserSplitChar);				
				for (int i = 0; i < tmp.length; i++) {
					userList.add(tmp[i].startsWith(StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix)?
							tmp[i]: StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix + tmp[i]);
				}
			} else if (t.startsWith("/G_") || t.startsWith("G_")) {
				String[] tmp = org.getAllUserFromGroup(t.substring(t.indexOf("_")+1), identifier).split(StaticVarExtend.UserSplitChar);
				for (int i = 0; i < tmp.length; i++) {
					userList.add(tmp[i].startsWith(StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix)?
							tmp[i]: StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix + tmp[i]);
				}
			} else if (t.startsWith("/P_") || t.startsWith("P_")) {
				String[] tmp = org.getAllUserFromPosition(t.substring(t.indexOf("_")+1), identifier).split(StaticVarExtend.UserSplitChar);
				for (int i = 0; i < tmp.length; i++) {
					userList.add(tmp[i].startsWith(StaticVarExtend.UserFix +StaticVarExtend. Mark_Fix)?
							tmp[i]: StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix + tmp[i]);
				}				
			} 
//			else if (t.startsWith("/R_") || t.startsWith("R_")) {
//				String[] tmp = org.getAllUserFromRole(t.substring(t.indexOf("_")+1), identifier).split(UserSplitChar);
//				for (int i = 0; i < tmp.length; i++) {
//					userList.add(tmp[i].startsWith(UserFix + Mark_Fix)?tmp[i]: UserFix + Mark_Fix + tmp[i]);
//				}				
//			} 
			else {
				userList.add(t.startsWith(StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix)?
						t: StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix + t);			
			}
			userList.add(t);
		}
		return userList;
	}
	
	
	
	
	public String allTodo(String usersID){
		return usersID;
	}
	
	public String curTodo(String usersID){
		return usersID;
	}
}
