package com.horizon.wf.third.hz.rule.drools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

import javax.rules.RuleRuntime;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Builds up the JSR94 object structure. It'll simplify the task of building a
 * <code>RuleExecutionSet</code> and associated <code>RuntimeSession</code>
 * objects from a given <code>InputStream</code>.
 * 
 * @author N. Alex Rupp (n_alex <at>codehaus.org)
 */
public class RuleEngineFacadeBean {

	private static final Logger logger = LoggerFactory.getLogger(RuleEngineFacadeBean.class);;

	private static final Map<String, RuleSetWapper> RULESETMAP = new HashMap<String, RuleSetWapper>();

	public String ruleServiceProviderName = "org.drools.jsr94.rules.RuleServiceProviderImpl";
	public String ruleServiceProviderUri = "http://drools.org/";

	private RuleAdministrator ruleAdministrator;

	private RuleServiceProvider ruleServiceProvider;

	private LocalRuleExecutionSetProvider ruleSetProvider;

	private RuleRuntime ruleRuntime;

	private boolean init = false;

	//
	private RuleSetBean ruleSet = new RuleSetBean();

	public RuleEngineFacadeBean() {}

	public RuleEngineFacadeBean(String ruleServiceProviderUri,
			String ruleServiceProviderName) throws Exception {
		setRuleServiceProviderUri(ruleServiceProviderUri);
		setRuleServiceProviderName(ruleServiceProviderName);
		init();
	}

	public void init() throws Exception {
		if (init) {
			return;
		}
		RuleServiceProviderManager
				.registerRuleServiceProvider(getRuleServiceProviderUri(), Class
						.forName(getRuleServiceProviderName()));

		setRuleServiceProvider(RuleServiceProviderManager
				.getRuleServiceProvider(getRuleServiceProviderUri()));

		setRuleAdministrator(getRuleServiceProvider().getRuleAdministrator());

		setRuleSetProvider(getRuleAdministrator()
				.getLocalRuleExecutionSetProvider(null));
	}

	/**
	 * Returns a named <code>StatelessRuleSession</code>.
	 * 
	 * 
	 * @return StatelessRuleSession
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	public StatelessRuleSession getStatelessRuleSession(final String key,
			final java.util.Map properties) throws Exception {
		setRuleRuntime(getRuleServiceProvider().getRuleRuntime());

		String ruleSetName = getRuleSetName(key);
		loadRuleSet(ruleSetName);

		return (StatelessRuleSession) getRuleRuntime()
				.createRuleSession(ruleSetName, properties,
									RuleRuntime.STATELESS_SESSION_TYPE);
	}

	/**
	 * Returns a named <code>StatelessRuleSession</code>.
	 * 
	 * @param key
	 * @return StatelessRuleSession
	 * @throws Exception
	 */
	public StatelessRuleSession getStatelessRuleSession(final String key)
			throws Exception {
		return this.getStatelessRuleSession(key, null);
	}

	public StatefulRuleSession getStatefulRuleSession(final String key)
			throws Exception {
		return this.getStatefulRuleSession(key, null);
	}

	@SuppressWarnings("rawtypes")
	public StatefulRuleSession getStatefulRuleSession(final String key,
			final java.util.Map properties) throws Exception {
		setRuleRuntime(getRuleServiceProvider().getRuleRuntime());

		String ruleSetName = getRuleSetName(key);
		loadRuleSet(ruleSetName);

		return (StatefulRuleSession) getRuleRuntime()
				.createRuleSession(ruleSetName, properties,
									RuleRuntime.STATEFUL_SESSION_TYPE);
	}

	private String getRuleSetName(String ruleSetName) {
		String ruleSetName2 = getRuleSet().getRuleSetName(ruleSetName);
		if (ruleSetName2 == null) {
			ruleSetName2 = ruleSetName;
		}
		return ruleSetName2;
	}

	private RuleSetWapper loadRuleSet(String ruleSetName) throws Exception {

		RuleSetWapper ruleSetWapper = getRULESETMAP().get(ruleSetName);
		String classStr = "class:";
		String fileStr = "file:";
		String dbStr = "db:";
		String urlStr = "url:";
		String strStr ="string:";
		if (ruleSetName.startsWith(classStr)) {//////===========================
			// ==class
			try {
				if (ruleSetWapper == null) {
					String str = ruleSetName.substring(classStr.length());
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					InputStream is = getClass().getResourceAsStream(str);
					int data = is.read();
					while (data > -1) {
						baos.write(data);
						data = is.read();
					}

					Map<String, Object> config = new HashMap<String, Object>();
					RuleExecutionSet ruleExecutionSet;
					byte[] byteArray = baos.toByteArray();
					ruleExecutionSet = getRuleSetProvider()
							.createRuleExecutionSet(
													new InputStreamReader(
															new ByteArrayInputStream(
																	byteArray),
															"UTF-8"), config);
					ruleSetWapper = new RuleSetWapper(byteArray.length, 0L,
							ruleSetName, ruleExecutionSet);
					getRULESETMAP().put(ruleSetName, ruleSetWapper);
					getRuleAdministrator()
							.registerRuleExecutionSet(ruleSetName,
														ruleExecutionSet, null);

					is.close();
				}
			} catch (Exception e) {
				logger.error("Cann't not create rule set: " + ruleSetName, e);
				throw e;
			}
		}// ////=============================class
		else if (ruleSetName.startsWith(fileStr)) {//////=======================
			// ======file
			String str = ruleSetName.substring(fileStr.length());
			try {
				File file = new File(str);
				if (!file.exists() || !file.isFile()) {
					logger.error("Cann't not load rule set file: "
									+ ruleSetName);
				}
				if (ruleSetWapper != null
					&& ruleSetWapper.getUpdateTime() >= file.lastModified()) {
					//do nothing
				} else {
					//
					FileInputStream is = new FileInputStream(file);

					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					int data = is.read();
					while (data > -1) {
						baos.write(data);
						data = is.read();
					}

					Map<String, Object> config = new HashMap<String, Object>();
					RuleExecutionSet ruleExecutionSet;
					byte[] byteArray = baos.toByteArray();
					ruleExecutionSet = getRuleSetProvider()
							.createRuleExecutionSet(
													new InputStreamReader(
															new ByteArrayInputStream(
																	byteArray),
															"UTF-8"), config);
					ruleSetWapper = new RuleSetWapper(byteArray.length, file
							.lastModified(), ruleSetName, ruleExecutionSet);
					getRULESETMAP().put(ruleSetName, ruleSetWapper);
					getRuleAdministrator()
							.registerRuleExecutionSet(ruleSetName,
														ruleExecutionSet, null);

					is.close();
				}
			} catch (Exception e) {
				logger.error("Cann't not create rule set: " + ruleSetName, e);
				throw e;
			}
		}// ////=============================file
		else if (ruleSetName.startsWith(dbStr)) {//////=========================
			// ====db
			logger.error("DB protocal not surport.");
		}// ////=============================db
		else if (ruleSetName.startsWith(urlStr)) {//////=========================
			// ====url
			logger.error("URL protocal not surport.");
		}// ////=============================url
		else if (ruleSetName.startsWith(strStr)){
			// ======file
			String str = ruleSetName.substring(strStr.length());
			try {
				/*File file = new File(str);
				if (!file.exists() || !file.isFile()) {
					logger.error("Cann't not load rule set file: "
									+ ruleSetName);
				}
				if (ruleSetWapper != null
					&& ruleSetWapper.getUpdateTime() >= file.lastModified()) {
					//do nothing
				} else {*/
					//
					/*FileInputStream is = new FileInputStream(file);

					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					int data = is.read();
					while (data > -1) {
						baos.write(data);
						data = is.read();
					}*/

					Map<String, Object> config = new HashMap<String, Object>();
					RuleExecutionSet ruleExecutionSet;
					byte[] byteArray = str.getBytes();
					InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(byteArray));
					ruleExecutionSet = getRuleSetProvider()	.createRuleExecutionSet(in	, config);
					ruleSetWapper = new RuleSetWapper(byteArray.length, 0, ruleSetName, ruleExecutionSet);
					getRULESETMAP().put(ruleSetName, ruleSetWapper);
					getRuleAdministrator()
							.registerRuleExecutionSet(ruleSetName,
														ruleExecutionSet, null);

				//}
			} catch (Exception e) {
				logger.error("Cann't not create rule set: " + ruleSetName, e);
				throw e;
			}
		}
		else {// ////=============================other
			logger.error("Not surport protocal.");
		}
		getRuleAdministrator().registerRuleExecutionSet(
														ruleSetName,
														ruleSetWapper
																.getRuleSet(),
														null);

		return ruleSetWapper;
	}

	public RuleServiceProvider getRuleServiceProvider() {
		return this.ruleServiceProvider;
	}

	public String getRuleServiceProviderName() {
		return ruleServiceProviderName;
	}

	public void setRuleServiceProviderName(String ruleServiceProviderName) {
		this.ruleServiceProviderName = ruleServiceProviderName;
	}

	public String getRuleServiceProviderUri() {
		return ruleServiceProviderUri;
	}

	public void setRuleServiceProviderUri(String ruleServiceProviderUri) {
		this.ruleServiceProviderUri = ruleServiceProviderUri;
	}

	public RuleAdministrator getRuleAdministrator() {
		return ruleAdministrator;
	}

	public void setRuleAdministrator(RuleAdministrator ruleAdministrator) {
		this.ruleAdministrator = ruleAdministrator;
	}

	public LocalRuleExecutionSetProvider getRuleSetProvider() {
		return ruleSetProvider;
	}

	public void setRuleSetProvider(LocalRuleExecutionSetProvider ruleSetProvider) {
		this.ruleSetProvider = ruleSetProvider;
	}

	public RuleRuntime getRuleRuntime() {
		return ruleRuntime;
	}

	public void setRuleRuntime(RuleRuntime ruleRuntime) {
		this.ruleRuntime = ruleRuntime;
	}

	public void setRuleServiceProvider(RuleServiceProvider ruleServiceProvider) {
		this.ruleServiceProvider = ruleServiceProvider;
	}

	public RuleSetBean getRuleSet() {
		return ruleSet;
	}

	public void setRuleSet(RuleSetBean ruleSet) {
		this.ruleSet = ruleSet;
	}

	public static Map<String, RuleSetWapper> getRULESETMAP() {
		return RULESETMAP;
	}

	public class RuleSetWapper {
		private long length;
		private long updateTime;
		private String fileName;
		private RuleExecutionSet ruleSet;

		public RuleSetWapper() {}

		public RuleSetWapper(long length, long updateTime, String fileName,
				RuleExecutionSet ruleSet) {
			this.length = length;
			this.updateTime = updateTime;
			this.fileName = fileName;
			this.ruleSet = ruleSet;
		}

		public long getLength() {
			return length;
		}

		public void setLength(long length) {
			this.length = length;
		}

		public long getUpdateTime() {
			return updateTime;
		}

		public void setUpdateTime(long updateTime) {
			this.updateTime = updateTime;
		}

		public String getFileName() {
			return fileName;
		}

		public void setFileName(String fileName) {
			this.fileName = fileName;
		}

		public RuleExecutionSet getRuleSet() {
			return ruleSet;
		}

		public void setRuleSet(RuleExecutionSet ruleSet) {
			this.ruleSet = ruleSet;
		}
	}
}
