package com.horizon.wf.third.hz.rule.drools;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.rules.StatefulRuleSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR94SessionBean {

	private static final Logger logger = LoggerFactory.getLogger(JSR94SessionBean.class);;

	private RuleEngineFacadeBean ruleEngineFacade;

	//
	private StatefulRuleSession ruleSession = null;

	public JSR94SessionBean() {

	}

	public JSR94SessionBean(RuleEngineFacadeBean ruleEngineFacade) throws Exception {
		setRuleEngineFacade(ruleEngineFacade);
		init();
	}

	public void init() throws Exception {
		getRuleEngineFacade().init();
	}

	public void destroy() {
		if (ruleSession != null) {
			try {
				ruleSession.release();
			} catch (Exception e) {
			}
		}
	}

	@SuppressWarnings("rawtypes")
	public List<?> executeStatefulRules(String ruleSetName, List<?> factList, Map properties) throws Exception {
		init();
		if (ruleSetName == null) {
			logger.error("Rule set is not specify!!!");
			return Collections.EMPTY_LIST;
		}
		ruleSession = getRuleEngineFacade().getStatefulRuleSession(ruleSetName, properties);
		ruleSession.addObjects(factList);
		ruleSession.executeRules();
		List<?> objectList = ruleSession.getObjects();
		ruleSession.release();

		return objectList;
	}

	public StatefulRuleSession getRuleSession() {
		return ruleSession;
	}

	public void setRuleSession(StatefulRuleSession ruleSession) {
		this.ruleSession = ruleSession;
	}

	public RuleEngineFacadeBean getRuleEngineFacade() {
		return ruleEngineFacade;
	}

	public void setRuleEngineFacade(RuleEngineFacadeBean ruleEngineFacade) {
		this.ruleEngineFacade = ruleEngineFacade;
	}

}
