package com.horizon.wf.third.hz.rule.drools;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.rule.jsr94.IRuleEngine;

public class DroolsImpl implements IRuleEngine {
	private RunningData rd;
	private ITaskNode tNode;
	
	
	public void setPara(String key, Object obj) {
		if("RunningData".equals(key)){
			rd = (RunningData)obj;
		}
		else if("ITaskNode".equals(key)){
			tNode = (ITaskNode)obj;
		}
	}

	public Object exctu(String script) throws Exception {
		RuleEngineFacadeBean ruleEngineFacade = new RuleEngineFacadeBean();
		JSR94SessionBean s = new JSR94SessionBean(ruleEngineFacade);
		ScriptBean ta = new ScriptBean();
		List<Object> inputs = new ArrayList<Object>();
		RuleFun rf = new RuleFun();
		rf.setRd(rd);
		rf.settNode(tNode);
		inputs.add(ta);
		inputs.add(rf);
//		String ruleSetName = "string:"+flex.messaging.util.URLDecoder.decode(script);
//		List<?> rs = s.executeStatefulRules(ruleSetName,inputs,null);
		
		String ruleSetName = URLDecoder.decode(script,"UTF-8");
		byte[] str = ruleSetName.getBytes("UTF-8");
		ruleSetName = "string:"+(new String(str,"UTF-8")).trim();
		List<?> rs = s.executeStatefulRules(ruleSetName,inputs,null);

		s.destroy();
		for(int i=0,n=rs.size();i<n;i++){
			Object o = rs.get(i);
			if(o instanceof  ScriptBean){
				return ((ScriptBean)o).returnValue;
			}
		}
		return "";
	}

}
