package com.horizon.wf.third.hz.push;

import flex.messaging.MessageBroker;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.util.UUIDUtils;
/**
 * 发送消息给Flex前端
 * @author liys
 *
 */
public class PushToFlex {
	private MessageBroker msgBroker;
	private String clientID;

	private PushToFlex() {
		synchronized (PushToFlex.class){
			if(!SingleExampleInit.initialized){
				SingleExampleInit.initialized = true;
				msgBroker = MessageBroker.getMessageBroker(null);
				clientID = UUIDUtils.createUUID();
			}
			else{
				throw new RuntimeException("PushToFlex单例已被侵犯.");
			}
		}

	}
	public static PushToFlex getInstance(){
		return SingleExampleHolder.INSTANCE;
	}
	private static class SingleExampleInit{
		private static boolean initialized = false;
	}
	private static class SingleExampleHolder{
		private static final PushToFlex INSTANCE = new PushToFlex();
	}

	public void send(Object tick) {
		AsyncMessage msg = new AsyncMessage();
		msg.setDestination("hzmessage");
		msg.setHeader(AsyncMessage.SUBTOPIC_HEADER_NAME, "tick");

		msg.setClientId(clientID);
		msg.setMessageId(UUIDUtils.createUUID());
		msg.setTimestamp(System.currentTimeMillis());
		msg.setBody(tick);
		msgBroker.routeMessageToService(msg, null);
	}
}
