package com.horizon.wf.third.hz.overdue;

import com.horizon.third.Persistence;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.entity.db.DBTask;
import com.horizon.wf.expand.impl.IHZCalendar;
import com.horizon.wf.global.DateUtilExtend;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.AccessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 演示代码
 * 自动催办,超期异常处理,用于定时器调用
 * @author liys
 *
 */
public class XMLExpend{
	private static final Logger LOGGER = LoggerFactory.getLogger(XMLExpend.class);
	private static Persistence access = ThirdAdapterFactory.getPersistenceInstance();
	
	private static XMLExpend instance = new XMLExpend();
	
	public static XMLExpend getInstance(){
		return instance;
	}
	private XMLExpend(){}
	/**
	 * 演示代码
	 * 自动催办,超期异常处理,用于定时器调用
	 * @return
	 */
	public final List<String> autoReMsg(String tenantid,String identifier) {
		String sql = "SELECT * FROM "+StaticVarExtend.Table_Task +" WHERE (FLOWLIMITDATE>0 OR NODELIMITDATE>0) AND FLOWSTATUS <"+StaticVarExtend.FlowStatus_End
					+ " AND STATUS in ('" + StaticVarExtend.Task_Normal + "','" + StaticVarExtend.Task_Waring + "')";
		List<DBTask> lst = AccessUtil.getInstance().getMultiObject(sql, null, DBTask.class,identifier);
		List<String> bklst = new ArrayList<String>();
		if(lst == null){
			LOGGER.info("没有符合条件的催办信息");
			return bklst;
		}
		IHZCalendar calendar = PluginsUtil.getMultiInstance().getCalendar(tenantid);
		String nowDate = DateUtilExtend.getNow();
		for(int i=0,n=lst.size();i<n;i++) {
			DBTask xdTask = lst.get(i);
			LOGGER.info(xdTask.getWorkid()+"============="+xdTask.getTitle());
			//首先判断是否已经超期
			if(xdTask.getStatus() == StaticVarExtend.Task_All_Pass){//全局超期
				bklst.add(defaultOverPass(xdTask,tenantid,identifier,true));
			}else if(xdTask.getStatus() == StaticVarExtend.Task_Pass){//节点超期
				bklst.add(defaultOverPass(xdTask,tenantid,identifier,false));
			}else{
				//首先判断是否超过流程规定时间
				int ftime = xdTask.getFlowlimitdate();
				if(ftime>0){
					//全局超期
					if(DateUtilExtend.isOverPass(nowDate,xdTask.getStarttime(),ftime,xdTask.getFlowlimittype(),calendar)) {
						bklst.add(defaultOverPass(xdTask,tenantid,identifier,true));
						continue;
					}
				}
				//判断是否超过节点规定时间
				ftime = xdTask.getNodelimitdate();
				if(ftime>0) {
					//节点超期
					if(DateUtilExtend.isOverPass(nowDate,xdTask.getReceivetime(),ftime,xdTask.getNodelimittype(),calendar)) {
						bklst.add(defaultOverPass(xdTask,tenantid,identifier,false));
						continue;
					}
					
					//判断催办此时是否在允许范围内,允许催办,但是催办次数已经超过允许次数时,忽略
					if(xdTask.getRemsgnum()>0 &&  xdTask.getRemsgnum()<= xdTask.getRedonenum()) {
						continue;
					}
					
					ftime = xdTask.getWaringdate();
					if(ftime>0) {
						//判断节点是否达到警告时间
						if(DateUtilExtend.isOverPass(nowDate,xdTask.getReceivetime(),ftime,xdTask.getNodelimittype(),calendar)) {		
							xdTask.setStatus(StaticVarExtend.Task_Waring);
							LOGGER.info("催办:"+xdTask.getTitle());
							bklst.add(createTaskLog(xdTask,tenantid,identifier));
						}
					}
				}
			}
		}
		LOGGER.info("=====共处理:"+bklst.size());
		return bklst;
	}
	
	/**
	 * 超期处理,示例
	 * @param xdTask
	 * @return
	 */
	private String defaultOverPass(DBTask xdTask,String tenantid,String identifier,boolean isAllPass) {
		StringBuilder sb = new StringBuilder(2000);		
		IWorkflowOperator ica = WorkflowFactory.getWorkflowOperator();	//流程操作对象
		WorkParaBean xfb = new WorkParaBean();			//操作参数对象
		xfb.setUserId(StaticVarExtend.System_Id);		//当前操作人id
//		xfb.setUserName(StaticVarExtend.System_Name);	//当前操作人名称
		xfb.setFlowIdentifier(identifier);				//流程数据的数据源
		xfb.setTenantCode(tenantid);
		xfb.setWorkId(xdTask.getWorkid());
		xfb.setTrackId(xdTask.getTrackid());
		IWorkResult wb = ica.open(xfb);	//打开实例
		xfb.setUrlApp(StaticVarExtend.Todo_Default_URL.replace("|workid|", xdTask.getWorkid()));
		xfb.setTitle(xdTask.getTitle());
		if(StaticVarExtend.Init_Success == wb.getResult()){
			IFlowNode node = wb.getFlowinfo().getNodeById(xdTask.getNodeid());
			String exceptionCode = StaticVarExtend.Exception_Code_OverTime;//异常代码，默认为：节点超期
			int status = StaticVarExtend.Task_Pass;//任务状态，默认为：节点超期
			if(isAllPass){//全局超期
				exceptionCode = StaticVarExtend.Exception_Code_All_OverTime;
				status = StaticVarExtend.Task_All_Pass;
			}
			INodeException exception = ActionCommon.getInstance().getExceptionByCode(exceptionCode, node.getExceptions());
			ActionCommon.getInstance().handleException(exception, node, xfb, wb.getRunningdata());	
			if (!(exception == null || "4".equals(exception.getExceptionDealType()))) {// 终止,
    			xdTask.setStatus(status);
    			Map<String,Object> lm  = new LinkedHashMap<String,Object>();
    			lm.put(StaticVarExtend.Table_Task.toLowerCase(), xdTask);
    			if(!access.saveObjectData(lm,identifier)) {
    				//sb.append(","+StaticVar.getInstance().WF_00090()); 
    			}
			}
			sb.append(",Title=").append(xdTask.getTitle());
		}else{
			StaticFunExtend.println("[msg]open error.result:"+wb.getResult()+",msg:"+wb.getBackMsg());
		}

				
		return sb.toString();
	}
	
	/**
	 * 创建催办信息
	 * @param xdTask
	 * @return
	 */
	private String createTaskLog(DBTask xdTask,String tenantid,String identifier){
		xdTask.setStatus(StaticVarExtend.Task_Waring);
		Map<String,Object> lm  = new LinkedHashMap<String,Object>();
		lm.put(StaticVarExtend.Table_Task.toLowerCase(), xdTask);
		
		if(!access.saveObjectData(lm,identifier)) {
			//sb.append(","+StaticVar.getInstance().WF_00090()); 
		}
		
		IWorkflowOperator ica = WorkflowFactory.getWorkflowOperator();	//流程操作对象
		WorkParaBean xfb = new WorkParaBean();			//操作参数对象
		xfb.setUserId(StaticVarExtend.System_Id);		//当前操作人id
//		xfb.setUserName(StaticVarExtend.System_Name);	//当前操作人名称
		xfb.setFlowIdentifier(identifier);				//流程数据的数据源
		xfb.setTenantCode(tenantid);
		xfb.setWorkId(xdTask.getWorkid());
		xfb.setTrackId(xdTask.getTrackid());
		IWorkResult wb = ica.open(xfb);	//打开实例
		int cp = wb.getResult();
		if(cp == StaticVarExtend.Init_Success){
			xfb.setSubmitflag("0");
			xfb.setUrlApp("/horizon/workflowframe/publishframe/xmlwork.index.example.jsp?workid="+xdTask.getWorkid()+"&dbIdentifier="+identifier+"&isembedded=false");
			xfb.setActionClass("com.horizon.wf.action.ActionReMsg");
			xfb.setFunname("urge");
			xfb.setComment(PubInfo.getPubInfo(tenantid).getInfo("ReMsg_Msg0005", "催办"));
			xfb.setTitle(xdTask.getTitle());
			wb = ica.operator(xfb);	//调用流程实例的操作
			cp = wb.getResult();
			if(cp == StaticVarExtend.F_STATUS_Success){
				return "urge success";
			}
			else{
				ica.close(xdTask.getWorkid(), xdTask.getTrackid(), StaticVarExtend.System_Id);
			}
		}
		return "urge error";
		
	}
	
}
