package com.horizon.wf.third.hz.overdue;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.entity.db.DBTask;
import com.horizon.wf.global.DateUtilExtend;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.AccessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 超期任务执行
 * 把每条任务放在一个新的线程中执行,通过这种方法并行处理来提升处理效率,以便能达到按照分钟的频率进行提醒的要求
 * 实际执行效率,还需要根据实际生产环境中 大概产生的实例数以及每条实例需要执行的时间来设置,线程池的大小
 * 最终执行时间跟需要执行的任务数(size)和线程池的核心数(corePoolSize)有直接关系,
 *    跟线程池的最大数(maximumPoolSize)好像没有直接的关系,
 *    maximumPoolSize = n * corePoolSize; (n>=1) n的大小好像并不能改善最终的执行时间
 * 假设任务执行的最长时间为一定数(T),那么最终执行时间:
 * 1) size < corePoolSize 时 约等于 T
 * 2) size > corePoolSize 时 约等于 size/corePoolSize * T *
 * 例如:
 * 需求: 客户需要按照分钟的频率来检测过期任务,在运行中的任务数大概5000条,每条任务执行需要的最大时间为4秒
 * 分析: 在定时任务中需要按分钟的频率来启动定时任务,为了准确率,
 *       每次定时任务必须在一分钟内要执行完毕,否则就会在下一次任务到来时,因为上一次还在运行中而被取消.
 *       线程池的大小计算: 60/4 = 15 也就是说线程池的大小 * 15 需要大于5000
 *       线程池的大小至少设置为334,才能满足系统在一分钟内处理完5000条任务,但是考虑到一些延迟/极限的情况,
 *       实际设置的大小应该大于358
 * @author LIYS
 * 2019-01-07
 */
public class InstanceExtend {

    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceExtend.class);
    private static boolean isRun = false;

    public static void reMsg(String tenantid,String identifier){
        if(isRun){
            LOGGER.info("....超期任务执行中");
            return;
        }
        LOGGER.info("超期任务开始执行....");
        isRun = true;
        //获取所有需要处理的任务
        List<DBTask> lst = getTaskList(identifier);
        if(lst == null || lst.isEmpty()){
            LOGGER.info("....没有需要处理的文件.");
        }
        else {
            int corePoolSize = HZResourceBundle.getInstance().getCorePoolSize();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, corePoolSize,
                    200, TimeUnit.MILLISECONDS,
                    new ArrayBlockingQueue<Runnable>(corePoolSize));
            CountBean countBean = new CountBean();
            Date nowDate = DateUtilExtend.getNowDate();
            int totalSize = corePoolSize + corePoolSize;
            int size = lst.size();
            for (int i = 0, n = size; i < n; i++) {
                DBTask task = lst.get(i);

                TimerTask myTask = new TimerTask(countBean, task, nowDate, tenantid, identifier);
                executor.execute(myTask);
                //等待空闲
                waitFreeThread(executor, totalSize);
            }
            executor.shutdown();

            waitAllTaskEnd(countBean, size);
        }

        isRun = false;
        LOGGER.info("....超期任务执行结束");
    }
    //只获取未处理过的(flowstatus=140暂停的不处理,status=1之外的标记为超期的,不处理)
    private static List<DBTask> getTaskList(String identifier){
        //获取全部数据????如果数据超级多时,肯定是不行的
        String sql = "SELECT * FROM "+StaticVarExtend.Table_Task
                +" WHERE STATUS="+StaticVarExtend.Task_Normal
                +" AND FLOWSTATUS!=" +StaticVarExtend.FlowStatus_Pause;
        List<DBTask> lst = AccessUtil.getInstance().getMultiObject(sql, null, DBTask.class,identifier);

        return lst;
    }

    public static void doTask(DBTask task,Date nowDate,String tenantid,String identifier){
//        int status = task.getStatus();
//        if(status == StaticVarExtend.Task_All_Pass){
//            //已经被标记为全局超期的任务
//
//        }
//        else if(status == StaticVarExtend.Task_Pass){
//            //已经标记为超期任务
//
//        }
//        else
            { //(status == StaticVarExtend.Task_Normal)
            //1.获取全局时间
            int ftime = task.getFlowlimitdate();
            if(ftime > 0){
                //判断是否全局超期,设置的日期比当前日期小,说明已经过了时限
                if(DateUtilExtend.date1BeforeDate2(task.getFlowlimittime(),nowDate)){
                    task.setStatus(StaticVarExtend.Task_All_Pass);
                    //TODO  超期处理执行
                    doOverPass(task,tenantid,identifier,true);
                    return;
                }
            }
            //判断是否超过节点规定时间
            ftime = task.getNodelimitdate();
            if(ftime>0) {
                //判断当前节点时限是否超期
                if(DateUtilExtend.date1BeforeDate2(task.getNodelimittime(),nowDate)){
                    task.setStatus(StaticVarExtend.Task_Pass);
                    //TODO  超期处理执行
                    doOverPass(task,tenantid,identifier,false);

                    return;
                }
                //判断催办此时是否在允许范围内,允许催办,但是催办次数已经超过允许次数时,忽略
                if(task.getRemsgnum()>0 && task.getRemsgnum()<= task.getRedonenum()) {
                    return;
                }

                ftime = task.getWaringdate();
                if(ftime>0) {
//                    task.setStatus(StaticVarExtend.Task_Waring);
                    //TODO  警告处理
                    createTaskLog(task,tenantid,identifier);
                    return;
                }
            }
        }
    }

    private static String UPDATESQL = "UPDATE " + StaticVar.Table_Task
            + " SET REDONENUM=?,STATUS=? WHERE ID=?";
    /**
     * 超期处理,示例
     * @param xdTask
     * @return
     */
    private static void doOverPass(DBTask xdTask,String tenantid,String identifier,boolean isAllPass) {
        IWorkflowOperator ica = WorkflowFactory.getWorkflowOperator();	//流程操作对象
        WorkParaBean paraBean = new WorkParaBean();			//操作参数对象
        paraBean.setUserId(StaticVarExtend.System_Id);		//当前操作人id
        paraBean.setFlowIdentifier(identifier);				//流程数据的数据源
        paraBean.setTenantCode(tenantid);
        paraBean.setWorkId(xdTask.getWorkid());
        paraBean.setTrackId(xdTask.getTrackid());
        IWorkResult wb = ica.open(paraBean);	//打开实例
        paraBean.setUrlApp(StaticVarExtend.Todo_Default_URL.replace("|workid|", xdTask.getWorkid()));
        paraBean.setTitle(xdTask.getTitle());
        if(StaticVarExtend.Init_Success == wb.getResult()){
            IFlowNode node = wb.getFlowinfo().getNodeById(xdTask.getNodeid());
            String exceptionCode = StaticVarExtend.Exception_Code_OverTime;//异常代码，默认为：节点超期
            if(isAllPass){//全局超期
                exceptionCode = StaticVarExtend.Exception_Code_All_OverTime;
            }
            INodeException exception = ActionCommon.getInstance()
                    .getExceptionByCode(exceptionCode, node.getExceptions());
            if(exception ==null){
                //没有定义异常处理时
                StaticFunExtend.println("[Msg]"+xdTask.getTitle()+"(Trackid="+xdTask.getTrackid()+")未定义超期处理方式.");
                return;
            }
            //0=自行处理,1=无,2=跳转,3=挂起,4=终止,
            String exceptionDealType = exception.getExceptionDealType();// 获取异常处理方式
            //在跳转和终止时,task不需要处理,
            if(!("2".equals(exceptionDealType) || "4".equals(exceptionDealType))) {
                //task更新语句放入handleException方法中一起执行,把map参数放入paraBean
                Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
                List<Object> para = new ArrayList<Object>();
                para.add(new Integer(xdTask.getRedonenum()));
                para.add(xdTask.getStatus());
                para.add(xdTask.getId());
                saveMap.put(UPDATESQL, para);
                paraBean.putOtherPara("UPDATETASK", saveMap);
            }
            ActionCommon.getInstance().handleException(exception, node, paraBean, wb.getRunningdata());
        }else{
            StaticFunExtend.println("[msg]"+xdTask.getTitle()+",open error.result:"+wb.getResult()+",msg:"+wb.getBackMsg());
        }
        //20210113 LIYS 超期执行完毕后,关闭实例,避免一直再活动实例(有的打开后,啥也不干)
        ica.close(xdTask.getWorkid(),xdTask.getTrackid(),StaticVarExtend.System_Id,identifier);
    }

    /**
     * 创建催办信息
     * @param xdTask
     * @return
     */
    private static String createTaskLog(DBTask xdTask,String tenantid,String identifier){
        IWorkflowOperator ica = WorkflowFactory.getWorkflowOperator();	//流程操作对象
        WorkParaBean xfb = new WorkParaBean();			//操作参数对象
        xfb.setUserId(StaticVarExtend.System_Id);		//当前操作人id
        xfb.setFlowIdentifier(identifier);				//流程数据的数据源
        xfb.setTenantCode(tenantid);
        xfb.setWorkId(xdTask.getWorkid());
        xfb.setTrackId(xdTask.getTrackid());
        IWorkResult wb = ica.open(xfb);	//打开实例
        int cp = wb.getResult();
        if(cp == StaticVarExtend.Init_Success){
            xfb.setSubmitflag("0");
            xfb.setUrlApp("/horizon/workflowframe/publishframe/xmlwork.index.example.jsp?workid="+xdTask.getWorkid()+"&dbIdentifier="+identifier+"&isembedded=false");
            xfb.setActionClass("com.horizon.wf.action.ActionReMsg");
            xfb.setFunname("urge");
            xfb.setComment(PubInfo.getPubInfo(tenantid).getInfo("ReMsg_Msg0005", "催办"));
            xfb.setTitle(xdTask.getTitle());
            wb = ica.operator(xfb);	//调用流程实例的操作
            cp = wb.getResult();
            if(cp == StaticVarExtend.F_STATUS_Success){
                return "urge success";
            }
            else{
                ica.close(xdTask.getWorkid(), xdTask.getTrackid(), StaticVarExtend.System_Id);
            }
        }
        return "urge error";

    }

    private static void  waitFreeThread(ThreadPoolExecutor executor,int totalSize){
        for(;;){
            if(executor.getPoolSize() + executor.getQueue().size() < totalSize){
                break;
            }
            //下面的sleep,必须要有,不然会一直运行,
            try {
                Thread.currentThread().sleep(1);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
    private static void waitAllTaskEnd(CountBean countBean,int size){
        for(;;){
            if(countBean.getNum() == size){
                break;
            }
            //下面的sleep,必须要有,不然会一直运行,
            try {
                Thread.currentThread().sleep(1);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        /*
        int corePoolSize = 20;
        int maximumPoolSize = 20;
        for(int i=1;i<25;i++){
            corePoolSize = i * 20;
            maximumPoolSize = i * 20;
            for(int j = 1 ;j<10;j++) {
                long time = oneAction(j * corePoolSize,corePoolSize,maximumPoolSize);
                System.out.println("coreSize=" + corePoolSize + ",Size=" + (j*corePoolSize) + ",result=" + time);
            }
        }
        //*/
        long time = oneAction(5000,334,334);
        System.out.println("result=" + time);
    }
    private static long  oneAction(int size,int corePoolSize,int maximumPoolSize){
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize,
                200, TimeUnit.MILLISECONDS,
                new ArrayBlockingQueue<Runnable>(maximumPoolSize));
        CountBean countBean = new CountBean();
        long start = System.currentTimeMillis();
        int totalSize = corePoolSize + maximumPoolSize;
        for(int i=0;i<size;i++){
            TimerTask myTask = new TimerTask(countBean,i);
            executor.execute(myTask);

            waitFreeThread(executor,totalSize);
        }
        executor.shutdown();
        waitAllTaskEnd(countBean,size);
        return System.currentTimeMillis() - start;
    }


}
