package com.horizon.wf.third.hz.overdue;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.core.responsible.ICurExtendedNode;
import com.horizon.wf.entity.db.DBTask;
import com.horizon.wf.expand.impl.IHZCalendar;
import com.horizon.wf.global.DateUtilExtend;
import com.horizon.wf.plugins.PluginsUtil;

import java.util.ArrayList;
import java.util.List;
/**
 * 获取节点超期列表,用于流程跟踪图显示时使用
 */
public class CurExtendedNodeImpl implements ICurExtendedNode {
	/**
	 * 获取指定实例中已经超期的活动节点ID
	 * @param workid
	 * @param identifier
	 * @return
	 */
	public List<String> getCurExtendedNodes(JSONObject json,String workid, String tenantid, String identifier) {
		List<String> result = new ArrayList<String>();//记录超期的节点
		if(workid == null|| workid.length()==0){
			return result;
		}
//		String sql = "SELECT * FROM "+StaticVarExtend.Table_Task +" WHERE workid=?";
//		List<Object> para = new ArrayList<Object>();
//		para.add(workid);
//		List<DBTask> lstTask =  AccessUtil.getInstance()
//				.getMultiObject(sql, para, DBTask.class,identifier);
		
		List<DBTask> lstTask = DBTask.getTaskLstByWorkid(json,workid,  identifier);
		if(lstTask == null || lstTask.size() == 0){
			return result;
		}
		String nowDate = DateUtilExtend.getNow();
		IHZCalendar calendar = PluginsUtil.getMultiInstance().getCalendar(tenantid);
		for(int i=0,n=lstTask.size();i<n;i++) {
			DBTask task = lstTask.get(i);
			//首先判断是否超过流程规定时间
			//STARTTIME,FLOWLIMITDATE,FLOWLIMITTYPE
			int ftime = task.getFlowlimitdate();
			if(ftime>0){
				if(DateUtilExtend.isOverPass(nowDate,task.getStarttime(),ftime,task.getFlowlimittype(),calendar)) {
					result.add(task.getNodeid());
					continue;
				}
			}
			//判断是否超过节点规定时间
			ftime = task.getNodelimitdate();
			if(ftime>0) {
				if(DateUtilExtend.date1BeforeDate2(task.getNodelimittime(), nowDate)) {
					result.add(task.getNodeid());
					continue;
				}
			}
		}
		return result;
	}
}
