package com.horizon.wf.third.hz.message;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.message.jms.IJmsMessageProcess;
import com.horizon.message.jms.entity.FlowMessage;
import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.action.event.ExecuteEventSubmit;
import com.horizon.wf.entity.db.DBNodeMessageTrigger;
import com.horizon.wf.expand.msg.FlowStartMessage;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.DateUtil;

/**
 * 接收到JMS发送的消息后的处理类
 * 此类在web.xml中JMS服务配置信息中指定
 *****************************************************
1、jms 文件夹位置: 
/com/horizon/message/jms
2、jmsconfig.properties 文件位置: /resources/jmsconfig.properties

3、web.xml中配置：
	<!-- JMS程序 JMSServlet Start-->
	<servlet>
		<servlet-name>JmsSupport</servlet-name>
		<servlet-class>com.horizon.message.jms.JmsSupport</servlet-class>
		<load-on-startup>1000</load-on-startup>
	</servlet>
	<servlet-mapping>
		<servlet-name>JmsSupport</servlet-name>
		<url-pattern>/JmsSupport.init</url-pattern>
	</servlet-mapping>
	<!-- JMS程序 JMSServlet End -->
	
4、消息处理类配置根据 jmsconfig.properties文件中的属性queueReceiverClass选择性放置：
例类文件 ：JMSMessageProcess.java

#JMS消息处理接口实现类
queueReceiverClass=.com.horizon.message.jms.JMSMessageProcess

5、修改对应的配置参数信息 jmsconfig.properties 根据您所使用的JMS实现服务器配置对应消息

调用说明
FolwMessage folwMessage = new FolwMessage();
folwMessage.setMessagePara("测试消息内容");
JmsSender.sendMessage("", "TestQueueName", folwMessage);
 * @author liys
 * @version 1.0
 * @since v7.0
 *
 */
public class JMSMessageProcess implements IJmsMessageProcess {

	public void doMsgProcess(Object msg) {
		StaticFunExtend.println("[msg]doMsgProcess start.");
		FlowMessage message = (FlowMessage) msg;
		String identifier = message.getIdentifier();
		if(StringUtilExtend.isNull(identifier)){
			StaticFunExtend.println("[msg]identifier is null.get default identifier:system");
			identifier = StaticVarExtend.DefaultIdentifier;
		}
		String para = message.getMessagePara();
		String sql = "select * from " + StaticVarExtend.Table_Node_Message_Trigger + " where  message_para=? and status=?";
		List<String> conditionList = new ArrayList<String>();
		conditionList.add(para);
		conditionList.add("1");//可执行
		List<DBNodeMessageTrigger> triggers =  AccessUtil.getInstance()
				.getMultiObject(sql, conditionList, DBNodeMessageTrigger.class, identifier);
		if(CollectionUtil.isListEmpty(triggers)) {
			StaticFunExtend.println("[msg]message trigger is null.");
			return;
		}
		for(int i=0;i<triggers.size();i++){
			DBNodeMessageTrigger tr = triggers.get(i);
			String messageType = tr.getMessageType();
			StaticFunExtend.println("[msg]MessageType:"+messageType);
			if(StaticVarExtend.Activation_Type_Node.equals(messageType)){//激活节点
				execute(tr, identifier);
			}else if("flowStart".equalsIgnoreCase(messageType)){//启动流程
				StaticFunExtend.println("[msg]execute start flow.");
				FlowStartMessage flowStartMessage = new FlowStartMessage();
				flowStartMessage.execute(tr, identifier);
			}else if(StaticVarExtend.Signal_Event_Type_Node.equals(messageType)){//自动提交至下一节点
				StaticFunExtend.println("[msg]execute event submit.");
				ExecuteEventSubmit eventSubmit = new ExecuteEventSubmit(tr.getWorkid(), tr.getTrackid(), tr.getNodeid(), identifier);
				eventSubmit.excuteSubmit();
				int result = eventSubmit.getWorkResult().getResult();
				Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
				if(StaticVarExtend.F_STATUS_Success == result){
					StaticFunExtend.println("[msg]execute event submit success.");
					deleteTrigger(tr, saveMap);//更新执行次数
					addTriggerLog(tr,saveMap,true);//处理完成后像记录表中插入记录
				}else{
					StaticFunExtend.println("[msg]execute event submit error.result:"+result+";msg:"+eventSubmit.getWorkResult().getBackMsg());
					addTriggerLog(tr,saveMap,false);//处理完成后像记录表中插入记录	
				}
				if(!saveMap.isEmpty()){
					StaticFunExtend.println("execute save.");
					 AccessUtil.getInstance().executeMultiUpdate(saveMap,identifier);
				}

			}
		}
		StaticFunExtend.println("[msg]doMsgProcess end.");
	}
	
	public boolean execute(DBNodeMessageTrigger tr,String identifier) {
		StaticFunExtend.println("[msg]active work start.");
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(activeTrigger(tr,identifier)){//激活节点
			deleteTrigger(tr, saveMap);//更新执行次数
			addTriggerLog(tr,saveMap,true);//处理完成后像记录表中插入记录
		}else{
			addTriggerLog(tr,saveMap,false);//处理完成后像记录表中插入记录	
		}
		if(!saveMap.isEmpty()){
			StaticFunExtend.println("[msg]active work end.");
			return  AccessUtil.getInstance().executeMultiUpdate(saveMap,identifier);
		}
		return true;
	}

	
	
	/**
	 * 添加消息触发日志记录
	 * @param t
	 * @param saveMap
	 * @param isActiveSuccess 
	 */
	protected void addTriggerLog(DBNodeMessageTrigger t,
			Map<String, List<Object>> saveMap, boolean isActiveSuccess) {
		StaticFunExtend.println("[msg]delete message trigger log.");
		t.setId(StaticFunExtend.getUnid());
		t.setTriggerTime(DateUtil.getNow());
		t.setIssuccess(isActiveSuccess?"0":"1");//true:执行成功为0
		saveMap.putAll(t.getLogSQL());
	}


	/**
	 * 删除消息数据
	 * @param t
	 * @param saveMap
	 */
	protected void deleteTrigger(DBNodeMessageTrigger t,
			Map<String, List<Object>> saveMap) {
		StaticFunExtend.println("[msg]delete message trigger.");
		List<Object> conditionList = new ArrayList<Object>(1);
		conditionList.add(t.getId());
		saveMap.put("delete from " + StaticVarExtend.Table_Node_Message_Trigger + " where id = ?", conditionList);
	}
	
	/**
	 * 激活不活动的节点
	 * @return
	 */
	private boolean activeTrigger(DBNodeMessageTrigger t,String identifier) {
		StaticFunExtend.println("[msg]active work.workid:"+t.getWorkid()+";trackid:"+t.getTrackid());
		ActionCommon ac = ActionCommon.getInstance();
		String ic = t.getMessageClass();
		return ac.activeTrigger(t.getWorkid(), t.getTrackid(),"Message", ic, identifier);							
	}

}
