package com.horizon.wf.third.hz.memory;

import java.util.Map;

import com.horizon.cache.memcached.IMemcached;
import com.horizon.cache.memcached.MemcachedFactory;
import com.horizon.wf.core.mem.IHZMemoryCacheManager;
/**
 * 集群环境下的内存缓存读写接口适配类
 * 类路径在workflow-core.xml中的MemoryClassName中配置
 * @author liys 20150310
 *
 */
public class HZMemoryCacheManagerImpl implements IHZMemoryCacheManager{
	//租户id,用来区分
	private String tenantid="";
	private  IMemcached cacheDBShare;
	private  IMemcached cacheFlowXML;
	private  IMemcached cacheUser;
	public HZMemoryCacheManagerImpl(){
		cacheDBShare = MemcachedFactory.newInstance().getMemoryCache("DBShare","");
		cacheFlowXML = MemcachedFactory.newInstance().getMemoryCache("FlowXML","");
		cacheUser	 = MemcachedFactory.newInstance().getMemoryCache("USER","");
	}
	public void setTenantid(String tenant){
		this.tenantid = tenant;
		//重置memcached对象
		cacheDBShare = MemcachedFactory.newInstance().getMemoryCache("DBShare",tenantid);
		cacheFlowXML = MemcachedFactory.newInstance().getMemoryCache("FlowXML",tenantid);
		cacheUser	 = MemcachedFactory.newInstance().getMemoryCache("USER",tenantid);
	}
	/**
	 * 获取内存中正在运行中的实例数量
	 * @return
	 */
	public int getActiveInstanceCounter(){
		return cacheDBShare.getActiveCounter();
	}

	/**
	 * 获取内存中所有缓存的实例数量
	 * 1.实例打开中
	 * 2.实例已经关闭
	 */
	public int getAllInstanceCounter(){
		return cacheDBShare.getTotleCounter();
	}
	/**
	 * 获取内存中正在运行的实例对象
	 */
	public Map<String,Object> getActiveInstanceMap(){
		return cacheDBShare.getActiveMap();
	}

	public Map<String,Object> getActiveInstanceMap(int page,int pagenum){
		return cacheDBShare.getActiveMap(page,pagenum);
	}

	/**
	 * 获取内存中所有的实例
	 * @return
	 */
	public Map<String,Object> getAllInstanceMap(){
		return cacheDBShare.getTotleMap();
	}
	public Map<String,Object> getAllInstanceMap(int page,int pagenum){
		return cacheDBShare.getTotleMap(page,pagenum);
	}

	public boolean activeKeyExists(String key){
		return cacheDBShare.activeKeyExists(key);
	}

	/**
	 * 存放锁对象到指定区域,存放完毕后不解锁,拒绝其它访问获取
	 * @param workId		实例id
	 * @param obj			实例对象
	 * @param lockTime		指定锁标记有效期，过期后锁自动失效。-1代表永不过期
	 */
	public void putLockDBShare(String workId,Object obj,int lockTime){
		cacheDBShare.put(workId, obj,lockTime);
	}
	/**
	 * 存放锁对象到指定区域,存放完毕后解锁,允许其他线程访问
	 * @param workId		实例id
	 * @param obj			实例对象
	 * @param lockTime		锁定时间
	 * @param isActive		解锁后实例对象是否继续处于活动状态
	 */
	public void putUnLockDBShare(String workId,Object obj,int lockTime,boolean isActive){
		cacheDBShare.put(workId, obj,lockTime,isActive);
	}

	/**
	 * 获取key对应区域中的workid的对象，并对该workid对象进行锁标记，拒绝其它访问获取
	 * @param workId	实例id
	 * @param lockTime	指定锁标记有效期，过期后锁自动失效。-1代表永不过期
	 * @param priority	指定优先级，大于0的数，数字小则表示优先级高，-1表示系统分配优先级
	 * @return
	 */
	public Object getLockDBShare(String workId,int lockTime, long priority){
		return cacheDBShare.get(workId);
	}

	/**
	 * 对 key进行强制解锁，删除key对应的锁标记
	 *
	 * @return
	 */
	public boolean unlockDBShare(String workId){
		cacheDBShare.unLock(workId);
		return true;
	}

	/**
	 * 从内存中删除指定workid的实例对象/或者是删除流程定义
	 * @param workId
	 */
	public void removeDBShare(String workId){
		cacheDBShare.remove(workId);
	}


	/**
	 * 存放无锁对象到指定区域,不需要判断冲突,直接替换或者增加
	 * @param flowId	实例id
	 * @param obj		实例对象
	 * @param activeTime	有效时间为整数，-1代表永不过期，单位为分钟
	 */
	public void putUnLockFlowXml(String flowId,Object obj,int activeTime){
		cacheFlowXML.put(flowId, obj,activeTime,true);
	}

	/**
	 * 获取指定的无锁对象区域中指定的对象
	 * @param flowId
	 * @return
	 */
	public Object getUnLockFlowXml(String flowId){
		return cacheFlowXML.get(flowId,false);
	}
	/**
	 * 从内存中删除指定flowId的对象
	 * @param flowId
	 */
	public void removeFlowXml(String flowId){
		cacheFlowXML.remove(flowId);
	}

	/**
	 * 清除共享内存中的所有数据，请谨慎使用。
	 *
	 * @return
	 */
	public boolean removeAll(){
		boolean r1 = cacheDBShare.removeAll();
		boolean r2 = cacheFlowXML.removeAll();

		return r1 && r2;
	}

	public boolean waitCacheLock(String workid,String userid){
		return cacheUser.pollElement(workid,userid);
	}
	public void noticeCacheUnLock(String workid,String userid){
		cacheUser.removeElement(workid, userid);
	}



}
