package com.horizon.wf.third.hz.form;

import java.util.ArrayList;
import java.util.List;

import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.rule.form.FormInfo;
import com.horizon.wf.rule.form.IFormInfo;

public class FormInfoImpl implements IFormInfo{
	private IFormInfo iFormInfo;
	public FormInfoImpl(){
		iFormInfo = InterfaceFactory
				.getNewInterface("com.horizon.workflow.form.service.impl.AllFormInfoImpl");
	}
	/**
	 * 加载所有的表单列表
	 * @param identifier
	 * @return 
	 */
	public List<FormInfo> loadFormList(String identifier){
		if(iFormInfo != null){
			return iFormInfo.loadFormList(identifier);
		}
		List<FormInfo> result = new ArrayList<FormInfo>();
		for (int i = 0; i < 5; i++) {
			FormInfo form = new FormInfo();
			form.setFormName("测试表单" + i);
			form.setFormId("HZ2882c060baee870160bb519931007" + i);
			form.setFormType(i < 2 ? "1" : i < 4 ? "2" : "3");
			form.setTableId("");
			form.setVersion("6;4;3;2");
			result.add(form);
		}
		return result;
	}
	
	/**
	 * 获取表单对应的所有字段和所有的操作信息
	 * 1.不同的表单信息之间使用逗号(,)隔开,
	 * 2.表单id和字段之间使用波浪号(~)连接,表单id和操作之间使用波浪号(~)链接
	 * 3.同一表单的不同操作使用分号(;)隔开,同一表单的不同字段使用分号(;)隔开
	 * 4.字段和操作之间使用尖号(^)隔开
	 * 5.操作信息在字段信息前面
	 *  formid1~actionid1=name1;actionid2=name2,formid2~actionid1=name1;actionid2=name2 
	 * ^formid1~fieldid1=name1;fieldid2=name2,formid2~fieldid1=name1;fieldid2=name2
	 * @param formidLst
	 * @param identifier
	 * @return 
	 */
	public String getFiledAndActionByFormId(List<String> formidLst,String identifier){
		if(iFormInfo != null){
			return iFormInfo.getFiledAndActionByFormId(formidLst,identifier);
		}
		StringBuilder sb = new StringBuilder();
		for (String formid : formidLst) {
			sb.append(formid).append("~")		//注释2
				.append("actionid1=表单操作1;actionid2=表单操作2")	//注释3
				.append(",");					//注释1
		}
		sb.append("^");							//注释4,注释5
		for (int i = 0, n = formidLst.size(); i < n; i++) {
			String formid = formidLst.get(i);
			sb.append(formid)
					.append("~")				//注释2
					.append("titel=标题;field1=字段" + (i + 1) + "1;field2=字段"
							+ (i + 1) + "2")	//注释3

					.append(",");				//注释1
		}
		return sb.toString();
	}
}
