package com.horizon.wf.third.def.persistence;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.third.Persistence;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.core.responsible.IDBAccess;
/**
 * 读写数据库的接口实现类
 * 调用适配器jar包,此处不建议修改
 * @author liyong
 * @created 2012-11-05
 *
 */
public class DBAccessImpl implements IDBAccess{
	
	private Persistence access = ThirdAdapterFactory.getPersistenceInstance();
	public boolean checkIdentifier(String identifier1, String identifier2) {
		String defaultIdentifier = "system";
    	if(identifier1== null || identifier1.length()==0 || "null".equals(identifier1)){
    		identifier1 = defaultIdentifier;
    	}
    	if(identifier2== null || identifier2.length()==0 || "null".equals(identifier2)){
    		identifier2 = defaultIdentifier;
    	}
    	return identifier1.equalsIgnoreCase(identifier2);
	}
	public List<Object> getAllTablesNameList(String identifier) {
		if(validateIdentifier(identifier)) {return access.getTableNames(identifier);}
		return access.getTableNames();
	}

	public String getAllTablesNames(String identifier) {
		StringBuilder sb = new StringBuilder(2000);
		List<Object> lst = getAllTablesNameList(identifier);
		if(lst == null){ return "";}
		for(int i=0,n=lst.size();i<n;i++){
			sb.append((String)lst.get(i)).append(";");
		}
		return sb.toString().toUpperCase();
	}
	
	public boolean exeSql(String sql, List<? extends Object> lst,String identifier) {
		if(validateIdentifier(identifier)){ return access.executeUpdate(sql,lst,identifier);}
		return access.executeUpdate(sql,lst);
	}

	public boolean executeMultiUpdate(Map<String, List<Object>> lm, String identifier) {
		if(validateIdentifier(identifier)) {return access.executeMultiUpdate(lm,identifier);}
		return access.executeMultiUpdate(lm);
	}

	public boolean executeUpdate(String sql,List<? extends Object> lst,String identifier) {
		if(validateIdentifier(identifier)){ return access.executeUpdate(sql,lst,identifier);}
		return access.executeUpdate(sql,lst);
	}


	public List<List<Object>> getMultiList(String sql, List<? extends Object> lst,String identifier) {
		if(validateIdentifier(identifier)){return access.getMultiList(sql,lst,identifier);}
		return access.getMultiList(sql,lst);
	}

	public List<Map<String, Object>> getMultiMap(String sql,List<? extends Object> lst, String identifier) {
		if(validateIdentifier(identifier)){ return access.getMultiMap(sql,lst,identifier);}
		return access.getMultiMap(sql,lst);
	}
	public <T> List<T> getMultiObject(String sql, List<? extends Object> lst,Class<T> obj, String identifier) {
		if(validateIdentifier(identifier)){
		    return access.getMultiObject(sql, lst, obj,identifier);
		}
		return access.getMultiObject(sql, lst, obj);
	}

	public int getRsCount(String sql, List<? extends Object> lst,String identifier) {
		int k ;
		if(validateIdentifier(identifier)) {k=access.getRsCount(sql, lst,identifier);}
		else {k=access.getRsCount(sql, lst);}
		return k;
	}

	public int getRsCount(String sql, String identifier) {
		if(validateIdentifier(identifier)) {return access.getRsCount(sql,null,identifier);}
		return access.getRsCount(sql,null);
	}

	public <T> T getSingleObject(String sql, List<? extends Object> lst,Class<T> obj, String identifier) {
		if(validateIdentifier(identifier)) {return (T)access.getSingleObject(sql, lst, obj,identifier);}
		return (T)access.getSingleObject(sql, lst, obj);
	}

	public List<Object> getSingleList(String sql, List<? extends Object> lst,String identifier) {
		if(validateIdentifier(identifier)) {return access.getSingleList(sql,lst,identifier);}
		return access.getSingleList(sql,lst);
	}

	public Map<String, Object> getSingleMap(String sql,List<? extends Object> lst, String identifier) {
		if(validateIdentifier(identifier)) {return access.getSingleMap(sql, lst,identifier);}
		return access.getSingleMap(sql, lst);
	}

	public boolean saveObjectToDatabase(Object obj, String tablename,String identifier) {
		Map<String,Object> lm = new LinkedHashMap<String,Object>(1);
		lm.put(tablename,obj);
		if(validateIdentifier(identifier))	{
		    return  access.saveObjectData(lm,identifier);
		}	
		return  access.saveObjectData(lm);
	}

	public boolean validateIdentifier(String dbIdentifier) {
		return access.validateIdentifier(dbIdentifier);
	}

	public <T> List<T> getPagingObject(String sql, List<? extends Object> lst,int pageNum, int pageSize, Class<T> obj, String identifier){
		if(validateIdentifier(identifier))	{
		    return  access.getPagingObject(sql, lst, pageNum, pageSize, obj, identifier);
		}	
		return  access.getPagingObject(sql, lst, pageNum, pageSize, obj);

	}
	public List<Map<String, Object>> getPagingMap(String sql,List<? extends Object> lst,int pageNum, int pageSize, String identifier) {
		if(validateIdentifier(identifier)){ return access.getPagingMap(sql,lst,pageNum,pageSize,identifier);}
		return access.getPagingMap(sql,lst,pageNum,pageSize);
	}
	
	public String getDbType(String identifier){
		return access.getDbType(identifier);
	}
}
