package com.horizon.wf.third.def.organization;

import java.util.List;
import java.util.Map;

import com.horizon.third.Organization;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.expand.impl.IOrganizationInterface;

/**
 * 流程组织机构接口适配类
 * 调用适配器jar包,此处不建议修改
 * @author liys
 * @version 1.0
 * @since v7.0
 *
 */
public class OrganizationImpl implements IOrganizationInterface{
	private  Organization org;
	public void setTenantid(String tenantid){
		org = ThirdAdapterFactory.getOrganizationInstance(tenantid);
	}


	/**
	 *
	 * 去掉orgs中不存在的组织机构id
	 * @param orgs 组织机构id字符串
	 * @return
	 */
	public String removeNotExitsOrg(String orgs,String identifier){
		return org.removeNotExitsOrg(orgs, identifier);
	}
	/**
	 * 根据给定的部门id获取部门下的用户
	 * @param deptid ：多个部门id以";"隔开
	 * @param identifier
	 * @param isHaveSubDept 是否含有子部门
	 * 						true:含有子部门
	 * 						false：不含子部门
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromDept(String deptid,boolean isHaveSubDept,String identifier){
		return org.getAllUserFromDept(deptid, isHaveSubDept, identifier);
	}

	/**
	 * 根据给定的群组id获取群组下的用户
	 * @param groupid ：多个部门id以";"隔开
	 * @param identifier
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromGroup(String groupid,String identifier){
		return org.getAllUserFromGroup(groupid, identifier);
	}

	/**
	 * 根据给定的岗位id获取岗位下的用户
	 * @param postionid ：多个岗位id以";"隔开
	 * @param identifier
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromPosition(String postionid,String identifier){
		return org.getAllUserFromPosition(postionid, identifier);
	}

	/**
	 * 根据组织机构中的人员之间的关系获取人员(比如根据userid来获取直接领导,下属)
	 * @param para map中的key和value说明如下
	 * key = userID 	value = String 流程当前办理用户id
	 * key = creator value = String 流程创建用户id
	 * key = done 	value = String[] 目标节点历史办理人id
	 * key = base 	value = int[] 基准 0=无,1=指定节点办理人,2=创建者,3=当前执行人curUser
	 * key = tarRange 	value = String[] 相对岗位
	 * key = gathertype  value = int[]  交集并集默认2并集
	 * key = relation	value = String[] 关系编号
	 * @return 返回用户id，当有多个用户id时，';'隔开
	 */
	public String getRelationUser(Map<String,Object> para,String identifier){
		return org.getRelationUser(para, identifier);
	}


	/**
	 * 获取给定用户的所有相关id
	 * @param userid
	 * @param identifier
	 * @return
	 */
	public String getAllUserids(String userid,String identifier){
		return org.getAllUserids(userid,identifier);
	}

	/**
	 * 根据userid获取用户相关信息
	 * @param userid
	 * @param identifier
	 * @return
	 */
	public Map<String,String> getUserById(String userid ,String identifier){
		return org.getUserById(userid, identifier);
	}

	/**
	 * 获取给定部门deptid的下级子部门id
	 * @param deptid
	 * @param identifier
	 * @return
	 */
	public String getSubDeptIdById(String deptid,String identifier){
		return org.getSubDeptIdById(deptid, identifier);
	}
	/**
	 * 获取指定userid所在的直属部门id
	 * @param userid
	 * @param identifier
	 * @return
	 */
	public String getDeptIdByUserid(String userid,String identifier){
		return org.getDeptIdByUserid(userid, identifier);
	}
	/**
	 * 获取指定id的中文名称,id可能是任何组织类型
	 *
	 * @param orgids
	 * @param identifier
	 * @return
	 */
	public String getNameByIds(String orgids, String identifier){
		return org.getNameByIds(orgids, identifier);
	}
	/**
	 * 根据userids获取多个用户的相关信息
	 * @param userids
	 * @param identifier
	 * @return
	 */
	public List<Map<String,String>> getUserByIDs(String[] userids,String identifier){
		return org.getUserByIDs(userids, identifier);
	}
	/**
	 * 根据deptids获取多个部门的相关信息
	 * @param deptids
	 * @param identifier
	 * @return
	 */
	public List<Map<String,String>> getDeptsByIDs(String[] deptids,String identifier){
		return org.getDeptsByIDs(deptids, identifier);
	}
	/**
	 * 根据groupids获取多个群组的相关信息
	 * @param groupids
	 * @param identifier
	 * @return
	 */
	public List<Map<String,String>> getGroupByIDs(String[] groupids,String identifier){
		return org.getGroupByIDs(groupids, identifier);
	}
	/**
	 * 根据positionids获取多个岗位的相关信息
	 * @param positionids
	 * @param identifier
	 * @return
	 */
	public List<Map<String,String>> getPositionByIDs(String[] positionids,String identifier){
		return org.getPositionByIDs(positionids, identifier);
	}
	/**
	 * 根据deptid以及职务类型查询指定的用户id
	 * @param deptid
	 * @param type 职务类型
	 * @param identifier
	 * @return
	 */
	public String getDeptSpecialUser(String deptid,String type,String identifier){
		return org.getDeptSpecialUser(deptid, type, identifier);
	}
}