package com.horizon.wf.third.def.organization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.expand.impl.IOrganizationInterface;

/**
 * 流程组织机构接口适配类 调用适配器jar包,此处不建议修改
 * 
 * @author liys
 * @version 1.0
 * @since v7.0
 *
 */
public class ExampleOrganizationImpl implements IOrganizationInterface {
	public void setTenantid(String tenantid) {
	}

	/**
	 * 去掉orgs中不存在的组织机构id com.horizon.wf.rule.defa.core.EntryRuleDefault 使用
	 * 
	 * @param orgs
	 *            组织机构id字符串
	 * @return
	 */
	public String removeNotExitsOrg(String orgs, String identifier) {
		return orgs;
	}

	/**
	 * 根据组织机构中的人员之间的关系获取人员(比如根据userid来获取直接领导,下属)
	 * 
	 * @param para
	 *            map中的key和value说明如下 key = userID value = String 流程当前办理用户id key
	 *            = creator value = String 流程创建用户id key = done value = String[]
	 *            目标节点历史办理人id key = base value = int[] 基准
	 *            0=无,1=指定节点办理人,2=创建者,3=当前执行人curUser key = tarRange value =
	 *            String[] 相对岗位 key = gathertype value = int[] 交集并集默认2并集 key =
	 *            relation value = String[] 关系编号
	 * @return 返回用户id，当有多个用户id时，';'隔开
	 */
	public String getRelationUser(Map<String, Object> para, String identifier) {
		return "";
	}

	/**
	 * 获取给定用户的所有相关id com.horizon.wf.api.WorkflowOperator 使用
	 * 
	 * @param userid
	 * @param identifier
	 * @return
	 */
	public String getAllUserids(String userid, String identifier) {
		return userid;
	}

	/**
	 * 根据给定的部门id获取部门下的用户 com.horizon.wf.third.hz.rule.drools.RuleFun 使用
	 * 
	 * @param deptid
	 *            ：多个部门id以";"隔开
	 * @param identifier
	 * @param isHaveSubDept
	 *            是否含有子部门 true:含有子部门 false：不含子部门
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromDept(String deptid, boolean isHaveSubDept,
			String identifier) {
		return deptid;
	}

	/**
	 * 根据给定的群组id获取群组下的用户 com.horizon.wf.third.hz.rule.drools.RuleFun 使用
	 * 
	 * @param groupid
	 *            ：多个部门id以";"隔开
	 * @param identifier
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromGroup(String groupid, String identifier) {
		return groupid;
	}

	/**
	 * 根据给定的岗位id获取岗位下的用户 com.horizon.wf.third.hz.rule.drools.RuleFun 使用
	 * 
	 * @param postionid
	 *            ：多个岗位id以";"隔开
	 * @param identifier
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromPosition(String postionid, String identifier) {
		return postionid;
	}

	/**
	 * 获取给定部门deptid的下级子部门id
	 * com.horizon.wf.rule.defa.CheckRoleForOpenInstanceDefault 使用
	 * 
	 * @param deptid
	 * @param identifier
	 * @return
	 */
	public String getSubDeptIdById(String deptid, String identifier) {
		return deptid;
	}

	/**
	 * 获取指定userid所在的直属部门id com.horizon.wf.api.WorkflowManager使用
	 * 
	 * @param userid
	 * @param identifier
	 * @return
	 */
	public String getDeptIdByUserid(String userid, String identifier) {
		return "";
	}

	/**
	 * 根据userid获取用户相关信息
	 * 
	 * @param userid
	 * @param identifier
	 * @return
	 */
	public Map<String, String> getUserById(String userid, String identifier) {
		Map<String,String> map = new HashMap<String,String>();
		map.put("id", userid);
		map.put("name",userid);
		return map;
	}

	/**
	 * 获取指定id的中文名称,id可能是任何组织类型
	 * 
	 * @param orgids
	 * @param identifier
	 * @return
	 */
	public String getNameByIds(String orgids, String identifier) {
		return orgids;
	}

	/**
	 * 根据userids获取多个用户的相关信息
	 * 
	 * @param userids
	 * @param identifier
	 * @return
	 */
	public List<Map<String, String>> getUserByIDs(String[] userids,
			String identifier) {
		List<Map<String,String>> list = new ArrayList<Map<String,String>>();
		for(int i=0,n=userids.length;i<n;i++){
			Map<String,String> map = new HashMap<String,String>();
			map.put("id", userids[i]);
			map.put("name",userids[i]);
		}
		return list;
	}

	/**
	 * 根据deptids获取多个部门的相关信息
	 * 
	 * @param deptids
	 * @param identifier
	 * @return
	 */
	public List<Map<String, String>> getDeptsByIDs(String[] deptids,
			String identifier) {
		List<Map<String,String>> list = new ArrayList<Map<String,String>>();
		for(int i=0,n=deptids.length;i<n;i++){
			Map<String,String> map = new HashMap<String,String>();
			map.put("id", deptids[i]);
			map.put("dept_name",deptids[i]);
		}
		return list;
	}

	/**
	 * 根据groupids获取多个群组的相关信息
	 * 
	 * @param groupids
	 * @param identifier
	 * @return
	 */
	public List<Map<String, String>> getGroupByIDs(String[] groupids,
			String identifier) {
		List<Map<String,String>> list = new ArrayList<Map<String,String>>();
		for(int i=0,n=groupids.length;i<n;i++){
			Map<String,String> map = new HashMap<String,String>();
			map.put("id", groupids[i]);
			map.put("group_name",groupids[i]);
		}
		return list;
	}

	/**
	 * 根据positionids获取多个岗位的相关信息
	 * 
	 * @param positionids
	 * @param identifier
	 * @return
	 */
	public List<Map<String, String>> getPositionByIDs(String[] positionids,
			String identifier) {
		List<Map<String,String>> list = new ArrayList<Map<String,String>>();
		for(int i=0,n=positionids.length;i<n;i++){
			Map<String,String> map = new HashMap<String,String>();
			map.put("id", positionids[i]);
			map.put("position_name",positionids[i]);
		}
		return list;
	}
	public String getDeptSpecialUser(String deptid,String type,String identifier){
		return "";
	}
}
