package com.horizon.wf.third.def.calendar;

import java.util.Date;

import com.horizon.wf.expand.impl.IHZCalendar;
import com.horizon.wf.tools.DateUtil;
/**
 * 跟工作日历相关的实现
 * 默认演示实现
 * @author liys 20180409
 *
 */
public class ExampleHZCalendarImpl implements IHZCalendar{
	public void setTenantid(String tenantid){
	}
	/**
	 * 获取给定两个日期之间的工作日
	 * @param date1 (2015-03-23)
	 * @param date2 (2015-03-21)
	 * date1 > date2 返回2
	 * datatype=0工作日1自然日
	 * @return date1>date2 返回正数,date1<date2 返回负数
	 */
	public int getWorkdaysFromTwoDate(Date date1, Date date2,int datetype) {
		 String[] arrs = DateUtil.getSubtractResArray(date1, date2);
	        int day = -1;
	        switch (datetype) {
	            case 0:
	            	day = Integer.parseInt(arrs[0]);
	                break;
	            case 1:
	                day = Integer.parseInt(arrs[0]);
	                break;
	            case 2:
	                day = Integer.parseInt(arrs[1]);
	                break;
	            case 3:
	                day = Integer.parseInt(arrs[2]);
	                break;
	            default:
	                break;
	        }
	        return day;
	}

	public int getWorkdaysFromTwoDate(String date1, String date2,int datetype) {
		Date dDate1 = DateUtil.getDate(date1,null);
        Date dDate2 = DateUtil.getDate(date2,null);
        return getWorkdaysFromTwoDate(dDate2, dDate1, datetype);
	}
	/**
	 * 根据日期date获取days后的日期(按照datetype指定方式)
	 * @param date			(2015-03-20)
	 * @param datetype		=0工作日		1自然日
	 * @param days			2			
	 * @return				2015-03-24 	2015-03-22
	 */
	public Date getDateAfter(Date date,int datetype,int days){
		Date dDate = DateUtil.addDateDay(date, days);
		return dDate;
	}
	
}
