package com.horizon.wf.third.def.authority;

import com.horizon.third.Authority;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.expand.impl.IAuthority;

/**
 * 权限控制适配器
 * 调用适配器jar包,此处不建议修改
 * @author liys 20150318
 *
 */
public class AuthorityImpl implements IAuthority{
	Authority authority;
	public void setTenantid(String tenantid){
		authority = ThirdAdapterFactory.getAuthorityInstance(tenantid);
	}
	
	/**
	 * 根据流程id获取授权的管理员
	 * @param flowid
	 * @return
	 */
	public String getManager(String flowid){
		return authority.getManager(flowid);
	}
	/**
	 * 判断指定userid是否具有启动flowid流程的权限
	 * @param flowid
	 * @param userid
	 * @return
	 */
	public boolean isStart(String flowid,String userid){
		return authority.isStart(flowid, userid);
	}
	/**
	 * 判断指定userid是否具有flowid流程的管理员权限
	 * @param flowid
	 * @param userid
	 * @return
	 */
	public boolean isManager(String flowid,String userid){
		return authority.isManager(flowid, userid);
	}
	
}
