package com.horizon.wf.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowManager;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.api.bean.TodoPara;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.bean.WorkParaBeanBase;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.entity.db.DBHandover;
import com.horizon.wf.entity.db.DBLog;
import com.horizon.wf.entity.db.DBTask;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.service.IGetBussinessData;
import com.horizon.wf.service.WorkflowService;
import com.horizon.wf.tools.CStrUtil;

//@WebService(endpointInterface="com.horizon.wf.service.WorkflowService" serviceName="WorkflowService" targetNamespace="http://service.wf.horizon.com/")
public class WorkflowServiceImpl implements WorkflowService {
	IWorkflowOperator workflow = WorkflowFactory.getWorkflowOperator();
	IWorkflowManager manager = WorkflowFactory.getWorkflowManager();
	@Override
	public String createInstanceService(WorkParaBeanBase para) {
		WorkParaBean paraBean = WorkParaBean.chgBaseToThis(para);
		
		IWorkResult resultBean = workflow.create(paraBean);
		String result = objectToJson(resultBean);
		return result;
	}

	@Override
	public String openInstanceService(WorkParaBeanBase para) {
		WorkParaBean paraBean = WorkParaBean.chgBaseToThis(para);
		IWorkResult resultBean = workflow.open(paraBean);
		String result = objectToJson(resultBean);
		
		String className = para.getBussinessClassForOpenByService();
		if(CStrUtil.isNotNull(className)){
		    IGetBussinessData dataObj = InterfaceFactory.getNewInterface(className);
		    if(dataObj !=null){
		       dataObj.setWorkResultBean(resultBean);
		       String  data = dataObj.getDataJson(); 
		       if(CStrUtil.isNotNull(data)){
		           StringBuilder sb = new StringBuilder(10000);
		           sb.append(result.substring(0, result.length() - "</WorkResultBean>".length()));
		           sb.append("<FormData>");
		           sb.append(data);		           
		           sb.append("</FormData>");
		           sb.append("</WorkResultBean>");
		           return sb.toString();
		       }
		    }
		}
		
		return result;
	}

	@Override
	public String operatorService(WorkParaBeanBase para) {
		WorkParaBean paraBean = WorkParaBean.chgBaseToThis(para);
		IWorkResult resultBean = workflow.operator(paraBean);
		String result = objectToJson(resultBean);
		return result;
	}
	private String objectToJson(IWorkResult resultBean){
		return resultBean.forServiceString();
	}
//	public ResultBean testOpenInstanceService(WorkParaBeanBase para){
//		WorkParaBean paraBean = WorkParaBean.chgBaseToThis(para);
//		IWorkResult resultBean = workflow.open(paraBean);
//		ResultBean result = resultBean.chgToServiceResultBean();
//		return result;
//	}
	
	@Override
	public void closeInstance(String workid, String trackid, String userid) {
		workflow.close(workid, trackid, userid);
	}

	@Override
	public List<DBLog> getHistory(String workid, String identifier) {
		List<DBLog> list = workflow.getHistory(workid, identifier);
		return list;
	}
//=================================================================
	@Override
	public boolean handoverWork(HandoverParaData para) {
		Map<String, String> data = new HashMap<String,String>();
		boolean preservePermissions = para.isPreservePermissions();
		String tenantid = para.getTenantid();
		String identifier = para.getIdentifier();
		data.put("newusername", para.getNewusername());
		data.put("oldusername", para.getOldusername());
		data.put("olduserid", para.getOlduserid());
		data.put("newuserid", para.getNewuserid());
		data.put("workid", para.getWorkid());
		data.put("trackid", para.getTrackid());
		
		List<Map<String, String>> list = new ArrayList<Map<String, String>>();
		list.add(data);
		return manager.handoverWork(list, preservePermissions, tenantid,identifier);
	}

	@Override
	public String receiveHandoverWork(
			List<DBHandover> list, String tenantid, String identifier) {
		Map<DBHandover,String> map = manager.receiveHandoverWork(list, tenantid, identifier);
		StringBuilder result = new StringBuilder(1000);
		Iterator<Map.Entry<DBHandover,String>> iter = map.entrySet().iterator();
		result.append("<Result>");
		while (iter.hasNext()) {
			Map.Entry<DBHandover,String> entry = (Map.Entry<DBHandover,String>) iter.next();
			DBHandover key = entry.getKey();
			String value = entry.getValue();
			CStrUtil.appendTo(result, key.getId(), value);
		}
		result.append("</Result>");
		return result.toString();
	}

//	@Override
//	public boolean activeTrack(String workid, String trackid,
//			String interfaceClass, String tenantid, String identifier) {
//		
//		try {
//			return manager.activeTrack(workid, trackid, interfaceClass, tenantid, identifier);
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		return false;
//	}

	@Override
	public boolean replaceWork(String workid, int version, String tenantid,
			String identifier) {
		return manager.replaceWork(workid, version, tenantid, identifier);
	}

	@Override
	public int getWorkMaxVersion(String workid, String tenantid,
			String identifier) {
		return manager.getWorkMaxVersion(workid, tenantid, identifier);
	}


	@Override
	public String pauseWorkMulti(String[] workids, String[] trackids,
			String tenantid, String identifier) {
		return manager.pauseWork(workids, trackids, tenantid,identifier);
	}
//	@Override
//	public String restoreWorkMulti(String[] workids, String[] trackids,
//			String tenantid, String identifier) {
//		return manager.restoreWork(workids, trackids, tenantid, identifier);
//	}

	@Override
	public String stopWorkMulti(String[] workids, String[] trackids,
			String tenantid, String identifier) {
		return manager.stopWork(workids, trackids, tenantid, identifier);
	}
	@Override
	public boolean deleteWorkMulti(String[] workids, String tenantid,
			String identifier) {
		return manager.deleteWork(workids, tenantid, identifier);
	}
	@Override
	public int getSelectType(String workid, String trackid, String tenantid,
			String identifier) {
		return manager.getSelectType(workid, trackid, tenantid, identifier);
	}

	@Override
	public boolean replaceAuthor(String workid, String trackid, String userids,
			String tenantid, String identifier) {
		return manager.replaceAuthor(workid, trackid, userids, tenantid, identifier);
	}

	@Override
	public HashMap<String, Boolean> updateWorkMulti(String[] workids,
			String tenantid, String identifier) {
		Map<String, Boolean> map = manager.updateWork(workids, tenantid, identifier);
		HashMap<String, Boolean> result = new HashMap<String, Boolean>();
		result.putAll(map);
		return result;
	}

	
	public List<DBTodo> getTodoList(TodoPara todoPara){
		return manager.getTodoList(todoPara);
	}
	public int getTodoCount(TodoPara todoPara){
		return manager.getTodoCount(todoPara);
	}
	
	public List<DBTodo> getHasTodoList(TodoPara todoPara){
		return manager.getHasTodoList(todoPara);
	}
	public int getHasTodoCount(TodoPara todoPara){
		return manager.getHasTodoCount(todoPara);
	}
	
	public List<DBTodo> getHaveReadList(TodoPara todoPara){
		return manager.getHaveReadList(todoPara);
	}
	public int getHaveReadCount(TodoPara todoPara){
		return manager.getHaveReadCount(todoPara);
	}
	
	public List<DBTodo> getCReaderList(TodoPara todoPara){
		return manager.getCReaderList(todoPara);
	}
	public int getCReaderCount(TodoPara todoPara){
		return manager.getCReaderCount(todoPara);
	}
	
	public List<DBWork> getMyStartList(TodoPara todoPara){
		return manager.getMyStartList(todoPara);
	}
	public int getMyStartCount(TodoPara todoPara){
		return manager.getMyStartCount(todoPara);
	}
	
	public List<DBTodo> getClaimList(TodoPara todoPara){
		return manager.getClaimList(todoPara);
	}
	public int getClaimCount(TodoPara todoPara){
		return manager.getClaimCount(todoPara);
	}
	
	public List<DBTodo> getToBeReadList(TodoPara todoPara){
		return manager.getToBeReadList(todoPara);
	}
	public int getToBeReadCount(TodoPara todoPara){
		return manager.getToBeReadCount(todoPara);
	}
//	=================================================================	
	@Override
	public boolean agentUserSet(AgentParaData para){
		Map<String, String> hashMap = new HashMap<String, String>();
		String tenantid = para.getTenantid();
		String dbIdentifier = para.getIdentifier();
		hashMap.put("userid",para.getUserid());// 被代理人id
		hashMap.put("username",para.getUsername());// 被代理人名称
		hashMap.put("userdeptname",para.getUserdeptname());// 被代理人部门
		hashMap.put("agentName",para.getAgentName());// 代办人名称
		hashMap.put("agentID",para.getAgentID());// 代办人id
		hashMap.put("noticetype",para.getNoticetype());// 发送消息类型
		hashMap.put("ids",para.getIds());// 设置代办时格式：流程id~流程name|流程id~流程name|流程id~流程name；取消代办时格式：流程id~agent表id|流程id~agent表id
		hashMap.put("actionName",para.getActionName());// 1：设置代办
		hashMap.put("movetodo",para.getMovetodo());// 1:转移代办
		hashMap.put("begindate",para.getBegindate());// 开始时间
		hashMap.put("enddate",para.getEnddate());// 结束时间
		
		return AgentUtil.getInstance().agentUserSet(hashMap, tenantid, dbIdentifier);
	}

	@Override
	public List<DBTask> getTask(String where,List<String> para,String tenantid, String identifier) {
		if(para!=null && para.size()==1 && para.get(0).equals("")){
			para = null;
		}
		return manager.getTask(where,para,tenantid, identifier);
	}
	//====================================================================
	//*
	@Override
	public boolean pauseWork(String workid, String trackid, String tenantid,
			String identifier) {
		return manager.pauseWork(workid, trackid, tenantid, identifier);
	}
//	public boolean restoreWork(String workid, String trackid, String tenantid,
//			String identifier) {
//		return manager.restoreWork(workid, trackid, tenantid, identifier);
//	}
	@Override
	public boolean stopWork(String workid, String trackid, String tenantid,
			String identifier) {
		return manager.stopWork(workid, trackid, tenantid, identifier);
	}
	@Override
	public boolean deleteWork(String workid, String tenantid, String identifier) {
		return manager.deleteWork(workid, tenantid, identifier);
	}
	
	@Override
	public boolean updateWork(String workid, String tenantid, String identifier) {
		return manager.updateWork(workid, tenantid, identifier);
	}
	//*/
}
