package com.horizon.wf.service.impl;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.service.IGetBussinessData;
import com.horizon.wf.tools.AccessUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
/**
 * 演示程序
 * 获取业务数据接口实现类
 * @author liys
 *
 */
public class GetBussinessDataImpl implements IGetBussinessData {
    private IWorkResult resultBean;
    public void setWorkResultBean(IWorkResult resultBean) {
        this.resultBean = resultBean;
    }

    public String getDataJson() {
        IFlowInfo flowInfo = resultBean.getFlowinfo();
        //当前用户的控制信息节点名称
        String controlNodeName = resultBean.getCurUser().getControlNodeName();   
        //当前节点
        IFlowNode curNode = resultBean.getCurFlowNode();
        //根据当前用户的控制信息节点名称,获取当前用户的节点控制信息对象
        INodeControl iXmlControl = curNode.getParticipantsControl(controlNodeName);
        List<INodeForm> forms = new ArrayList<INodeForm>();
        if(null != iXmlControl){
            forms = iXmlControl.getAllNodeForms();
            for(int i=0,n=forms.size();i<n;i++){
                INodeForm form = forms.get(i);
                String formid = form.getFormid();
//                String formType = flowInfo.getFlowForm(formid).getFormtype();   //表单类型
                if(formid.equalsIgnoreCase("FlowTrack")){
                    continue;
                }
                
                String dataid = resultBean.getDataidByFormid(formid);
                String tablename = flowInfo.getFlowForm(formid).getTableid();
                //根据dataid和tablename获取业务数据,并返回json格式的数据
                //需要校验dataid是否为空,在没有数据时
                
                String sql = "select * from "+tablename+" where id=?";
                List<String> para = new ArrayList<String>(1);
                para.add(dataid);
                Map<String,Object> data =  AccessUtil.getInstance()
                        .getSingleMap(sql, para, resultBean.getWorkParaBean().getDataIdentifier());
                
                
            }
           
        }
       
        return "";
    }

}
