package com.horizon.wf.service;

import java.util.HashMap;
import java.util.List;

import javax.jws.WebService;

import com.horizon.wf.api.bean.TodoPara;
import com.horizon.wf.bean.WorkParaBeanBase;
import com.horizon.wf.entity.db.DBHandover;
import com.horizon.wf.entity.db.DBLog;
import com.horizon.wf.entity.db.DBTask;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.service.impl.AgentParaData;
import com.horizon.wf.service.impl.HandoverParaData;
@WebService
public interface WorkflowService {
	
	/**
	 * 创建流程实例
	 * @param para 传入参数
	 * @return IWorkResult对应的xml
	 */
	public String createInstanceService(WorkParaBeanBase para);
	/**
	 * 打开流程实例
	 * @param para 传入参数
	 * @return IWorkResult对应的xml
	 */
	public String openInstanceService(WorkParaBeanBase para);
	
	/**
	 * 操作执行
	 * @param para 传入参数
	 * @return IWorkResult对应的xml
	 */
	public String operatorService(WorkParaBeanBase para);
	
//	public ResultBean testOpenInstanceService(WorkParaBeanBase para);
	
	/**
	 * 关闭实例
	 * @param workid 实例id
	 * @param trackid 路径id
	 * @param userid 用户id
	 */
	public void closeInstance(String workid,String trackid,String userid);
	/**
	 * 获取历史记录
	 * @param workid 实例id
	 * @param identifier 数据源标识符
	 * @return 实例日志
	 */
	public List<DBLog> getHistory(String workid, String identifier);
	
	//============================================================================
	/**
	 * 工作移交(此方法只做移交标记,并不实际修改权限,实际权限更改在接收人接收后执行)
	 * @return 移交是否成功
	 */
//	public boolean handoverWork(HashMap<String,String> para, boolean preservePermissions,String tenantid,String identifier);
	public boolean handoverWork(HandoverParaData para);
	/**
	 * 接收工作移交
	 * @param list DBHandover对象列表
	 * @param tenantid 租户id
	 * @param identifier 数据源标识
	 * @return 接收结果信息
	 */
	public String receiveHandoverWork(List<DBHandover> list,String tenantid, String identifier);
	/**
	 * 激活流程
	 * @param workid 实例id
	 * @param trackid 路径id
	 * @param interfaceClass 激活时要执行的类
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 激活是否成功
	 * @throws Exception 
	 */
	//public boolean activeTrack(String workid,String trackid,String interfaceClass,String tenantid,String identifier);
	/**
	 * 恢复实例数据
	 * @param workid 实例id
	 * @param version 版本号
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 恢复实例数据是否成功
	 */
	public boolean replaceWork(String workid,int version,String tenantid,String identifier);
	
	/**
	 * 获取当前实例的最大版本号
	 * @param workid 实例id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 当前实例的最大版本号
	 */
	public int getWorkMaxVersion(String workid,String tenantid,String identifier);

	/**
	 * 批量暂停流程实例
	 * @param workids 实例id
	 * @param tenantid 租户id
	 * @param identifier 数据源标识
	 * @return 暂停流程实例是否成功
	 */
	public String pauseWorkMulti(String[] workids,String[] trackids,String tenantid,String identifier);
	
	/**
	 * 批量恢复流程实例(同一事物)
	 * @param workids 实例id
	 * @param trackids 路径id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 恢复流程是否成功
	 */
//	public String restoreWorkMulti(String[] workids,String[] trackids,String tenantid,String identifier);
	
	
	/**
	 * 批量结束实例(同一事物)
	 * @param workids 实例id
	 * @param trackids 路径id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 结束实例是否成功
	 */
	public String stopWorkMulti(String[] workids,String[] trackids,String tenantid,String identifier);
	/**
	 * 获取当前节点选择参与者的类型  
	 * @param workid 实例id
	 * @param trackid 路径id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 0:异常 1：单选  2：多选
	 */
	public int getSelectType(String workid,String trackid,String tenantid,String identifier);

	/**
	 * 替换处理人
	 * @param workid 实例id
	 * @param trackid 路径id
	 * @param userids 要替换的参与者
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 替换处理人是否成功
	 */
	public boolean replaceAuthor(String workid,String trackid,String userids,String tenantid,String identifier);
	
	/**
	 * 批量删除流程实例（同一事物）
	 * @param workids 实例id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 删除实例是否成功
	 */
	public boolean deleteWorkMulti(String[] workids,String tenantid,String identifier);
	
	
	/**
	 * 批量更新实例
	 * @param workids 实例id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 批量更新实例是否成功
	 */
	public HashMap<String, Boolean> updateWorkMulti(String[] workids,String tenantid,String identifier);
//	========================================================================
	/**
	 * 待办查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getTodoList(TodoPara todoPara);
	/**
	 * 待办数量查询
	 * @param todoPara
	 * @return
	 */
	public int getTodoCount(TodoPara todoPara);
	
	/**
	 * 已办查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getHasTodoList(TodoPara todoPara);
	/**
	 * 已办数量查询
	 * @param todoPara
	 * @return
	 */
	public int getHasTodoCount(TodoPara todoPara);
	/**
	 * 已阅查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getHaveReadList(TodoPara todoPara);
	/**
	 * 已阅数量查询
	 * @param todoPara
	 * @return
	 */
	public int getHaveReadCount(TodoPara todoPara);
	/**
	 * 可阅查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getCReaderList(TodoPara todoPara);
	/**
	 * 可阅数量查询
	 * @param todoPara
	 * @return
	 */
	public int getCReaderCount(TodoPara todoPara);
	/**
	 * 某人启动的实例查询
	 * @param todoPara
	 * @return
	 */
	public List<DBWork> getMyStartList(TodoPara todoPara);
	/**
	 * 启动的实例数量查询
	 * @param todoPara
	 * @return
	 */
	public int getMyStartCount(TodoPara todoPara);
	/**
	 * 某人启动的草稿
	 * @param todoPara
	 * @return
	 */
//	public List<DBWork> getMyDraft(TodoPara todoPara);
	/**
	 * 某人的草稿数量
	 * @param todoPara
	 * @return
	 */
//	public int getMyDraftCount(TodoPara todoPara);
	/**
	 * 认领查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getClaimList(TodoPara todoPara);
	/**
	 * 认领数量查询
	 * @param todoPara
	 * @return
	 */
	public int getClaimCount(TodoPara todoPara) ;
	/**
	 * 待阅查询
	 * @param todoPara
	 * @return
	 */
	public List<DBTodo> getToBeReadList(TodoPara todoPara) ;
	/**
	 * 待阅数量查询
	 * @param todoPara
	 * @return
	 */
	public int getToBeReadCount(TodoPara todoPara) ;
//========================================================================	
	/**
	 * 代办设置
	 * @return
	 */
//	public boolean agentUserSet(HashMap<String,String> hashMap,String tenantid, String dbIdentifier);
	public boolean agentUserSet(AgentParaData para);
	/**
	 * 查询允许催办的记录
	 * @param tenantid 租户id
	 * @param identifier 数据源标示符
	 * @return 允许催办的任务记录
	 */
	public List<DBTask> getTask(String where,List<String> para,String tenantid,String identifier);
	
	/**
	 * 清除所有实例相关表中以TW开头的表数据,tw_hz_flow_def除外
	 * @param tenantid 租户id
	 * @param identifier
	 */
//	public void clearAllInstance(String tenantid,String identifier);
	//==============================================================
	
	/**
	 * 暂停指定workid的流程实例
	 * @param workid 实例id
	 * @param trackid 路径id
	 * @param tenantid 租户id
	 * @param identifier 数据源标识
	 * @return 暂停流程实例是否成功
	 */
	public boolean pauseWork(String workid,String trackid,String tenantid,String identifier);
	/**
	 * 恢复流程
	 * @param workid 实例id
	 * @param trackid 路径id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 恢复流程是否成功
	 */
//	public boolean restoreWork(String workid,String trackid,String tenantid,String identifier);
	/**
	 * 结束实例
	 * @param workid 实例id
	 * @param trackid 路径id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 结束实例是否成功
	 */
	public boolean stopWork(String workid,String trackid,String tenantid,String identifier);
	/**
	 * 删除单个实例
	 * @param workid 实例id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 删除实例是否成功
	 */
	public boolean deleteWork(String workid,String tenantid,String identifier);
	/**
	 * 更新指定实例的xml
	 * @param workid 实例id
	 * @param tenantid 租户id
	 * @param identifier 数据库标识
	 * @return 更新指定实例的xml是否成功
	 */
	public boolean updateWork(String workid,String tenantid,String identifier);
}
