package com.horizon.wf.runmsg;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.core.runmsg.IRunMsg;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.tools.DateUtil;
/**
 * 程序执行过程记录
 * [Msg]一般信息
 * [WF]来源配置信息
 * [IO]读写数据库
 * [License]License验证信息
 * [Impl]接口方法执行
 * [Err]抛出异常时信息try{}catch(){Err信息}
 * [Warring]
 * @author liyong
 * @created 2012-11-05
 */
public class RunMsgImpl implements IRunMsg {
	private Exception e;
	private StringBuilder message = new StringBuilder(10000);
	private long startTime = Calendar.getInstance().getTimeInMillis();
	private long preTime = startTime;
	private long exeTime = 0;
	public RunMsgImpl(){
		message.append("\n").append(DateUtil.getNow()).append("[Total Time,Part time]");
	}
	
	public void setException(Exception e){
		this.e = e;
	}
	
	public void addMsg(String msg) {
		try{
			long nowTime = Calendar.getInstance().getTimeInMillis();
			long difTime = nowTime - preTime;
			exeTime = nowTime - startTime;
			preTime = nowTime;
			if(difTime >50) {
				message.append("\n").append("[");
				message.append(exeTime).append(",");
				message.append(difTime).append("]... ...");
				message.append(msg);
			}
		}catch(Exception e){
			
		}
	}

	public String getMsg() {
		addMsg("End");
		message.append("\n").append(DateUtil.getNow());
		String msg = message.toString();
		clear();
		return msg;
	}
	public void printMsg() {
		if(HZResourceBundle.getInstance().isDebug()) {
			System.out.println(getMsg());
		}
	}
	
	public String getMsgAndClear(){
		String msg = getMsg();
		return msg;
	}
	
	public void printMsgAndClear(){
		StaticFunExtend.println(getMsgAndClear());
		if(e != null){
			e.printStackTrace();
			e = null;
		}
	}
	
	private void clear(){
		message = null;
	}
	public StringBuilder getMsgBuffer() {
		return message;
	}
	
	public void setMsgBuffer(StringBuilder buffer) {
		this.message = buffer;
	}

	/**
	 * 临时信息输出
	 * @param msg
	 */
	public void printMsg(String msg){
		//System.out.println("[ " + Thread.currentThread().getName() + " ] " + msg);
	}

	/**
	 * 输出执行sql及对应的参数列表
	 * @param map
	 */
	public void printMapSQL(Map  map){
		//根据需要决定是否输出,默认不输出
		if(HZResourceBundle.getInstance().isDebug()) {
			System.out.println(getOutString(map));
		}
	}

	private static String getOutString(Map map){
		String sql="";
		StringBuilder sb = new StringBuilder(10000);
		List lstParameters;
		String enter = "\n\r";
		int sqlIndex = 1;
		sb.append(enter).append("-----所有SQL & Parmeters -----[START]");
		for (Iterator it = map.keySet().iterator(); it.hasNext();) {
			sql = (String) it.next();
			List rowsParameters = (List) map.get(sql);

			try {
				//sql = parseHzSql(dbIdentifier, sql);
			} catch (Exception ex) {}

			sb.append(enter).append(sqlIndex).append(". SQL语句: ").append(sql);
			sqlIndex++;
			boolean ig = false;
//			if(sql.indexOf(StaticVar.Table_Work_XML) !=-1 || sql.indexOf(StaticVar.Table_Track_XML)!=-1
//					|| sql.indexOf(StaticVar.Table_Json)!=-1 || sql.indexOf(StaticVar.Table_Json_Ver)!=-1){
//				ig = true;	//忽略参数输出
//			}
			if (rowsParameters != null && !rowsParameters.isEmpty()) {
				Object obj = rowsParameters.get(0);
				if (obj instanceof List) {
					for (int i = 0, len = rowsParameters.size(); i < len; i++) {
						sb.append(enter).append("    (").append(i+1).append(") SQL参数:");
						lstParameters = (List) rowsParameters.get(i);
						zuheSqlParameter(sb, lstParameters,ig);
					}
				} else {
					sb.append(enter).append("    (1) SQL参数:");
					zuheSqlParameter(sb, rowsParameters,ig);
				}
			} else {
				sb.append(enter).append("    没有SQL参数。");
			}
		}

		sb.append(enter).append("----- SQL & Parmeters -----[ END ]");
		return sb.toString();
	}

	private static void zuheSqlParameter(StringBuilder sb, List lstParameters,boolean ig) {

		if (lstParameters==null || lstParameters.isEmpty()) {
			sb.append("没有SQL参数。");
			return;
		}

		String splitor = " , ";
		sb.append(" { ").append(lstParameters.get(0));
		for (int i=1, len=lstParameters.size(); i<len; i++) {
			sb.append(splitor);
			String para  = ""+lstParameters.get(i);
			if(para == null){
				sb.append(para);
			}
			else if(ig || (para.length() > 1000 )){
				sb.append("忽略输出");
			}
			else{
				sb.append(para);
			}
		}
		sb.append(" }");
	}
}
