package com.horizon.wf.runmsg;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;

public class ExceptionLog extends BaseRuleImpl implements IBaseRule{
	//自行确定信息记录到啥地方,调用程序不对返回值进行处理
	public boolean executeRule() {
		//记录异常发生时的信息
		//实例的信息从Runningdata中获取
		RunningData rd = getRunningdata();
		String title = rd.getTitle();
		String workid = rd.getWork().getId();
		//1=程序执行异常,2=操作完毕后的接口执行异常actionAfterSaveToDB,3=节点异常处理
		//=3的时候,参数传递参考com.horizon.wf.action.common.HandleExceptionDelay类中的
		String errType = (String)getParameter("ErrType");
		String memo 	= (String)getParameter("Memo");
		String message = (String)getParameter("Message");
		Exception e=null;
		if(!"3".equals(errType)){
			e = (Exception)getParameter("Exception");
			message = e.getMessage();
		}
		System.out.println(title+"("+workid+")ErrType("+errType+")"+memo+",Msg:"+message);
		if(e != null){
			e.printStackTrace();
		}
		return false;
	}

}
