package com.horizon.wf.rule.form;

import java.util.List;

public interface IFormInfo {
	/**
	 * 加载所有的表单列表
	 * @param identifier
	 * @return 
	 */
	public List<FormInfo> loadFormList(String identifier) ;
	
	/**
	 * 获取表单对应的所有字段和所有的操作信息
	 * 1.不同的表单信息之间使用逗号隔开,
	 * 2.表单id和字段之间使用~连接,表单id和操作之间使用~链接
	 * 3.同一表单的不同操作使用分号隔开,同一表单的不同字段使用分号隔开
	 * 4.字段和操作之间使用^隔开
	 * 5.操作信息在字段信息前面
	 *  formid1~actionid1=name1;actionid2=name2,formid2~actionid1=name1;actionid2=name2 
	 * ^formid1~fieldid1=name1;fieldid2=name2,formid2~fieldid1=name1;fieldid2=name2
	 * @param formidLst
	 * @param identifier
	 * @return 
	 */
	public String getFiledAndActionByFormId(List<String> formidLst,String identifier);
}
