package com.horizon.wf.rule.event;

import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeEvent;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 执行事件
 * @author liangjw
 * @date 2013-06-03
 * @version 1.0
 * @since hz7.0
 *
 */
public class EventUtil {
	//单例
	private static EventUtil eventUtil = new EventUtil(); 
	private EventUtil(){}
	public static EventUtil getInstance(){
		if(null == eventUtil){
			return eventUtil = new EventUtil();
		}
		return eventUtil;
	}
	
	
	/**
	 * 根据事件类型获取事件列表
	 * @param eventType 事件类型
	 * @return 符合条件的事件列表
	 */
	private  List<INodeEvent> getEventByType(IFlowNode xmlNode, String eventType){
		List<INodeEvent> events = xmlNode.getAllEvents();
		List<INodeEvent> returnEvents = new ArrayList<INodeEvent>();
		if(StringUtilExtend.isNull(eventType)){
			return null;
		}
		if(CollectionUtil.isListNotEmpty(events)){
			for(int i=0,n=events.size();i<n;i++){
				INodeEvent event = events.get(i);
				if(eventType.equals(event.getDoType())){
					returnEvents.add(event);
				}
			}
		}
		return returnEvents;
	}
	/**
	 * 创建打开事件执行
	 * @param eventType
	 * @param node
	 * @return
	 */
	public boolean excuteEventsForOpen(IFlowNode node,String eventType,RunningData runningdata){
//		IRunUser curUser = runningdata.getCurUser();
//		String funname = runningdata.getFunname();
//		if(null != curUser){
//			//系统用户不执行事件
//			if(StaticVarExtend.System_Id.equals(curUser.getUserid()) && StaticVarExtend.OPERATOR_FUNNAME_GOTO.equals(funname)){
//				return true;
//			}
//		}
		return excuteEvents(node,eventType,runningdata,true);
	}
	/**
	 * 操作中的事件执行
	 * @param eventType
	 * @param node
	 * @return
	 */
	public boolean excuteEventsForOperator(IFlowNode node,String eventType,RunningData runningdata){
		return excuteEvents(node,eventType,runningdata,false);
	}
	private boolean excuteEvents(IFlowNode node,String eventType,RunningData runningdata,boolean handleException){
		List<INodeEvent> events = getEventByType(node,eventType);
		if(CollectionUtil.isListNotEmpty(events)){
			WorkParaBean paraBean = (WorkParaBean)runningdata.getWorkParaBean();
			for(int i=0,n=events.size();i<n;i++){
				INodeEvent event = events.get(i);
				String script = event.getScript();
				if(StringUtilExtend.isNotNull(script)){
					runningdata.putMsgToConsole("[Msg]=====start event ======EventId:"+event.getEventid()+",EventType:"+event.getDoType()+",event class:"+script);
					//获取前后台交互对象
					Map<String, List<Object>> dataMap = new LinkedHashMap<String, List<Object>>();
					boolean isExcuteSuccess = false;
					try{
						//获取定义工具中的事件实现类
						IBaseRule br = InterfaceFactory.getNewInterface(script);
						br.setParameter(StaticVarExtend.Parameter_WorkParaBean, paraBean);//设置前后台对象到接口
						br.setParameter(StaticVarExtend.Parameter_DBWork, runningdata.getWork());
						br.setParameter(StaticVarExtend.Parameter_RunUser, runningdata.getCurUser());
						br.setParameter(StaticVarExtend.Parameter_DBTrack, runningdata.getCurTrack());
						br.setParameter(StaticVarExtend.Parameter_Current_IFlowNode, runningdata.getCurFlowNode());
						br.setParameter(StaticVarExtend.Parameter_SaveMap,dataMap);
						br.setParameter(StaticVarExtend.Parameter_IFlowNode,node);
						br.setParameter("eventType",eventType);
						br.setRunningData(runningdata);
						//执行配置的实现类
						isExcuteSuccess = br.executeRule();	
					}catch(Exception e){
						runningdata.putMsgToConsole("[err]event excute error.exception code:"+event.getEventname());
						handleEventException(event,runningdata,node,handleException);//处理事件执行过程中抛出的异常
						return false;
					}
					//执行成功则将事件实现类中的数据放入流程
					if(isExcuteSuccess){
						if(CollectionUtil.isMapNotEmpty(dataMap)){
					        for (Map.Entry<String, List<Object>> entry : dataMap.entrySet()) {
					        	if(HZResourceBundle.getInstance().isEventSQLAfterBuis()) {
									runningdata.putSQLToDataMapEnd(entry.getKey(), entry.getValue());
								}
								else{
									runningdata.putSQLToDataMap(entry.getKey(), entry.getValue());
								}
					        }							
						}
					}else{
						return false;
					}
					
				}
			}
		}
		return true;
		
	}
	
	/**
	 * 处理事件执行过程中抛出的异常
	 * @param event
	 * @param runningData
	 */
	private  boolean handleEventException(INodeEvent event,RunningData runningData,IFlowNode node,boolean handleException) {
		ActionCommon ac = StaticFunExtend.getActionCommon();
		INodeException exception = null;
		String type = event.getDoType();
		if(type.equals(StaticVarExtend.EVENT_IN)){
			exception = ac.getExceptionByCode(StaticVarExtend.Exception_Code_EventInError, node.getExceptions());
		}else if(type.equals(StaticVarExtend.EVENT_OUT)){
			exception = ac.getExceptionByCode(StaticVarExtend.Exception_Code_EventOutError, node.getExceptions());
		}else if(type.equals(StaticVarExtend.EVENT_OPEN)){
			exception = ac.getExceptionByCode(StaticVarExtend.Exception_Code_EventOpenError, node.getExceptions());
		}else if(type.equals(StaticVarExtend.EVENT_SAVE)){
			exception = ac.getExceptionByCode(StaticVarExtend.Exception_Code_EventSaveError, node.getExceptions());
			
			String dealtype = exception.getExceptionDealType();
			
			if(dealtype.equals("2") || dealtype.equals("3") || dealtype.equals("4")){
				return false;
			}
		}else if(type.equals(StaticVarExtend.EVENT_CREATEINSTANCE)){
			exception = ac.getExceptionByCode(StaticVarExtend.Exception_Code_EventCreateInstanceError, node.getExceptions());
		}
		boolean result = true;
		if(null != exception){
			if(handleException){
				result = ac.handleException(exception, runningData,node);
			}
			else{
				result = ac.handleExceptionDelay(exception, runningData,node);
			}
		}
		return result;
	}
}
